/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.values.converters;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.spring.model.values.PropertyValueConverter;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.WrappingConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumValueConverter
extends Converter<PsiField>
implements CustomReferenceConverter {
    public static PsiReference @NotNull [] createReferences(PsiType type, GenericDomValue<?> genericDomValue, PsiElement element) {
        PsiClass psiClass;
        String stringValue = genericDomValue.getStringValue();
        if (type instanceof PsiClassType && (psiClass = ((PsiClassType)type).resolve()) != null) {
            PsiReference[] psiReferenceArray = new PsiReference[]{EnumValueConverter.createReference(psiClass, element, stringValue)};
            if (psiReferenceArray == null) {
                EnumValueConverter.$$$reportNull$$$0(0);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            EnumValueConverter.$$$reportNull$$$0(1);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static PsiReference createReference(final PsiClass psiClass, final PsiElement element, final String stringValue) {
        return new PsiReferenceBase<PsiElement>(element, true){

            public PsiElement resolve() {
                PsiField psiField = psiClass.findFieldByName(stringValue, false);
                if (psiField == null && !psiClass.isEnum()) {
                    return element;
                }
                return psiField;
            }

            public Object @NotNull [] getVariants() {
                Object[] objectArray = EnumValueConverter.getFields(psiClass);
                if (objectArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return objectArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/values/converters/EnumValueConverter$1", "getVariants"));
            }
        };
    }

    public PsiField fromString(@Nullable @NonNls String s, @NotNull ConvertContext context) {
        if (context == null) {
            EnumValueConverter.$$$reportNull$$$0(2);
        }
        return null;
    }

    public String toString(@Nullable PsiField s, @NotNull ConvertContext context) {
        if (context == null) {
            EnumValueConverter.$$$reportNull$$$0(3);
        }
        return null;
    }

    public PsiReference @NotNull [] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
        Converter converter = genericDomValue.getConverter();
        while (converter instanceof WrappingConverter) {
            WrappingConverter wrappingConverter = (WrappingConverter)converter;
            if (converter instanceof PropertyValueConverter) {
                PropertyValueConverter propertyValueConverter = (PropertyValueConverter)converter;
                List types = propertyValueConverter.getValueTypes(genericDomValue);
                for (PsiType type : types) {
                    PsiReference[] psiReferences = EnumValueConverter.createReferences(type, genericDomValue, element);
                    if (psiReferences.length <= 0) continue;
                    if (psiReferences == null) {
                        EnumValueConverter.$$$reportNull$$$0(4);
                    }
                    return psiReferences;
                }
            }
            converter = wrappingConverter.getConverter(genericDomValue);
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            EnumValueConverter.$$$reportNull$$$0(5);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static PsiField[] getFields(@NotNull PsiClass psiClass) {
        PsiField[] psiFields;
        if (psiClass == null) {
            EnumValueConverter.$$$reportNull$$$0(6);
        }
        ArrayList<PsiField> fields = new ArrayList<PsiField>();
        for (PsiField psiField : psiFields = psiClass.getFields()) {
            PsiClass typeClass;
            PsiType type;
            if (!psiField.hasModifierProperty("static") || !psiField.hasModifierProperty("public") || !((type = psiField.getType()) instanceof PsiClassType) || (typeClass = ((PsiClassType)type).resolve()) == null || !typeClass.equals((Object)psiClass)) continue;
            fields.add(psiField);
        }
        return fields.toArray(PsiField.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/values/converters/EnumValueConverter";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/values/converters/EnumValueConverter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFields";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 6 -> new IllegalArgumentException(string);
        };
    }

    public static class TypeCondition
    implements Condition<Pair<PsiType, GenericDomValue<?>>> {
        private final List<String> EXCLUDE_CLASSES = Arrays.asList(Boolean.class.getName(), Locale.class.getName());

        public boolean value(Pair<PsiType, GenericDomValue<?>> pair) {
            PsiType type = (PsiType)pair.getFirst();
            if (type instanceof PsiClassType) {
                if (this.EXCLUDE_CLASSES.contains(type.getCanonicalText())) {
                    return false;
                }
                PsiClass psiClass = ((PsiClassType)type).resolve();
                if (psiClass != null) {
                    if (psiClass.isEnum()) {
                        return true;
                    }
                    for (PsiField psiField : psiClass.getFields()) {
                        if (!psiField.hasModifierProperty("static") || !psiField.hasModifierProperty("public") || !psiField.getType().equals(type)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

