/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.dameng.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.dameng.DamengConstants;
import org.jkiss.dbeaver.ext.dameng.model.DamengDataSource;
import org.jkiss.dbeaver.ext.dameng.model.DamengTablespace;
import org.jkiss.dbeaver.ext.dameng.model.DamengUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPObjectWithLongId;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.access.DBAUser;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class DamengUser
implements DBAUser,
DBPScriptObject,
DBPObjectWithLongId {
    private DamengDataSource dataSource;
    private long id;
    private String name;
    private Timestamp createTime;
    private Type type;
    private LockedStatus lockedStatus;
    private long tablespaceId;

    public DamengUser(DamengDataSource dataSource, JDBCResultSet dbResult) {
        this.dataSource = dataSource;
        this.id = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"ID");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"NAME");
        int typeValue = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"INFO1");
        this.type = Type.values()[typeValue];
        this.tablespaceId = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"TABLESPACE_ID");
        this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CRTDATE");
        this.lockedStatus = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"LOCKED_STATUS") == 2 ? LockedStatus.UNLOCKED : LockedStatus.LOCKED;
    }

    @Property(viewable=true, order=1)
    public long getObjectId() {
        return this.id;
    }

    @Property(viewable=true, order=2)
    @NotNull
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return true;
    }

    public DBSObject getParentObject() {
        return this.getDataSource().getContainer();
    }

    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    @Property(viewable=true, order=4)
    public Type getType() {
        return this.type;
    }

    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        return DamengUtils.getDDL(monitor, (DBSObject)this, DamengConstants.ObjectType.USER, null);
    }

    @Property(viewable=true, order=3)
    public DamengTablespace getTablespace(DBRProgressMonitor monitor) throws DBException {
        return this.dataSource.getTablespaceById(monitor, this.tablespaceId);
    }

    @Property(viewable=true, order=6)
    public Timestamp getCreateTime() {
        return this.createTime;
    }

    @Property(viewable=true, order=5)
    public LockedStatus getLockedStatus() {
        return this.lockedStatus;
    }

    public static enum LockedStatus {
        LOCKED,
        UNLOCKED;

    }

    public static enum Type {
        DBA,
        AUDITOR,
        SSO,
        DBO,
        SYS;

    }
}

