//
// Syd: rock-solid application kernel
// src/utils/syd-exec.rs: Construct a sandbox command to execute a process outside syd.
//
// Copyright (c) 2024, 2025 Ali Polatel <alip@chesswob.org>
//
// SPDX-License-Identifier: GPL-3.0

use std::process::ExitCode;

// Set global allocator to GrapheneOS allocator.
#[cfg(all(
    not(coverage),
    not(feature = "prof"),
    not(target_os = "android"),
    target_page_size_4k,
    target_pointer_width = "64"
))]
#[global_allocator]
static GLOBAL: hardened_malloc::HardenedMalloc = hardened_malloc::HardenedMalloc;

// Set global allocator to tcmalloc if profiling is enabled.
#[cfg(feature = "prof")]
#[global_allocator]
static GLOBAL: tcmalloc::TCMalloc = tcmalloc::TCMalloc;

syd::main! {
    syd::set_sigpipe_dfl()?;

    // Split the arguments using the ASCII Unit Separator character
    let args = std::env::args().skip(1).collect::<Vec<_>>().join("\x1F");

    // Format it using /dev/syd/cmd/exec!<concatenated-path>
    print!("/dev/syd/cmd/exec!{args}");

    Ok(ExitCode::SUCCESS)
}
