/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_yrl extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_hy = "arimẽniu";
        final String metaValue_bax = "bamũ";
        final String metaValue_bn = "bẽgari";
        final String metaValue_bug = "buginei";
        final String metaValue_chr = "xerokí";
        final String metaValue_ka = "geurgianu";
        final String metaValue_got = "gútiku";
        final String metaValue_el = "geregu";
        final String metaValue_he = "heburaiku";
        final String metaValue_jv = "yawanei";
        final String metaValue_ja = "yapunei";
        final String metaValue_km = "kimé";
        final String metaValue_la = "ratĩ";
        final String metaValue_ml = "marayara";
        final String metaValue_mn = "mũgú";
        final String metaValue_my = "birimanei";
        final String metaValue_or = "uriá";
        final String metaValue_phn = "finísiu";
        final String metaValue_si = "sĩgarei";
        final String metaValue_te = "térugu";
        final String metaValue_tl = "tagaru";
        final String metaValue_th = "tairãdei";
        final String metaValue_bo = "tibetanu";
        final String metaValue_uga = "ugarítiku";
        final String metaValue_vai = "wai";
        final String metaValue_type_hc_h12 = "Sistẽma 24 húra-ita (1-24)";
        final Object[][] data = new Object[][] {
            { "001", "Iwi" },
            { "002", "Afirika" },
            { "003", "Amerika Nuti suí" },
            { "005", "Amerika Su suí" },
            { "009", "Useãniya" },
            { "011", "Afirika Usidẽtawara" },
            { "013", "Amerika Piterapura" },
            { "014", "Afirika Uriẽtawara" },
            { "015", "Afirika Nuti suí" },
            { "017", "Afirika Piterapura" },
            { "018", "Afirika Meridiyunau" },
            { "019", "America-ita" },
            { "021", "Amerika Setẽtiriunau" },
            { "029", "Karíbi" },
            { "030", "Ásiya Uriẽtawara" },
            { "034", "Ásiya Meridiyunau" },
            { "035", "Sudeti Ásiyatiku" },
            { "039", "Eurupa Meridiyunau" },
            { "053", "Ausitarasia" },
            { "054", "Meranésiya" },
            { "057", "Micuronesiya Tetãma" },
            { "061", "Pulinesiya" },
            { "142", "Ásiya" },
            { "143", "Ásiya Piterapura" },
            { "145", "Ásiya Usidẽtawara" },
            { "150", "Eurupa" },
            { "151", "Eurupa Uriẽtawara" },
            { "154", "Eurupa Setẽtiriunau" },
            { "155", "Eurupa Usidẽtawara" },
            { "202", "Afirika Subisariana" },
            { "419", "Amerika Latina" },
            { "AC", "Asesãu Kapuãma" },
            { "AD", "Ãdura" },
            { "AE", "Emiradu Árabi Yepewasuwaitá" },
            { "AF", "Afegãniretãma" },
            { "AG", "Ãtigua asuí Babuda" },
            { "AI", "Ãgira" },
            { "AL", "Aubãniya" },
            { "AM", "Arimẽniya" },
            { "AO", "Ãgura" },
            { "AQ", "Ãtartida" },
            { "AR", "Argẽtina" },
            { "AS", "Samua Amerikiwara" },
            { "AT", "Ausitiriya" },
            { "AU", "Ausitaraliya" },
            { "AW", "Aruba" },
            { "AX", "Kapuãma-ita Arãdi" },
            { "AZ", "Aseriretãma" },
            { "BA", "Businiya asuí Eseguwina" },
            { "BB", "Babadu" },
            { "BD", "Bãgaradexi" },
            { "BE", "Beujika" },
            { "BF", "Bukina Fasu" },
            { "BG", "Bugáriya" },
            { "BH", "Barẽi" },
            { "BI", "Burũdi" },
            { "BJ", "Benĩ" },
            { "BL", "Sã Batulumeu" },
            { "BM", "Bemuda" },
            { "BN", "Burunei" },
            { "BO", "Buríwia" },
            { "BQ", "Tetãma Iwiboí-ita Karíbi suí" },
            { "BR", "Brasiu" },
            { "BS", "Bayama" },
            { "BT", "Butãu" },
            { "BV", "Kapuãma Buweti" },
            { "BW", "Butisuwana" },
            { "BY", "Bieru-rúsiya" },
            { "BZ", "Belisi" },
            { "CA", "Kanadá" },
            { "CC", "Kapuãma-ita Kuku (Keering)" },
            { "CD", "Kũgu - Kĩxasa" },
            { "CF", "Repubirika Afirika-Piterapura" },
            { "CG", "Repubirika Kũguyara" },
            { "CH", "Suwisa" },
            { "CI", "Mafim Kupé" },
            { "CK", "Kapuãma-ita Kooki" },
            { "CL", "Xiri" },
            { "CM", "Puty-ita" },
            { "CN", "Xina" },
            { "CO", "Kurũbiya" },
            { "CP", "Kiripetũ Kapuãma" },
            { "CR", "Kupé Rika" },
            { "CU", "Kuba" },
            { "CV", "Kabu Suikiri" },
            { "CW", "Kurasau" },
            { "CX", "Kapuãma Kiritima" },
            { "CY", "Xipiri" },
            { "CZ", "Xekiya" },
            { "DE", "Aremãya" },
            { "DG", "Diyegu Garasiya" },
            { "DJ", "Dijibuti" },
            { "DK", "Dinamaka" },
            { "DM", "Dominika" },
            { "DO", "Repubirika Duminikana" },
            { "DZ", "Argeriya" },
            { "EA", "Seuta asuí Merira" },
            { "EC", "Ekuadú" },
            { "EE", "Isituniya" },
            { "EG", "Egitu" },
            { "EH", "Saara Usidẽtawara" },
            { "ER", "Eritireya" },
            { "ES", "Isipãya" },
            { "ET", "Etiupiya" },
            { "EU", "Eurupa Yepewasusawa" },
            { "EZ", "euru suna" },
            { "FI", "Firãdiya" },
            { "FJ", "Fiyi" },
            { "FK", "Kapuãma-ita Mawina" },
            { "FM", "Mikuruneziya" },
            { "FO", "Kapuãma-ita Faruwe" },
            { "FR", "Frãsa" },
            { "GA", "Gabãu" },
            { "GB", "Reyinu Yepewasú" },
            { "GD", "Garanada" },
            { "GE", "Geugiya" },
            { "GF", "Giyana Frãsa yara" },
            { "GG", "Guwẽnisei" },
            { "GH", "Gana" },
            { "GI", "Gibarautá" },
            { "GL", "Guruẽrãdiya" },
            { "GM", "Gãbiya" },
            { "GN", "Giné" },
            { "GP", "Guadarupi" },
            { "GQ", "Giné Ekuaturiyau" },
            { "GR", "Geresiya" },
            { "GS", "Kapuãma-ita Geugiya Su asuí Sãduwixi Su" },
            { "GT", "Guatemara" },
            { "GU", "Guwã" },
            { "GW", "Giné Bisau" },
            { "GY", "Giyana" },
            { "HK", "Hũgi Kũgi, RAE Xina yara" },
            { "HM", "Kapuãma-ita Heard asuí McDonald" },
            { "HN", "Ũdura" },
            { "HR", "Kuruwasiya" },
            { "HT", "Aití" },
            { "HU", "Ũgiriya" },
            { "IC", "Kapuãma-ita Kanariya" },
            { "ID", "Ĩdunesiya" },
            { "IE", "Irãda" },
            { "IL", "Isirayeu" },
            { "IM", "Mã Kapuãma" },
            { "IN", "Ĩdiya" },
            { "IQ", "Iraki" },
            { "IR", "Irã" },
            { "IS", "Isirãdiya" },
            { "IT", "Itariya" },
            { "JE", "Yesei" },
            { "JM", "Yamaika" },
            { "JO", "Yudãniya" },
            { "JP", "Nipõ" },
            { "KE", "Kẽniya" },
            { "KG", "Kirigiretãma" },
            { "KH", "Kãbuya" },
            { "KI", "Kiribati" },
            { "KM", "Kumure-ita" },
            { "KN", "Sã Kirituwãu suí Newi" },
            { "KP", "Kureya Nuti suí" },
            { "KR", "Kureya Su suí" },
            { "KW", "Kuwaiti" },
            { "KY", "Kapuãma-ita Kaimã" },
            { "KZ", "Kasakiretãma" },
            { "LA", "Rawo" },
            { "LB", "Ribanu" },
            { "LC", "Sãta Lusiya" },
            { "LI", "Rixitẽxitaĩ" },
            { "LK", "Siri Rãka" },
            { "LR", "Ribériya" },
            { "LS", "Resutu" },
            { "LT", "Rituwãniya" },
            { "LU", "Ruxẽbugu" },
            { "LV", "Retuniya" },
            { "LY", "Ribiya" },
            { "MA", "Maruku" },
            { "MC", "Mũnaku" },
            { "MD", "Mũduwa" },
            { "ME", "Mũteneguru" },
            { "MF", "Sã Matiyũ" },
            { "MG", "Madagasiká" },
            { "MH", "Kapuãma-ita Marshall" },
            { "MK", "Masedũniya" },
            { "ML", "Mari" },
            { "MM", "Miyamá (Bimãniya)" },
            { "MN", "Mũguriya" },
            { "MO", "Makau, RAE Xina yara" },
            { "MP", "Kapuãma-ita Mariyãna Nuti suí" },
            { "MQ", "Matinika" },
            { "MR", "Mauritaniya" },
            { "MS", "Mũtiserati" },
            { "MT", "Mauta" },
            { "MU", "Maurisiyu" },
            { "MV", "Maudiwa-ita" },
            { "MW", "Marawi" },
            { "MX", "Mẽsiku" },
            { "MY", "Malasiya" },
            { "MZ", "Musãbiki" },
            { "NA", "Namíbiya" },
            { "NC", "Karedũniya Pisasú" },
            { "NE", "Nige" },
            { "NF", "Kapuãma Norfolk" },
            { "NG", "Nigeriya" },
            { "NI", "Nicaraguwa" },
            { "NL", "Tetãma Iwiboí-ita" },
            { "NO", "Nuruwega" },
            { "NP", "Nepau" },
            { "NR", "Nauru" },
            { "NU", "Niwe" },
            { "NZ", "Serãdiya Pisasú" },
            { "OM", "Umã" },
            { "PA", "Panamã" },
            { "PE", "Peru" },
            { "PF", "Pulinesiya Frãsa yara" },
            { "PG", "Papuwa-Giné Pisasú" },
            { "PH", "Firipina" },
            { "PK", "Pakiretãma" },
            { "PL", "Puluniya" },
            { "PM", "Sã Peduru asuí Mikelãu" },
            { "PN", "Kapuãma-ita Pitcairn" },
            { "PR", "Igarapawa Riku" },
            { "PS", "Tetãma Paretinu-ita yara" },
            { "PT", "Putugau" },
            { "PW", "Parau" },
            { "PY", "Paraguwai" },
            { "QA", "Katara" },
            { "QO", "Useãniya (R)" },
            { "RE", "Yumuatirisawa" },
            { "RO", "Romẽniya" },
            { "RS", "Sewiya" },
            { "RU", "Rusiya" },
            { "RW", "Huãda" },
            { "SA", "Arawia Saudita" },
            { "SB", "Kapuãma-ita Sarumũ" },
            { "SC", "Seixeri" },
            { "SD", "Ausudã" },
            { "SE", "Suwesiya" },
            { "SG", "Sĩgapura" },
            { "SH", "Sãta Erena" },
            { "SI", "Esiruwẽniya" },
            { "SJ", "Siwaubati asuí Yã Mayeni" },
            { "SK", "Esiruwakiya" },
            { "SL", "Iwitera Leowa" },
            { "SM", "Sã Marino" },
            { "SN", "Senegau" },
            { "SO", "Somariya" },
            { "SR", "Suriname" },
            { "SS", "Ausudã Su suí" },
            { "ST", "Sã Tumé asuí Pirĩsipe" },
            { "SV", "Eru Sawadu" },
            { "SX", "Sĩti Maatẽ" },
            { "SY", "Siriya" },
            { "SZ", "Esuatíni" },
            { "TA", "Tiritãu Kũya" },
            { "TC", "Kapuãma-ita Tuka-ita asuí Kaiko-ita" },
            { "TD", "Xade" },
            { "TF", "Tetãma Su-ita Frãsa suí" },
            { "TG", "Togu" },
            { "TH", "Tairetãma" },
            { "TJ", "Tayikiretãma" },
            { "TK", "Tukerau" },
            { "TL", "Timu-Semusawa" },
            { "TM", "Turkuranaretãma" },
            { "TN", "Tunisiya" },
            { "TO", "Tõga" },
            { "TR", "Tukíya" },
            { "TT", "Tirinidadi asuí Tobagu" },
            { "TV", "Tuwaru" },
            { "TW", "Taiwã" },
            { "TZ", "Tãsaniya" },
            { "UA", "Ukarãniya" },
            { "UG", "Ugãda" },
            { "UM", "Kapuãma Kuiriwaita Apekatu EUA suí" },
            { "UN", "Nasãu Yepewasuwaitá" },
            { "US", "Tetãma-ita Yepewasú" },
            { "UY", "Uruguwai" },
            { "UZ", "Yũbuesara-retãma" },
            { "VA", "Watikanu Tawa-wasu" },
            { "VC", "Sã Wisẽti asuí Garanadĩna-ita" },
            { "VE", "Wenesuera" },
            { "VG", "Kapuã-ita Viyẽ-ita Biritãnika-ita" },
            { "VI", "Kapuã-ira Viyẽ-ita Amerikana-ita" },
            { "VN", "Wiyetinã" },
            { "VU", "Wanuatu" },
            { "WF", "Wari asuí Futuna" },
            { "WS", "Samowa" },
            { "XA", "Sutakirana-ita" },
            { "XB", "Bidiresiunaurana" },
            { "XK", "Kusuwu" },
            { "YE", "Yemẽ" },
            { "YT", "Mayuti" },
            { "ZA", "Afirika Su suí" },
            { "ZM", "Sãbiya" },
            { "ZW", "Sĩbabuwe" },
            { "ZZ", "Tetãma Ũbawaukuamamẽ" },
            { "aa", "afari" },
            { "ab", "abikasiyu" },
            { "ae", "awesitiku" },
            { "af", "afiriķãner" },
            { "ak", "akã" },
            { "am", "amáriku" },
            { "an", "aragunẽi" },
            { "ar", "arabi" },
            { "as", "asamei" },
            { "av", "awariku" },
            { "ay", "aimará" },
            { "az", "aserbayanu" },
            { "ba", "baxikiri" },
            { "be", "bierurusu" },
            { "bg", "búgaru" },
            { "bi", "bisiramá" },
            { "bm", "bãbara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "beretãu" },
            { "bs", "businiu" },
            { "ca", "katará" },
            { "ce", "xexenu" },
            { "ch", "xamuru" },
            { "co", "curisu" },
            { "cr", "kiri" },
            { "cs", "tieku" },
            { "cu", "isirawu ekeresiatiku" },
            { "cv", "tiuwaxi" },
            { "cy", "garei" },
            { "da", "dinamarikei" },
            { "de", "aremãu" },
            { "dv", "diweí" },
            { "dz", "disũga" },
            { "ee", "ewe" },
            { "el", metaValue_el },
            { "en", "ẽgirixi" },
            { "eo", "esiperãtu" },
            { "es", "isipãyu" },
            { "et", "eituniyanu" },
            { "eu", "basiku" },
            { "fa", "perisa" },
            { "ff", "fura" },
            { "fi", "firãdes" },
            { "fj", "fiyianu" },
            { "fo", "faruwesi" },
            { "fr", "frãsei" },
            { "fy", "frísiu usidẽtawara" },
            { "ga", "irãdeixi médiu" },
            { "gd", "gaériku ekusei" },
            { "gl", "garegu" },
            { "gn", "guwarani" },
            { "gu", "guserate" },
            { "gv", "mãkisi" },
            { "ha", "hausá" },
            { "he", metaValue_he },
            { "hi", "hĩdi" },
            { "ho", "hiri mutu" },
            { "hr", "kuruata" },
            { "ht", "haitianu" },
            { "hu", "ũgaru" },
            { "hy", metaValue_hy },
            { "hz", "hereru" },
            { "ia", "neẽgasuí" },
            { "id", "ĩdunésiu" },
            { "ie", "neẽgapitera" },
            { "ig", "igibu" },
            { "ii", "sixuã yi" },
            { "ik", "inupiaki" },
            { "io", "idu" },
            { "is", "isirãdei" },
            { "it", "itarianu" },
            { "iu", "inukitituti" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "kũgurei" },
            { "ki", "kikuyu" },
            { "kj", "kuãyama" },
            { "kk", "kasaki" },
            { "kl", "guruẽrãdei" },
            { "km", metaValue_km },
            { "kn", "kanarĩ" },
            { "ko", "kurianu" },
            { "kr", "kanúri" },
            { "ks", "kaxemira" },
            { "ku", "kurdu" },
            { "kv", "kumi" },
            { "kw", "kúriniku" },
            { "ky", "kirigixi" },
            { "la", metaValue_la },
            { "lb", "ruxẽbugei" },
            { "lg", "rugãda" },
            { "li", "rĩburgei" },
            { "ln", "rĩgana" },
            { "lo", "rausianu" },
            { "lt", "rituanu" },
            { "lu", "ruba-katãga" },
            { "lv", "retãu" },
            { "mg", "maugaxe" },
            { "mh", "marixarei" },
            { "mi", "mauri" },
            { "mk", "masedũniu" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marati" },
            { "ms", "marayu" },
            { "mt", "mautei" },
            { "my", metaValue_my },
            { "na", "nauruanu" },
            { "nb", "bukimau nuruegei" },
            { "nd", "ĩdebere nutiwara" },
            { "ne", "neparei" },
            { "ng", "dũgu" },
            { "nl", "hurãdei" },
            { "nn", "ninorisiki nuruegei" },
            { "no", "nuruegei" },
            { "nr", "ĩdebere suwara" },
            { "nv", "nawayu" },
            { "ny", "niãya" },
            { "oc", "usitãniku" },
            { "oj", "uyibua" },
            { "om", "urumu" },
            { "or", metaValue_or },
            { "os", "usetu" },
            { "pa", "pãyabi" },
            { "pi", "pári" },
            { "pl", "purunei" },
            { "ps", "paxitu" },
            { "pt", "putugei" },
            { "qu", "kíxua" },
            { "rm", "rumãxi" },
            { "rn", "rũdi" },
            { "ro", "rumenu" },
            { "ru", "rusu" },
            { "rw", "kiniaruãda" },
            { "sa", "sãsikiritu" },
            { "sc", "saridú" },
            { "sd", "sĩdi" },
            { "se", "sami setẽtiriunau" },
            { "sg", "sãgú" },
            { "sh", "seriwu-kruata" },
            { "si", metaValue_si },
            { "sk", "esiruwaku" },
            { "sl", "esiruwenu" },
            { "sm", "samuanu" },
            { "sn", "xuna" },
            { "so", "sumari" },
            { "sq", "aubanei" },
            { "sr", "sériwiu" },
            { "ss", "suási" },
            { "st", "sutu suwara" },
            { "su", "sũdanei" },
            { "sv", "sueku" },
            { "sw", "suaíri" },
            { "ta", "tamiu" },
            { "te", metaValue_te },
            { "tg", "tadiyike" },
            { "th", metaValue_th },
            { "ti", "tigirínia" },
            { "tk", "turikumenu" },
            { "tl", metaValue_tl },
            { "tn", "tisuana" },
            { "to", "tũganei" },
            { "tr", "turku" },
            { "ts", "tesũga" },
            { "tt", "táritaru" },
            { "tw", "tui" },
            { "ty", "taitianu" },
            { "ug", "wiguri" },
            { "uk", "ukaranianu" },
            { "ur", "urdu" },
            { "uz", "usibeki" },
            { "ve", "wẽda" },
            { "vi", "wietinamita" },
            { "vo", "wurapuke" },
            { "wa", "warãu" },
            { "wo", "worofi" },
            { "xh", "xosa" },
            { "yi", "yídixi" },
            { "yo", "yurubá" },
            { "za", "suãgi" },
            { "zh", "xinanheẽga" },
            { "zu", "suru" },
            { "ace", "axemi" },
            { "ach", "akuri" },
            { "ada", "adãgime" },
            { "ady", "adige" },
            { "afh", "afirihiri" },
            { "agq", "agẽ" },
            { "ain", "ainú" },
            { "akk", "akadiãnu" },
            { "ale", "areúti" },
            { "alt", "autai meridiunau" },
            { "ang", "ẽgirixi arkaiku" },
            { "anp", "ãyika" },
            { "arc", "aramaiku" },
            { "arn", "mapudũgũ" },
            { "arp", "araparu" },
            { "ars", "arabi negede" },
            { "arw", "arawaki" },
            { "asa", "asu" },
            { "ast", "asiturianu" },
            { "awa", "awadi" },
            { "bal", "barúxi" },
            { "ban", "barinei" },
            { "bas", "basa" },
            { "bax", metaValue_bax },
            { "bbj", "gumara" },
            { "bej", "beya" },
            { "bem", "bẽba" },
            { "bez", "bena" },
            { "bfd", "bafuti" },
            { "bgn", "baruxi usidẽtawara" },
            { "bho", "buyipuri" },
            { "bik", "bikú" },
            { "bin", "biní" },
            { "bkm", "kũ" },
            { "bla", "sikisika" },
            { "bra", "barayi" },
            { "brx", "budu" },
            { "bss", "akusi" },
            { "bua", "buriatu" },
            { "bug", metaValue_bug },
            { "bum", "buru" },
            { "byn", "birĩ" },
            { "byv", "medũba" },
            { "cad", "cadu" },
            { "car", "karibi" },
            { "cay", "kayuga" },
            { "cch", "atisã" },
            { "ccp", "xakima" },
            { "ceb", "sebuanu" },
            { "cgg", "xiga" },
            { "chb", "xibixa" },
            { "chg", "xagatai" },
            { "chk", "xukisi" },
            { "chm", "mari" },
            { "chn", "yarigãu xinoki" },
            { "cho", "xokitau" },
            { "chp", "xipewiyã" },
            { "chr", metaValue_chr },
            { "chy", "xeyeni" },
            { "ckb", "kurdu piterapura" },
            { "cop", "kupita" },
            { "crh", "Kirimeya turiku" },
            { "crs", "kiriuru frãsei seixeriwara" },
            { "csb", "kaxubiã" },
            { "dak", "dakuta" },
            { "dar", "darigiwa" },
            { "dav", "taita" },
            { "del", "deraware" },
            { "den", "isireivei" },
            { "dgr", "dogiri" },
            { "din", "dĩka" },
            { "dje", "sarima" },
            { "doi", "dogiribi" },
            { "dsb", "surábiu yatuka" },
            { "dua", "duara" },
            { "dum", "hurãdei médiu" },
            { "dyo", "yora-funiyi" },
            { "dyu", "diura" },
            { "dzg", "dasaga" },
            { "ebu", "ẽbu" },
            { "efi", "efiki" },
            { "egy", "egipisiu arkaiku" },
            { "eka", "ekayuki" },
            { "elx", "eramite" },
            { "enm", "ẽgirixi médiu" },
            { "ewo", "ewũdu" },
            { "fan", "fãge" },
            { "fat", "fãti" },
            { "fil", "firipinu" },
            { "fon", "fũmu" },
            { "frc", "frãsei kayũ" },
            { "frm", "frãsei médiu" },
            { "fro", "frãsei arkaiku" },
            { "frr", "firísiu setẽtiriunau" },
            { "frs", "firísiu usidẽtawara" },
            { "fur", "friuranu" },
            { "gaa", "ga" },
            { "gag", "gagausi" },
            { "gan", "gã" },
            { "gay", "gayu" },
            { "gba", "gibaya" },
            { "gez", "giixi" },
            { "gil", "giubetei" },
            { "gmh", "aremãu iwaté médiu" },
            { "goh", "aremãu arkaiku iwaté" },
            { "gon", "gũdi" },
            { "gor", "gurũtaru" },
            { "got", metaValue_got },
            { "grb", "gerebu" },
            { "grc", "geregu arkaiku" },
            { "gsw", "aremãu (Suisa)" },
            { "guz", "gusiyi" },
            { "gwi", "guwixi-ĩ" },
            { "hai", "haida" },
            { "hak", "haká" },
            { "haw", "hawayanu" },
            { "hil", "irigainũ" },
            { "hit", "hitita" },
            { "hmn", "himũgi" },
            { "hsb", "surábiu iwaté" },
            { "hsn", "xiãgi" },
            { "hup", "hupa" },
            { "iba", "ibã" },
            { "ibb", "ibibiu" },
            { "ilo", "irukanu" },
            { "inh", "ĩguxi" },
            { "jbo", "ruyibã" },
            { "jgo", "ĩgẽba" },
            { "jmc", "maxami" },
            { "jpr", "yudaiku-perisa" },
            { "jrb", "yudaiku-arabiku" },
            { "kaa", "kara-kaupaki" },
            { "kab", "kabire" },
            { "kac", "kaxĩ" },
            { "kaj", "iyu" },
            { "kam", "kãba" },
            { "kaw", "kawi" },
            { "kbd", "kabaridianu" },
            { "kbl", "kanẽbu" },
            { "kcg", "tiyapi" },
            { "kde", "makũdi" },
            { "kea", "kiriuru kabu-suikiriwara" },
            { "kfo", "kuru" },
            { "kgp", "kaĩgãgi" },
            { "kha", "kasi" },
            { "kho", "kutanei" },
            { "khq", "kuyira xini" },
            { "kkj", "kaku" },
            { "kln", "karẽyĩ" },
            { "kmb", "kĩbũdu" },
            { "koi", "kumi-perimiaki" },
            { "kok", "kũkani" },
            { "kos", "kusirayã" },
            { "kpe", "kipere" },
            { "krc", "karaxai-bauká" },
            { "krl", "karériu" },
            { "kru", "kuruki" },
            { "ksb", "xãbara" },
            { "ksf", "bafia" },
            { "ksh", "kurixi" },
            { "kum", "kumiki" },
            { "kut", "kutenai" },
            { "lad", "radinu" },
            { "lag", "rãgi" },
            { "lah", "rãda" },
            { "lam", "rãba" },
            { "lez", "resigi" },
            { "lkt", "rakuta" },
            { "lol", "mũgu" },
            { "lou", "kiriuru ruisianawara" },
            { "loz", "rusi" },
            { "lrc", "ruri setẽtiriunau" },
            { "lua", "ruba-rurua" },
            { "lui", "ruisenu" },
            { "lun", "rũda" },
            { "luo", "ruwu" },
            { "lus", "ruxai" },
            { "luy", "ruiya" },
            { "mad", "madurei" },
            { "maf", "mafa" },
            { "mag", "magarí" },
            { "mai", "maitiri" },
            { "mak", "makasá" },
            { "man", "mãdĩga" },
            { "mas", "masai" },
            { "mde", "maba" },
            { "mdf", "mukisa" },
            { "mdr", "mãdari" },
            { "men", "mẽde" },
            { "mer", "meru" },
            { "mfe", "murisiẽ" },
            { "mga", "irãdei médiu" },
            { "mgh", "makua" },
            { "mgo", "metá" },
            { "mic", "mikemake" },
            { "min", "minãgikabau" },
            { "mnc", "mãxu" },
            { "mni", "manipuri" },
            { "moh", "muikanu" },
            { "mos", "musi" },
            { "mua", "mũdãgi" },
            { "mul", "siía nheẽga" },
            { "mus", "kirik" },
            { "mwl", "mirãdei" },
            { "mwr", "mariwari" },
            { "mye", "miyene" },
            { "myv", "erisia" },
            { "mzn", "masãdarani" },
            { "nan", "mĩ nã" },
            { "nap", "napuritanu" },
            { "naq", "nama" },
            { "nds", "aremaũ yatuka" },
            { "new", "newari" },
            { "nia", "niyasi" },
            { "niu", "niweanu" },
            { "nmg", "kuwasiu" },
            { "nnh", "ĩgiẽbũ" },
            { "nog", "nugai" },
            { "non", "núridiku arkaiku" },
            { "nqo", "nikú" },
            { "nso", "sutu setẽtiriunau" },
            { "nus", "nuiri" },
            { "nwc", "newari katuwa" },
            { "nym", "niãmuwesi" },
            { "nyn", "niãkuri" },
            { "nyo", "niyuru" },
            { "nzi", "ĩsima" },
            { "osa", "usayi" },
            { "ota", "turiku utumanu" },
            { "pag", "pãgasinã" },
            { "pal", "parawi" },
            { "pam", "pãpãga" },
            { "pap", "papiamẽtu" },
            { "pau", "parauanu" },
            { "pcm", "pidigĩ niyerianu" },
            { "peo", "persa arkaiku" },
            { "phn", metaValue_phn },
            { "pon", "pũpeianu" },
            { "prg", "purusianu" },
            { "pro", "puruwẽsau arkaiku" },
            { "quc", "kixé" },
            { "raj", "rayasitani" },
            { "rap", "rapanui" },
            { "rar", "rurutũganu" },
            { "rof", "rũbu" },
            { "rom", "rumani" },
            { "rup", "arumenu" },
            { "rwk", "ruwa" },
            { "sad", "sãdawe" },
            { "sah", "saka" },
            { "sam", "aramaiku samaritanu" },
            { "saq", "sãburu" },
            { "sas", "sasak" },
            { "sat", "sãtari" },
            { "sba", "ĩgãbai" },
            { "sbp", "sãgu" },
            { "scn", "sisirianu" },
            { "sco", "isiutis" },
            { "sdh", "kuridu meridiunau" },
            { "see", "seneka" },
            { "seh", "sena" },
            { "sel", "seukupi" },
            { "ses", "kuiraburu seni" },
            { "sga", "irãdesiarkaiku" },
            { "shi", "taxeriti" },
            { "shn", "xãni" },
            { "shu", "arabi xadianu" },
            { "sid", "sidamu" },
            { "sma", "sami meridiunau" },
            { "smj", "sami Lulewara" },
            { "smn", "sami Inariwara" },
            { "sms", "sami Skoltwara" },
            { "snk", "sunĩkê" },
            { "sog", "sugidianu" },
            { "srn", "surinamei" },
            { "srr", "serere" },
            { "ssy", "saru" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumeriu" },
            { "swb", "kumurianu" },
            { "syc", "siriaku katuwa" },
            { "syr", "siriaku" },
            { "tem", "timine" },
            { "teo", "teso" },
            { "ter", "terenu" },
            { "tet", "tetũ" },
            { "tig", "tigiré" },
            { "tiv", "tivi" },
            { "tkl", "tukerauanu" },
            { "tlh", "kirĩgũ" },
            { "tli", "tirĩgiti" },
            { "tmh", "tamaxeki" },
            { "tog", "tũganei Niasawara" },
            { "tpi", "tuki pisĩ" },
            { "trv", "taruku" },
            { "tsi", "tesĩmĩxianu" },
            { "tum", "tũbuka" },
            { "tvl", "tuwaruanu" },
            { "twq", "tasawake" },
            { "tyv", "tuwinianu" },
            { "tzm", "tamasiriti Átras katuwa" },
            { "udm", "udimurite" },
            { "uga", metaValue_uga },
            { "umb", "ũbũdu" },
            { "und", "ũba uyukuau nheẽga" },
            { "vai", metaValue_vai },
            { "vot", "wútiku" },
            { "vun", "wũyu" },
            { "wae", "wauseri" },
            { "wal", "woraita" },
            { "war", "warai" },
            { "was", "waxu" },
            { "wbp", "waripiri" },
            { "wuu", "wurapuki" },
            { "xal", "kaumiki" },
            { "xog", "rusoga" },
            { "yao", "yau" },
            { "yap", "yapese" },
            { "yav", "yãgibẽ" },
            { "ybb", "yẽba" },
            { "yrl", "nheẽgatu" },
            { "yue", "kãtunei" },
            { "zap", "saputeku" },
            { "zbl", "rãgasaitá brisi" },
            { "zen", "senaga" },
            { "zgh", "tamasiriti marukinu padrãu" },
            { "zun", "sũyi" },
            { "zxx", "ũba aykué nheẽga sesewaraitá" },
            { "zza", "sasaki" },
            { "Arab", "arabika" },
            { "Armi", "arimi" },
            { "Armn", metaValue_hy },
            { "Avst", "awétiku" },
            { "Bali", "barineisi" },
            { "Bamu", metaValue_bax },
            { "Batk", "bataki" },
            { "Beng", metaValue_bn },
            { "Blis", "rãgasaitá bliss" },
            { "Bopo", "bupumufu" },
            { "Brah", "brami" },
            { "Brai", "braire" },
            { "Bugi", metaValue_bug },
            { "Buhd", "buwidi" },
            { "Cakm", "kakimi" },
            { "Cans", "yũpinimasá síraba irũ aburíjini kanadáwara suí" },
            { "Cari", "karianu" },
            { "Cham", "xãmi" },
            { "Cher", metaValue_chr },
            { "Cirt", "runikarana" },
            { "Copt", "kupitiku" },
            { "Cprt", "sipiriuta" },
            { "Cyrl", "siríriku" },
            { "Cyrs", "siríriku isirawu ekeresiatiku" },
            { "Deva", "dewanagari" },
            { "Dsrt", "desereti" },
            { "Egyd", "demútiku egipisiu" },
            { "Egyh", "ierátiku egipisiu" },
            { "Egyp", "egipsiu-ita kuatiara kuxiímawara" },
            { "Ethi", "etiúpiku" },
            { "Geok", "kutisuri geurgianu" },
            { "Geor", metaValue_ka },
            { "Glag", "garagurítiku" },
            { "Goth", metaValue_got },
            { "Grek", metaValue_el },
            { "Gujr", "guserati" },
            { "Guru", "gumuki" },
            { "Hanb", "hãbi" },
            { "Hang", "hãgu" },
            { "Hani", "hã" },
            { "Hano", "hanunu" },
            { "Hans", "iwasuĩma" },
            { "Hant", "katuwa" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hmng", "parau himũgi" },
            { "Hrkt", "yapunei síraba irũ" },
            { "Hung", "ũgaru kuxiímawara" },
            { "Inds", "ĩdu" },
            { "Ital", "itáriku kuxiímawara" },
            { "Jamo", "yamu" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Kali", "kaya ri" },
            { "Kana", "katakaná" },
            { "Khar", "karuxiti" },
            { "Khmr", metaValue_km },
            { "Knda", "kãnará" },
            { "Kore", "kureanu" },
            { "Kthi", "kiti" },
            { "Lana", "rana" },
            { "Laoo", "rau" },
            { "Latf", "ratĩ farakitú" },
            { "Latg", "ratĩ gaériku" },
            { "Latn", metaValue_la },
            { "Lepc", "repixa" },
            { "Limb", "rĩbu" },
            { "Lina", "satãbika A" },
            { "Linb", "satãbika B" },
            { "Lisu", "risu" },
            { "Lyci", "rísiu" },
            { "Lydi", "rídiu" },
            { "Mand", "mãdaiku" },
            { "Mani", "manikeanu" },
            { "Maya", "maya-ita kuatiara kuxiímawara" },
            { "Merc", "meruítiku kusiwu" },
            { "Mero", "meruítiku" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Moon", "Moon kuatiara" },
            { "Mtei", "manipuri kuatiara" },
            { "Mymr", metaValue_my },
            { "Nkoo", "ĩku" },
            { "Ogam", "ugãmiku" },
            { "Olck", "uxiki" },
            { "Orkh", "urikũ" },
            { "Orya", metaValue_or },
            { "Osma", "usmania" },
            { "Perm", "périmiku kuxiímawara" },
            { "Phag", "phagipa" },
            { "Phli", "phli" },
            { "Phlp", "phlp" },
            { "Phlv", "paravi kuxiímawara" },
            { "Phnx", metaValue_phn },
            { "Plrd", "funétiku miau" },
            { "Prti", "prti" },
            { "Rjng", "reyãgi" },
            { "Roro", "rũgurũgu" },
            { "Runr", "rúniku" },
            { "Samr", "samaritanu" },
            { "Sara", "sarati" },
            { "Saur", "sauraxitara" },
            { "Sgnw", "sãgawa kuatiara" },
            { "Shaw", "xawianu" },
            { "Sinh", metaValue_si },
            { "Sund", "sudãnei" },
            { "Sylo", "siruti nagiri" },
            { "Syrc", "siríaku" },
            { "Syre", "siríaku esitarãgeru" },
            { "Syrj", "siriaku usidẽtawara" },
            { "Syrn", "siriaku uriẽtawara" },
            { "Tagb", "tagibanua" },
            { "Tale", "tai re" },
            { "Talu", "tai rue pisasú" },
            { "Taml", "tãmiu" },
            { "Tavt", "tawiti" },
            { "Telu", metaValue_te },
            { "Teng", "tẽguwari" },
            { "Tfng", "tifinagi" },
            { "Tglg", metaValue_tl },
            { "Thaa", "ta-ana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", metaValue_uga },
            { "Vaii", metaValue_vai },
            { "Visp", "nheẽga xipiawera" },
            { "Xpeo", "perisa kuxiímawara" },
            { "Xsux", "sumériu-akadianu kune-sãgawa" },
            { "Yiii", "yi" },
            { "Zinh", "tauxariwa" },
            { "Zmth", "matemátika kuatiara" },
            { "Zsye", "Emuyi" },
            { "Zsym", "zsym" },
            { "Zxxx", "yũpinimasáĩma" },
            { "Zyyy", "mayewera" },
            { "Zzzz", "yũpinimasá ũbawa uyukuau" },
            { "root", "raisi" },
            { "de_CH", "aremãu iwaté (Suisa)" },
            { "nl_BE", "faramẽgu" },
            { "ro_MD", "mudáwiu" },
            { "sw_CD", "suairi kũguwara" },
            { "%%1901", "kuatiasawasupí arimã rikusawarupí" },
            { "%%1994", "kuatiasawasupí resiawara muretewa" },
            { "%%1996", "kuatiasawasupí arimã 1996 upé" },
            { "ar_001", "arabi mudernu" },
            { "key.ca", "Akayupawa" },
            { "key.cf", "Rupisawa rikuyara" },
            { "key.co", "Isirãsawa" },
            { "key.cu", "Rikuyara" },
            { "key.hc", "Ara urariupura (12 vs 24)" },
            { "key.lb", "Nimũ mupukasawa rupisawa" },
            { "key.ms", "Musũgasawa tekô" },
            { "key.nu", "Papasawa-itá" },
            { "key.tz", "Kutu hurariyu" },
            { "key.va", "Tedawasawa muyereusawa" },
            { "nds_NL", "sakisãu yatuka" },
            { "%%BISKE", "diyaretu sã giorgiu/bira" },
            { "%%BOONT", "boontling" },
            { "%%KKCOR", "kuatiasawasupí panhé-yara" },
            { "%%LIPAW", "diyaretu ripovai Resian yara" },
            { "%%NEDIS", "diyaretu natisuni" },
            { "%%NJIVA", "diyaretu giniwa/niyiwa" },
            { "%%OSOJS", "diyaretu usiaku/usuyani" },
            { "%%POSIX", "kũputarawa" },
            { "%%ROZAJ", "resiawara" },
            { "%%SAAHO", "saho" },
            { "%%SOLBA", "diyaretu situwisa/subika" },
            { "%%UCCOR", "kuatiasawasupí yepewasú" },
            { "az_Arab", "aseri sú" },
            { "zh_Hans", "xinanheẽga iwasuĩma" },
            { "zh_Hant", "xinanheẽga katuwa" },
            { "%%AO1990", "Kuatiasawasupí Ewakisawa Nheẽga Putugewara 1990" },
            { "%%FONIPA", "funétika Aufabetu Funétiku Ĩtertetãma-ita" },
            { "%%FONUPA", "funétika Aufabetu Funétiku Urariku" },
            { "%%NDYUKA", "diyaretu ĩdiyuka" },
            { "%%PAMAKA", "diyaretu pamaka" },
            { "%%PINYIN", "romanisasawa Piniyĩ" },
            { "%%SCOUSE", "isikuse" },
            { "%%TARASK", "kuatiasawasupí tarasikiewika" },
            { "%%UCRCOR", "kuatiasawasupí musatãbikawa suí yespewasú" },
            { "%%ABL1943", "Papira purakari-resé kuatiasawasupí 1943 suí" },
            { "%%AREVELA", "arimẽniyu uriẽtawara" },
            { "%%AREVMDA", "arimẽniyu usidẽtawara" },
            { "%%HEPBURN", "romanisasawa hepburn" },
            { "%%MONOTON", "yepetũniku" },
            { "%%POLYTON", "tũniku-ita" },
            { "%%REVISED", "kuatiasawasupí musatãbikawa" },
            { "%%1606NICT", "frãsanheẽga kaxiímawara 1606 upé" },
            { "%%1694ACAD", "frãsanheẽga kuiriwara" },
            { "%%1959ACAD", "akademiku" },
            { "%%BAKU1926", "aufabetu ratinu turku yepewasú" },
            { "%%BISCAYAN", "bisikayawara" },
            { "%%COLB1945", "Kõvẽsãu kuatiasawasupí Brasiu-Putugau 1945" },
            { "%%HOGNORSK", "nuruwegu iwaté" },
            { "%%SCOTLAND", "ẽgirixi retewa esikusiyei" },
            { "%%VALENCIA", "warẽsiwara" },
            { "%%WADEGILE", "romanisasawa Wade-Giles" },
            { "type.ca.roc", "Akayupawa Xina Repúbirikawara" },
            { "type.co.eor", "Tekô eurupawara muakarésawa supé" },
            { "type.hc.h11", "Sistẽma 12 húra-ita (0-11)" },
            { "type.hc.h12", metaValue_type_hc_h12 },
            { "type.hc.h23", "Sistẽma 24 húra-ita (0-23)" },
            { "type.hc.h24", metaValue_type_hc_h12 },
            { "type.m0.bgn", "Sinimukasawa BGN EUA" },
            { "type.nu.arab", "Augarismu-ita ĩdu-arabiku" },
            { "type.nu.armn", "Augarismu-ita arimẽniyu" },
            { "type.nu.beng", "Augarismu-ita bẽgari" },
            { "type.nu.deva", "Augarismu-ita dewanagári" },
            { "type.nu.ethi", "Augarismu-ita etiopiwara" },
            { "type.nu.geor", "Augarismu-ita geurgianu" },
            { "type.nu.grek", "Augarismu-ita geregu" },
            { "type.nu.gujr", "Augarismu-ita guserate" },
            { "type.nu.guru", "Augarismu-ita gurmuki" },
            { "type.nu.hans", "Augarismu-ita xinawara iwasuíma" },
            { "type.nu.hant", "Augarismu-ita xinawara rikusawarupí" },
            { "type.nu.hebr", "Augarismu-ita yudeu" },
            { "type.nu.jpan", "Augarismu-ita nipõwara" },
            { "type.nu.khmr", "Augarismu-ita kimé" },
            { "type.nu.knda", "Augarismu-ita kanarawara" },
            { "type.nu.laoo", "Augarismu-ita raosiwara" },
            { "type.nu.latn", "Augarismu-ita usidẽtawa" },
            { "type.nu.mlym", "Augarismu-ita marayaro" },
            { "type.nu.mong", "Augarismu-ita mũgúi" },
            { "type.nu.mymr", "Augarismu-ita Miyamawara" },
            { "type.nu.orya", "Augarismu-ita uriá" },
            { "type.nu.taml", "Augarismu-ita tamir rikusawarupí" },
            { "type.nu.telu", "Augarismu-ita terugu" },
            { "type.nu.thai", "Augarismu-ita tairãdiyawara" },
            { "type.nu.tibt", "Augarismu-ita tibetewara" },
            { "type.nu.vaii", "Diyitu-ita vai" },
            { "type.ca.dangi", "Akayupawa Dãgi" },
            { "type.co.ducet", "Unicode muakaresawa retewa" },
            { "type.lb.loose", "Mupenasawa ixama upé ikusawa yurawa irũ" },
            { "type.nu.roman", "Augarismu-ita romawara" },
            { "type.ca.coptic", "Akayupawa Kupitiku" },
            { "type.ca.hebrew", "Akayupawa Yudeu" },
            { "type.ca.indian", "Akayupawa Tetãmapawa Ĩdiawara" },
            { "type.co.compat", "Muakaresawa rinũdewa nũgarásawa" },
            { "type.co.pinyin", "Pin-yin mukaresawa" },
            { "type.co.search", "Sikaisá purusawa panhérupí" },
            { "type.co.stroke", "Sikisá-ita mukaresawa" },
            { "type.co.unihan", "Mukaresawa radikawa - sikisá-ita" },
            { "type.d0.fwidth", "Turususawa teipausape" },
            { "type.d0.hwidth", "Turususawa pisawera" },
            { "type.lb.normal", "Mupenasawa ixama upé ikusawa nurmawa irũ" },
            { "type.lb.strict", "Mupenasawa ixama upé ikusawa estiritu irũ" },
            { "type.m0.ungegn", "Sinimukasawa UN GEGN" },
            { "type.ms.metric", "Sistẽma métiriku" },
            { "type.nu.native", "Diyitu-wara-ita" },
            { "type.ca.chinese", "Akayupawa Xinawara" },
            { "type.ca.iso8601", "Akayupawa ISSO-8601" },
            { "type.ca.persian", "Akayupawa Persiyawara" },
            { "type.cf.account", "Rikuyara rupisawa papasawa supé" },
            { "type.d0.npinyin", "Papasawera" },
            { "type.nu.arabext", "Augarismu-ita ĩdu-arabiku musapira" },
            { "type.nu.armnlow", "Augarismu-ita arimẽniyu mirĩwa" },
            { "type.nu.finance", "Papasawa-ita kariwa-rekuyara" },
            { "type.nu.greklow", "Augarismu-ita geregu mirĩwa" },
            { "type.nu.hanidec", "Augarismu-ita mukũi-pusawa xinawara" },
            { "type.nu.hansfin", "Augarismu-ita kariwa-rekuyara xinawara iwasuíma" },
            { "type.nu.hantfin", "Augarismu-ita kariwa-rekuyara xinawara rikusawarupí" },
            { "type.nu.jpanfin", "Augarismu-ita kariwa-rekuyara nipõwara" },
            { "type.nu.tamldec", "Augarismu-ita ramir" },
            { "type.ca.buddhist", "Akayupawa Budasuera" },
            { "type.ca.ethiopic", "Akayupawa Etíupi" },
            { "type.ca.japanese", "Akayupawa Nipõwara" },
            { "type.cf.standard", "Rikuyara rupisawa retewa" },
            { "type.co.phonetic", "Yupurawakasawa terefuniara mukaresawa" },
            { "type.co.searchjl", "Resikai kũsuãti uyupiruwa hangul rupí" },
            { "type.co.standard", "Mukaresawa retewa" },
            { "type.ms.uksystem", "Sistẽma musãgasawa ĩperiawa" },
            { "type.ms.ussystem", "Sistẽma musãgasawa amerikapura" },
            { "type.nu.fullwide", "Augarismu-ita teipausape" },
            { "type.nu.romanlow", "Augarismu-ita romawara mirĩwa" },
            { "type.ca.gregorian", "Akayupawa Greguriuwara" },
            { "type.co.phonebook", "Terefuni sesewara muakaresawa" },
            { "type.co.dictionary", "Disiunariu muakaresawa" },
            { "type.co.traditional", "Mukaresawa rikusawarupí" },
            { "type.nu.traditional", "Papasawa-ita rikusawarupí" },
            { "type.ca.ethiopic-amete-alem", "Akayupawa Amete Alem Etiupiwara" },
        };
        return data;
    }
}
