/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import com.icl.saxon.Bindery;
import com.icl.saxon.Controller;
import com.icl.saxon.Mode;
import com.icl.saxon.ParameterSet;
import com.icl.saxon.expr.BooleanValue;
import com.icl.saxon.expr.LastPositionFinder;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.StaticContext;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.functions.SystemProperty;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.style.XSLTemplate;
import java.util.Stack;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.xsl.XSLTContext;

public final class Context
implements XSLTContext,
LastPositionFinder {
    public static final int VARIABLES = 1;
    public static final int CURRENT_NODE = 4;
    public static final int CONTEXT_NODE = 8;
    public static final int POSITION = 16;
    public static final int LAST = 32;
    public static final int CONTROLLER = 64;
    public static final int CONTEXT_DOCUMENT = 128;
    public static final int NO_DEPENDENCIES = 0;
    public static final int ALL_DEPENDENCIES = 255;
    public static final int XSLT_CONTEXT = 69;
    private NodeInfo contextNode;
    private NodeInfo currentNode;
    private int position = -1;
    private int last = -1;
    private LastPositionFinder lastPositionFinder;
    private Controller controller;
    private Mode currentMode;
    private XSLTemplate currentTemplate;
    private Stack groupActivationStack;
    private StaticContext staticContext;
    private ParameterSet tailRecursion;
    private NodeInfo lastRememberedNode = null;
    private int lastRememberedNumber = -1;
    private Value returnValue = null;
    private XPathException exception = null;
    private static Controller defaultController = null;

    public Context() {
        if (defaultController == null) {
            defaultController = new Controller();
        }
        this.controller = defaultController;
        this.lastPositionFinder = this;
    }

    public Context(Controller controller) {
        this.controller = controller;
        this.lastPositionFinder = this;
    }

    public Context newContext() {
        Context context = new Context(this.controller);
        context.staticContext = this.staticContext;
        context.currentNode = this.currentNode;
        context.contextNode = this.contextNode;
        context.position = this.position;
        context.last = this.last;
        context.lastPositionFinder = this.lastPositionFinder;
        context.currentMode = this.currentMode;
        context.currentTemplate = this.currentTemplate;
        context.groupActivationStack = this.groupActivationStack;
        context.lastRememberedNode = this.lastRememberedNode;
        context.lastRememberedNumber = this.lastRememberedNumber;
        context.returnValue = null;
        return context;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public Controller getController() {
        return this.controller;
    }

    public Bindery getBindery() {
        return this.controller.getBindery();
    }

    public Outputter getOutputter() {
        return this.controller.getOutputter();
    }

    public void setMode(Mode mode) {
        this.currentMode = mode;
    }

    public Mode getMode() {
        return this.currentMode;
    }

    public void setContextNode(NodeInfo nodeInfo) {
        this.contextNode = nodeInfo;
    }

    public NodeInfo getContextNodeInfo() {
        return this.contextNode;
    }

    public Node getContextNode() {
        if (this.contextNode instanceof Node) {
            return (Node)((Object)this.contextNode);
        }
        return null;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public int getContextPosition() {
        return this.position;
    }

    public void setLast(int n) {
        this.last = n;
        this.lastPositionFinder = this;
    }

    public void setLastPositionFinder(LastPositionFinder lastPositionFinder) {
        this.lastPositionFinder = lastPositionFinder;
    }

    public int getLast() throws XPathException {
        if (this.lastPositionFinder == null) {
            return 1;
        }
        return this.lastPositionFinder.getLastPosition();
    }

    public boolean isAtLast() throws XPathException {
        if (this.lastPositionFinder != null && this.lastPositionFinder instanceof NodeEnumeration) {
            return !((NodeEnumeration)((Object)this.lastPositionFinder)).hasMoreElements();
        }
        return this.getContextPosition() == this.getLast();
    }

    public int getContextSize() {
        try {
            return this.getLast();
        }
        catch (XPathException xPathException) {
            this.setException(xPathException);
            return this.getContextPosition();
        }
    }

    public int getLastPosition() {
        return this.last;
    }

    public void setCurrentNode(NodeInfo nodeInfo) {
        this.currentNode = nodeInfo;
    }

    public NodeInfo getCurrentNodeInfo() {
        return this.currentNode;
    }

    public Node getCurrentNode() {
        if (this.currentNode instanceof Node) {
            return (Node)((Object)this.currentNode);
        }
        return null;
    }

    public void setCurrentTemplate(XSLTemplate xSLTemplate) {
        this.currentTemplate = xSLTemplate;
    }

    public XSLTemplate getCurrentTemplate() {
        return this.currentTemplate;
    }

    public Document getOwnerDocument() {
        return (Document)((Node)((Object)this.contextNode.getDocumentRoot()));
    }

    public Object systemProperty(String string, String string2) {
        try {
            Value value = SystemProperty.getProperty(string, string2);
            if (value == null) {
                return null;
            }
            if (value instanceof StringValue) {
                return value.asString();
            }
            if (value instanceof NumericValue) {
                return new Double(value.asNumber());
            }
            if (value instanceof BooleanValue) {
                return new Boolean(value.asBoolean());
            }
            return value;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String stringValue(Node node) {
        if (node instanceof NodeInfo) {
            return ((NodeInfo)((Object)node)).getStringValue();
        }
        throw new IllegalArgumentException("Node is not a Saxon node");
    }

    public void setStaticContext(StaticContext staticContext) {
        this.staticContext = staticContext;
    }

    public StaticContext getStaticContext() {
        return this.staticContext;
    }

    public void setException(XPathException xPathException) {
        this.exception = xPathException;
    }

    public XPathException getException() {
        return this.exception;
    }

    public Stack getGroupActivationStack() {
        if (this.groupActivationStack == null) {
            this.groupActivationStack = new Stack();
        }
        return this.groupActivationStack;
    }

    public void setRememberedNumber(NodeInfo nodeInfo, int n) {
        this.lastRememberedNode = nodeInfo;
        this.lastRememberedNumber = n;
    }

    public int getRememberedNumber(NodeInfo nodeInfo) {
        if (this.lastRememberedNode == nodeInfo) {
            return this.lastRememberedNumber;
        }
        return -1;
    }

    public void setTailRecursion(ParameterSet parameterSet) {
        this.tailRecursion = parameterSet;
    }

    public ParameterSet getTailRecursion() {
        return this.tailRecursion;
    }

    public void setReturnValue(Value value) throws TransformerException {
        if (value != null && this.returnValue != null) {
            throw new TransformerException("A function can only return one result");
        }
        this.returnValue = value;
    }

    public Value getReturnValue() {
        return this.returnValue;
    }
}

