/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ngram;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;

public final class EdgeNGramTokenFilter
extends TokenFilter {
    public static final Side DEFAULT_SIDE = Side.FRONT;
    public static final int DEFAULT_MAX_GRAM_SIZE = 1;
    public static final int DEFAULT_MIN_GRAM_SIZE = 1;
    private int minGram;
    private int maxGram;
    private Side side;
    private char[] curTermBuffer;
    private int curTermLength;
    private int curGramSize;
    private TermAttribute termAtt;
    private OffsetAttribute offsetAtt;

    protected EdgeNGramTokenFilter(TokenStream input) {
        super(input);
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
        this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    }

    public EdgeNGramTokenFilter(TokenStream input, Side side, int minGram, int maxGram) {
        super(input);
        if (side == null) {
            throw new IllegalArgumentException("sideLabel must be either front or back");
        }
        if (minGram < 1) {
            throw new IllegalArgumentException("minGram must be greater than zero");
        }
        if (minGram > maxGram) {
            throw new IllegalArgumentException("minGram must not be greater than maxGram");
        }
        this.minGram = minGram;
        this.maxGram = maxGram;
        this.side = side;
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
        this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    }

    public EdgeNGramTokenFilter(TokenStream input, String sideLabel, int minGram, int maxGram) {
        this(input, Side.getSide(sideLabel), minGram, maxGram);
    }

    public final boolean incrementToken() throws IOException {
        while (true) {
            if (this.curTermBuffer == null) {
                if (!this.input.incrementToken()) {
                    return false;
                }
                this.curTermBuffer = (char[])this.termAtt.termBuffer().clone();
                this.curTermLength = this.termAtt.termLength();
                this.curGramSize = this.minGram;
            }
            if (this.curGramSize <= this.maxGram && this.curGramSize <= this.curTermLength && this.curGramSize <= this.maxGram) {
                int start = this.side == Side.FRONT ? 0 : this.curTermLength - this.curGramSize;
                int end = start + this.curGramSize;
                this.offsetAtt.setOffset(start, end);
                this.termAtt.setTermBuffer(this.curTermBuffer, start, this.curGramSize);
                ++this.curGramSize;
                return true;
            }
            this.curTermBuffer = null;
        }
    }

    public void reset() throws IOException {
        super.reset();
        this.curTermBuffer = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Side {
        FRONT{

            public String getLabel() {
                return "front";
            }
        }
        ,
        BACK{

            public String getLabel() {
                return "back";
            }
        };


        public abstract String getLabel();

        public static Side getSide(String sideName) {
            if (FRONT.getLabel().equals(sideName)) {
                return FRONT;
            }
            if (BACK.getLabel().equals(sideName)) {
                return BACK;
            }
            return null;
        }
    }
}

