# Copyright 2024-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.13.3

EAPI=8

CRATES="
	adler2@2.0.0
	adler@1.0.2
	aho-corasick@1.1.3
	android-tzdata@0.1.1
	android_system_properties@0.1.5
	anstream@0.6.15
	anstyle-parse@0.2.5
	anstyle-query@1.1.1
	anstyle-wincon@3.0.4
	anstyle@1.0.8
	autocfg@1.3.0
	base64@0.22.1
	bitflags@1.3.2
	bitflags@2.6.0
	bumpalo@3.16.0
	bytemuck@1.18.0
	byteorder@1.5.0
	bzip2-sys@0.1.11+1.0.8
	bzip2@0.4.4
	cc@1.1.21
	cfg-if@1.0.0
	chrono@0.4.38
	clap@4.5.18
	clap_builder@4.5.18
	clap_derive@4.5.18
	clap_lex@0.7.2
	color_quant@1.1.0
	colorchoice@1.0.2
	colored@2.1.0
	core-foundation-sys@0.8.7
	core-foundation@0.9.4
	core-graphics-types@0.1.3
	core-graphics@0.23.2
	core-text@20.1.0
	crc32-v2@0.0.4
	crc32c@0.6.8
	crc32fast@1.4.2
	dirs-sys@0.4.1
	dirs@5.0.1
	dlib@0.5.2
	dwrote@0.11.1
	entropy@0.4.2
	env_filter@0.1.2
	env_logger@0.11.5
	fdeflate@0.3.4
	flate2@1.0.34
	float-ord@0.3.2
	font-kit@0.14.2
	foreign-types-macros@0.2.3
	foreign-types-shared@0.3.1
	foreign-types@0.5.0
	freetype-sys@0.20.1
	getrandom@0.2.15
	gif@0.12.0
	heck@0.5.0
	hermit-abi@0.3.9
	humantime@2.1.0
	iana-time-zone-haiku@0.1.2
	iana-time-zone@0.1.61
	image@0.24.9
	is_terminal_polyfill@1.70.1
	itoa@1.0.11
	jpeg-decoder@0.3.1
	js-sys@0.3.70
	lazy_static@1.5.0
	libc@0.2.158
	libloading@0.8.5
	libredox@0.1.3
	log@0.4.22
	lzma-sys@0.1.20
	memchr@2.7.4
	miniz_oxide@0.7.4
	miniz_oxide@0.8.0
	num-traits@0.2.19
	num_cpus@1.16.0
	once_cell@1.19.0
	option-ext@0.2.0
	pathfinder_geometry@0.5.1
	pathfinder_simd@0.5.4
	pkg-config@0.3.30
	plotters-backend@0.3.7
	plotters-bitmap@0.3.7
	plotters-svg@0.3.7
	plotters@0.3.7
	png@0.17.13
	ppv-lite86@0.2.20
	proc-macro2@1.0.86
	quote@1.0.37
	rand@0.8.5
	rand_chacha@0.3.1
	rand_core@0.6.4
	redox_users@0.4.6
	regex-automata@0.4.7
	regex-syntax@0.8.4
	regex@1.10.6
	rustc_version@0.4.1
	ryu@1.0.18
	same-file@1.0.6
	semver@1.0.23
	serde@1.0.210
	serde_derive@1.0.210
	serde_json@1.0.128
	shlex@1.3.0
	simd-adler32@0.3.7
	strsim@0.11.1
	syn@2.0.77
	termsize@0.1.9
	thiserror-impl@1.0.63
	thiserror@1.0.63
	threadpool@1.8.1
	ttf-parser@0.20.0
	unicode-ident@1.0.13
	utf8parse@0.2.2
	uuid-macro-internal@1.10.0
	uuid@1.10.0
	walkdir@2.5.0
	wasi@0.11.0+wasi-snapshot-preview1
	wasm-bindgen-backend@0.2.93
	wasm-bindgen-macro-support@0.2.93
	wasm-bindgen-macro@0.2.93
	wasm-bindgen-shared@0.2.93
	wasm-bindgen@0.2.93
	web-sys@0.3.70
	weezl@0.1.8
	winapi-i686-pc-windows-gnu@0.4.0
	winapi-util@0.1.9
	winapi-x86_64-pc-windows-gnu@0.4.0
	winapi@0.3.9
	windows-core@0.52.0
	windows-sys@0.48.0
	windows-sys@0.52.0
	windows-sys@0.59.0
	windows-targets@0.48.5
	windows-targets@0.52.6
	windows_aarch64_gnullvm@0.48.5
	windows_aarch64_gnullvm@0.52.6
	windows_aarch64_msvc@0.48.5
	windows_aarch64_msvc@0.52.6
	windows_i686_gnu@0.48.5
	windows_i686_gnu@0.52.6
	windows_i686_gnullvm@0.52.6
	windows_i686_msvc@0.48.5
	windows_i686_msvc@0.52.6
	windows_x86_64_gnu@0.48.5
	windows_x86_64_gnu@0.52.6
	windows_x86_64_gnullvm@0.48.5
	windows_x86_64_gnullvm@0.52.6
	windows_x86_64_msvc@0.48.5
	windows_x86_64_msvc@0.52.6
	wio@0.2.2
	xxhash-rust@0.8.12
	xz2@0.1.7
	yeslogic-fontconfig-sys@6.0.0
	zerocopy-derive@0.7.35
	zerocopy@0.7.35
"
RUST_MIN_VER="1.77"

inherit cargo optfeature

DESCRIPTION="Analyzes data for embedded file types"
HOMEPAGE="https://github.com/ReFirmLabs/binwalk"

if [[ ${PV} == 9999 ]] ; then
	inherit git-r3
	EGIT_REPO_URI="https://github.com/ReFirmLabs/binwalk.git"
else
	SRC_URI="
		https://github.com/ReFirmLabs/${PN}/archive/v${PV}.tar.gz -> ${P}.tar.gz
		${CARGO_CRATE_URIS}
	"
	KEYWORDS="amd64"
fi

LICENSE="MIT"
# Dependent crate licenses
LICENSE+=" Boost-1.0 ISC MIT MPL-2.0 Unicode-DFS-2016"
SLOT="3"
RESTRICT="test"

DEPEND="media-libs/fontconfig:="
RDEPEND="${DEPEND}"

src_unpack() {
	if [[ "${PV}" == *9999* ]]; then
		git-r3_src_unpack
		cargo_live_src_unpack
	else
		cargo_src_unpack
	fi
}

src_install() {
	newbin "$(cargo_target_dir)/binwalk" binwalk3
}

pkg_postinst() {
	optfeature "squashfs extraction" app-arch/sasquatch
}
