# Copyright 1999-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

# ebuild generated by hackport 0.8.5.1.9999
#hackport: flags: +pedantic

CABAL_FEATURES="nocabaldep"
inherit haskell-cabal git-r3

DESCRIPTION="Rebuild Haskell dependencies in Gentoo"
HOMEPAGE="https://github.com/gentoo-haskell/haskell-updater#readme"
EGIT_REPO_URI="https://github.com/gentoo-haskell/haskell-updater.git"

LICENSE="GPL-3+"
SLOT="0"

# Need a lower version for portage to get --reinstall-atoms
RDEPEND="
	|| (
		>=sys-apps/portage-2.1.10
		sys-apps/pkgcore
	)
"
DEPEND="
	>=dev-lang/ghc-9.0.2:=
"

src_prepare() {
	default

	if use prefix; then
		sed -i -e "s,/var/db/pkg,${EPREFIX}&,g" \
			"${S}/Distribution/Gentoo/Packages.hs" || die

		sed -i -e 's,"/","'"${EPREFIX}"'/",g' \
			"${S}/Distribution/Gentoo/GHC.hs" || die
	fi

	sed -e 's/^version:.*/&.9999/' -i ${PN}.cabal || die # just to distinct from release install
}

src_configure() {
	local config_flags=(
		--flag=pedantic
		--bindir="${EPREFIX}/usr/sbin"
		--constraint="Cabal == $(cabal-version)"
	)

	cabal_src_configure "${config_flags[@]}"
}

src_install() {
	cabal_src_install

	dodoc CHANGELOG.md README.md TODO
}
