# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7
inherit libtool multilib-minimal

DESCRIPTION="a portable, high level programming interface to various calling conventions"
HOMEPAGE="https://sourceware.org/libffi/"
SRC_URI="https://sourceware.org/ftp/libffi/libffi-${PV}.tar.gz"

LICENSE="MIT"
SLOT="6" # libffi.so.6
KEYWORDS="~alpha amd64 ~arm ~arm64 ~hppa ~m68k ~ppc ~ppc64 ~s390 ~sparc x86 ~amd64-linux ~x86-linux ~x64-macos ~x64-solaris"
IUSE="debug pax-kernel test"

RESTRICT="!test? ( test )"

RDEPEND="!dev-libs/libffi:0/0" # conflicts on libffi.so.6
DEPEND="test? ( dev-util/dejagnu )"

DOCS="ChangeLog* README"

PATCHES=(
	"${FILESDIR}"/libffi-3.2.1-o-tmpfile-eacces.patch #529044
	"${FILESDIR}"/libffi-3.2.1-complex_alpha.patch
	"${FILESDIR}"/libffi-3.1-darwin-x32.patch
	"${FILESDIR}"/libffi-3.2.1-complex-ia64.patch
	"${FILESDIR}"/libffi-3.2.1-include-path.patch
	"${FILESDIR}"/libffi-3.2.1-include-path-autogen.patch
	"${FILESDIR}"/libffi-3.2.1-ia64-small-struct.patch #634190
	"${FILESDIR}"/libffi-3.2.1-musl-emutramp.patch #694916
)

S=${WORKDIR}/libffi-${PV}
ECONF_SOURCE=${S}

src_prepare() {
	default

	sed -i -e 's:@toolexeclibdir@:$(libdir):g' Makefile.in || die #462814
	elibtoolize
}

multilib_src_configure() {
	econf \
		--disable-static \
		$(use_enable pax-kernel pax_emutramp) \
		$(use_enable debug)
}

multilib_src_install() {
	dolib.so .libs/libffi.so.${SLOT}*
}
