# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

USE_RUBY="ruby32"

RUBY_FAKEGEM_EXTRADOC="NEWS README.rdoc"

RUBY_FAKEGEM_GEMSPEC="${PN}.gemspec"

RUBY_FAKEGEM_EXTENSIONS=(ext/gpgme/extconf.rb)

inherit ruby-fakegem flag-o-matic

DESCRIPTION="Ruby language binding for GnuPG Made Easy"
HOMEPAGE="https://github.com/ueno/ruby-gpgme"
SRC_URI="https://github.com/ueno/ruby-gpgme/archive/v${PV}.tar.gz -> ruby-${P}.tar.gz"
RUBY_S="ruby-${P}"

LICENSE="LGPL-2.1+"
SLOT="0"
KEYWORDS="~amd64 ~arm64 ~x86"
IUSE="test"

RDEPEND="
	>=app-crypt/gpgme-1.18.0:=
	>=dev-libs/libassuan-2.5.6:=
	>=dev-libs/libgpg-error-1.47
"
DEPEND="${RDEPEND}"

PATCHES=(
	"${FILESDIR}"/gpgme-2.0.24-gpgme-2.patch
)

ruby_add_bdepend "test? ( dev-ruby/mocha:0.14 dev-ruby/minitest:5.15 )"

all_ruby_prepare() {
	sed -i -e '/\(coverall\|bundler\|ruby-debug\|byebug\)/I s:^:#:' \
		-e '3igem "mocha", "~> 0.14"; gem "minitest", "~> 5.15.0"' \
		test/test_helper.rb || die

	# Remove failing tests for now. This package was added without
	# running any tests :-(
	rm -f test/{ctx,crypto}_test.rb || die

	sed -i -e '/portile/d ; /rubyforge/d' ${RUBY_FAKEGEM_GEMSPEC} || die
}

each_ruby_configure() {
	append-flags -fPIC
	export RUBY_GPGME_USE_SYSTEM_LIBRARIES=1
	each_fakegem_configure
}

each_ruby_test() {
	unset DISPLAY GPG_AGENT_INFO GPG_TTY
	MT_NO_PLUGINS=true ${RUBY} -Ilib:test:. -e 'Dir["test/*_test.rb"].each{|f| require f}' || die
}
