/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.util.Arrays;
import org.jboss.logmanager.NDCProvider;

final class ThreadLocalNDC
implements NDCProvider {
    private static final Holder ndc = new Holder();

    ThreadLocalNDC() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int push(String context) {
        Stack stack = (Stack)ndc.get();
        try {
            int n = stack.depth();
            return n;
        }
        finally {
            stack.push(context);
        }
    }

    @Override
    public String pop() {
        Stack stack = (Stack)ndc.get();
        if (stack.isEmpty()) {
            return "";
        }
        return (String)stack.pop();
    }

    @Override
    public void clear() {
        ((Stack)ndc.get()).trimTo(0);
    }

    @Override
    public void trimTo(int size) {
        ((Stack)ndc.get()).trimTo(size);
    }

    @Override
    public int getDepth() {
        return ((Stack)ndc.get()).depth();
    }

    @Override
    public String get() {
        Stack stack = (Stack)ndc.get();
        if (stack.isEmpty()) {
            return "";
        }
        return stack.toString();
    }

    @Override
    public String get(int n) {
        return (String)((Stack)ndc.get()).get(n);
    }

    private static final class Holder
    extends ThreadLocal<Stack<String>> {
        private Holder() {
        }

        @Override
        protected Stack<String> initialValue() {
            return new Stack<String>();
        }
    }

    private static final class Stack<T> {
        private Object[] data = new Object[32];
        private int sp;

        private Stack() {
        }

        public void push(T value) {
            if (this.sp == this.data.length) {
                this.data = Arrays.copyOf(this.data, (this.data.length << 1) + this.data.length >>> 1);
            }
            this.data[this.sp++] = value;
        }

        public T pop() {
            try {
                Object object = this.data[--this.sp];
                return (T)object;
            }
            finally {
                this.data[this.sp] = null;
            }
        }

        public T top() {
            return (T)this.data[this.sp - 1];
        }

        public boolean isEmpty() {
            return this.sp == 0;
        }

        public int depth() {
            return this.sp;
        }

        public void trimTo(int max) {
            int sp = this.sp;
            if (sp > max) {
                Arrays.fill(this.data, max, sp - 1, null);
                this.sp = max;
            }
        }

        public T get(int n) {
            return (T)(n < this.sp ? this.data[n] : null);
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            int sp = this.sp;
            for (int i = 0; i < sp; ++i) {
                b.append(this.data[i]);
                if (i + 1 >= sp) continue;
                b.append('.');
            }
            return b.toString();
        }
    }
}

