/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core.parser.functions;

import de.focus_shift.jollyday.core.parser.functions.CalculateGregorianEasterSunday;
import de.focus_shift.jollyday.core.parser.functions.CalculateJulianEasterSunday;
import java.time.LocalDate;
import java.time.Year;
import java.time.chrono.Chronology;
import java.time.chrono.IsoChronology;
import java.util.function.Function;
import org.threeten.extra.chrono.JulianChronology;

public class CalculateEasterSunday
implements Function<Chronology, LocalDate> {
    private final Year year;

    public CalculateEasterSunday(Year year) {
        this.year = year;
    }

    @Override
    public LocalDate apply(Chronology chronology) {
        if (chronology == JulianChronology.INSTANCE) {
            return new CalculateJulianEasterSunday().apply(this.year);
        }
        if (chronology == IsoChronology.INSTANCE) {
            return new CalculateGregorianEasterSunday().apply(this.year);
        }
        if (this.year.isAfter(Year.of(1583))) {
            return new CalculateGregorianEasterSunday().apply(this.year);
        }
        return new CalculateJulianEasterSunday().apply(this.year);
    }
}

