/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.StreamsGroupDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class DescribeStreamsGroupsResult {
    private final Map<String, KafkaFuture<StreamsGroupDescription>> futures;

    public DescribeStreamsGroupsResult(Map<String, KafkaFuture<StreamsGroupDescription>> futures) {
        this.futures = Map.copyOf(futures);
    }

    public Map<String, KafkaFuture<StreamsGroupDescription>> describedGroups() {
        return new HashMap<String, KafkaFuture<StreamsGroupDescription>>(this.futures);
    }

    public KafkaFuture<Map<String, StreamsGroupDescription>> all() {
        return KafkaFuture.allOf(this.futures.values().toArray(new KafkaFuture[0])).thenApply(nil -> {
            HashMap descriptions = new HashMap(this.futures.size());
            this.futures.forEach((key, future) -> {
                try {
                    descriptions.put(key, (StreamsGroupDescription)future.get());
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            });
            return descriptions;
        });
    }
}

