/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.util.collection;

import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class GuardianStringKeyMultivaluedMap<V>
implements MultivaluedMap<String, V> {
    private final MultivaluedMap<String, V> inner;
    private final Map<String, Boolean> guards = new HashMap<String, Boolean>();

    public GuardianStringKeyMultivaluedMap(MultivaluedMap<String, V> inner) {
        this.inner = inner;
    }

    @Override
    public void putSingle(String key, V value2) {
        this.observe(key);
        this.inner.putSingle(key, value2);
    }

    @Override
    public void add(String key, V value2) {
        this.observe(key);
        this.inner.add(key, value2);
    }

    @Override
    public V getFirst(String key) {
        return this.inner.getFirst(key);
    }

    @Override
    public void addAll(String key, V ... newValues) {
        this.observe(key);
        this.inner.addAll(key, newValues);
    }

    @Override
    public void addAll(String key, List<V> valueList) {
        this.observe(key);
        this.inner.addAll(key, valueList);
    }

    @Override
    public void addFirst(String key, V value2) {
        this.observe(key);
        this.inner.addFirst(key, value2);
    }

    @Override
    public boolean equalsIgnoreValueOrder(MultivaluedMap<String, V> otherMap) {
        return this.inner.equalsIgnoreValueOrder(otherMap);
    }

    @Override
    public int size() {
        return this.inner.size();
    }

    @Override
    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.inner.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.inner.containsValue(value2);
    }

    @Override
    public List<V> get(Object key) {
        return (List)this.inner.get(key);
    }

    @Override
    public List<V> put(String key, List<V> value2) {
        this.observe(key);
        return this.inner.put(key, value2);
    }

    @Override
    public List<V> remove(Object key) {
        if (key != null) {
            this.observe(key.toString());
        }
        return (List)this.inner.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<V>> m4) {
        for (String string : m4.keySet()) {
            this.observe(string);
        }
        this.inner.putAll(m4);
    }

    @Override
    public void clear() {
        this.observeAll();
        this.inner.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.inner.keySet();
    }

    @Override
    public Collection<List<V>> values() {
        return this.inner.values();
    }

    @Override
    public Set<Map.Entry<String, List<V>>> entrySet() {
        return this.inner.entrySet();
    }

    public void setGuard(String key) {
        this.guards.put(key, false);
    }

    public Set<String> getGuards() {
        return this.guards.keySet();
    }

    public boolean isObservedAndReset(String key) {
        Boolean observed = this.guards.get(key);
        if (observed != null) {
            this.guards.put(key, false);
        }
        return observed != null && observed != false;
    }

    private void observe(String key) {
        for (Map.Entry<String, Boolean> guard : this.guards.entrySet()) {
            if (!guard.getKey().equals(key)) continue;
            guard.setValue(true);
            break;
        }
    }

    private void observeAll() {
        for (Map.Entry<String, Boolean> guard : this.guards.entrySet()) {
            guard.setValue(true);
        }
    }

    public String toString() {
        return this.inner.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GuardianStringKeyMultivaluedMap that = (GuardianStringKeyMultivaluedMap)o;
        return this.inner.equals(that.inner) && this.guards.equals(that.guards);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.inner, this.guards);
    }
}

