/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.runtime;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Vertx;
import io.vertx.mutiny.core.eventbus.EventBus;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.jboss.logging.Logger;

@ApplicationScoped
public class VertxProducer {
    private static final Logger LOGGER = Logger.getLogger(VertxProducer.class);

    @Singleton
    @Produces
    public io.vertx.core.eventbus.EventBus eventbus(Vertx vertx) {
        return vertx.eventBus();
    }

    @Singleton
    @Produces
    public io.vertx.mutiny.core.Vertx mutiny(Vertx vertx) {
        return io.vertx.mutiny.core.Vertx.newInstance((Vertx)vertx);
    }

    @Singleton
    @Produces
    public EventBus mutinyEventBus(io.vertx.mutiny.core.Vertx mutiny) {
        return mutiny.eventBus();
    }

    void undeployVerticles(@Observes @BeforeDestroyed(value=ApplicationScoped.class) Object event, BeanManager beanManager) {
        Set beans = beanManager.getBeans(AbstractVerticle.class, new Annotation[]{Any.Literal.INSTANCE});
        Context applicationContext = beanManager.getContext(ApplicationScoped.class);
        for (Bean bean : beans) {
            Object instance;
            if (!ApplicationScoped.class.equals((Object)bean.getScope()) || (instance = applicationContext.get((Contextual)bean)) == null) continue;
            try {
                AbstractVerticle verticle = (AbstractVerticle)instance;
                io.vertx.mutiny.core.Vertx mutiny = (io.vertx.mutiny.core.Vertx)beanManager.createInstance().select(io.vertx.mutiny.core.Vertx.class, new Annotation[0]).get();
                mutiny.undeploy(verticle.deploymentID()).await().indefinitely();
                LOGGER.debugf("Undeployed verticle: %s", instance.getClass());
            }
            catch (Exception e) {
                LOGGER.debugf("Unable to undeploy verticle %s: %s", instance.getClass(), (Object)e.toString());
            }
        }
    }
}

