/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.editor;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.editor.BaseRestConfigurationFix;
import org.netbeans.modules.websvc.rest.editor.RestConfigurationEditorAwareTaskFactory;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.support.SourceGroupSupport;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

class RestConfigHint
extends BaseRestConfigurationFix {
    private boolean isJersey;

    private RestConfigHint(Project project, FileObject fileObject, RestConfigurationEditorAwareTaskFactory factory, ClasspathInfo cpInfo, boolean jersey) {
        super(project, fileObject, factory, cpInfo);
        this.isJersey = jersey;
    }

    public static List<Fix> getConfigHints(Project project, FileObject fileObject, RestConfigurationEditorAwareTaskFactory factory, ClasspathInfo cpInfo) {
        ArrayList<Fix> result = new ArrayList<Fix>(2);
        result.add(new RestConfigHint(project, fileObject, factory, cpInfo, false));
        result.add(new RestConfigHint(project, fileObject, factory, cpInfo, true));
        return result;
    }

    public String getText() {
        if (this.isJersey) {
            return NbBundle.getMessage(RestConfigHint.class, (String)"MSG_HintJerseyServlet");
        }
        return NbBundle.getMessage(RestConfigHint.class, (String)"MSG_HintApplicationClass");
    }

    @Override
    public ChangeInfo implement() throws Exception {
        RestSupport restSupport = this.getSupport();
        if (this.isJersey) {
            restSupport.ensureRestDevelopmentReady(RestSupport.RestConfig.DD);
        } else {
            restSupport.ensureRestDevelopmentReady(RestSupport.RestConfig.IDE);
            SourceGroup[] groups = ProjectUtils.getSources((Project)this.getProject()).getSourceGroups("java");
            if (groups.length == 0) {
                return null;
            }
            FileObject folder = SourceGroupSupport.getFolderForPackage(groups[0], "org.netbeans.rest.application.config", true);
            RestUtils.createApplicationConfigClass(restSupport, folder, "ApplicationConfig");
        }
        super.implement();
        return null;
    }
}

