/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean;

import java.awt.event.ItemEvent;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLEncoder;
import javax.swing.SwingUtilities;
import org.netbeans.modules.j2ee.sun.share.Constants;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;

public class Utils
implements Constants {
    private static final String[] booleanStrings = new String[]{"0", "1", "false", "true", "no", "yes", "off", "on"};

    private Utils() {
    }

    public static boolean notEmpty(String testedString) {
        return testedString != null && testedString.length() > 0;
    }

    public static boolean strEmpty(String testedString) {
        return testedString == null || testedString.length() == 0;
    }

    public static boolean strEquals(String one, String two) {
        boolean result = false;
        result = one == null ? two == null : (two == null ? false : one.equals(two));
        return result;
    }

    public static boolean strEquivalent(String one, String two) {
        boolean result = false;
        if (Utils.strEmpty(one) && Utils.strEmpty(two)) {
            result = true;
        } else if (one != null && two != null) {
            result = one.equals(two);
        }
        return result;
    }

    public static int strCompareTo(String one, String two) {
        int result = one == null ? (two == null ? 0 : -1) : (two == null ? 1 : one.compareTo(two));
        return result;
    }

    public static boolean hasTrailingSlash(String path) {
        return path.charAt(path.length() - 1) == '/';
    }

    public static boolean containsWhitespace(String data) {
        boolean result = false;
        if (Utils.notEmpty(data)) {
            int datalength = data.length();
            for (int i = 0; i < datalength; ++i) {
                if (!Character.isSpaceChar(data.charAt(i))) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static boolean isJavaIdentifier(String id) {
        boolean result = true;
        if (!Utils.notEmpty(id) || !Character.isJavaIdentifierStart(id.charAt(0))) {
            result = false;
        } else {
            int idlength = id.length();
            for (int i = 1; i < idlength; ++i) {
                if (Character.isJavaIdentifierPart(id.charAt(i))) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public static boolean isJavaPackage(String pkg) {
        boolean result = false;
        if (Utils.notEmpty(pkg)) {
            int state = 0;
            int pkglength = pkg.length();
            block4: for (int i = 0; i < pkglength && state < 2; ++i) {
                switch (state) {
                    case 0: {
                        if (Character.isJavaIdentifierStart(pkg.charAt(i))) {
                            state = 1;
                            continue block4;
                        }
                        state = 2;
                        continue block4;
                    }
                    case 1: {
                        if (pkg.charAt(i) == '.') {
                            state = 0;
                            continue block4;
                        }
                        if (Character.isJavaIdentifierPart(pkg.charAt(i))) continue block4;
                        state = 2;
                    }
                }
            }
            if (state == 1) {
                result = true;
            }
        }
        return result;
    }

    public static boolean isJavaClass(String cls) {
        return Utils.isJavaPackage(cls);
    }

    public static boolean booleanValueOf(String val) {
        boolean result = false;
        int valueIndex = -1;
        if (val != null && val.length() > 0) {
            val = val.trim();
            for (int i = 0; i < booleanStrings.length; ++i) {
                if (val.compareToIgnoreCase(booleanStrings[i]) != 0) continue;
                valueIndex = i;
                break;
            }
        }
        if (valueIndex >= 0 && valueIndex % 2 == 1) {
            result = true;
        }
        return result;
    }

    public static String encodeUrlField(String url) {
        String encodedUrl = url;
        if (encodedUrl != null) {
            encodedUrl = encodedUrl.replace(' ', '_');
        }
        if (encodedUrl != null) {
            try {
                StringBuffer result = new StringBuffer(encodedUrl.length() + 10);
                String[] s = encodedUrl.split("/");
                for (int i = 0; i < s.length; ++i) {
                    result.append(URLEncoder.encode(s[i], "UTF-8"));
                    if (i == s.length - 1) continue;
                    result.append("/");
                }
                encodedUrl = result.toString();
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        return encodedUrl;
    }

    public static URL getResourceURL(String resource, Class relatedClass) {
        URL result = null;
        ClassLoader classLoader = relatedClass.getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            result = urlClassLoader.findResource(resource);
        } else {
            result = classLoader.getResource(resource);
        }
        return result;
    }

    public static void invokeHelp(String helpId) {
        Utils.invokeHelp(new HelpCtx(helpId));
    }

    public static void invokeHelp(final HelpCtx helpCtx) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                helpCtx.display();
            }
        });
    }

    public static boolean interpretCheckboxState(ItemEvent e) {
        boolean state = false;
        if (e.getStateChange() == 1) {
            state = true;
        } else if (e.getStateChange() == 2) {
            state = false;
        }
        return state;
    }
}

