/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.modules.editor.bookmarks.BookmarkInfo;
import org.netbeans.modules.editor.bookmarks.ProjectBookmarks;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public final class FileBookmarks {
    private final ProjectBookmarks projectBookmarks;
    private URI relativeURI;
    private List<BookmarkInfo> bookmarks;
    private FileObject fileObject;

    FileBookmarks(ProjectBookmarks projectBookmarks, URI relativeURI) {
        this.projectBookmarks = projectBookmarks;
        this.relativeURI = relativeURI;
        this.bookmarks = new ArrayList<BookmarkInfo>();
    }

    public ProjectBookmarks getProjectBookmarks() {
        return this.projectBookmarks;
    }

    public URI getRelativeURI() {
        return this.relativeURI;
    }

    public FileObject getFileObject() {
        if (this.fileObject == null) {
            URI projectURI = this.projectBookmarks.getProjectURI();
            URI fileURI = projectURI != null ? projectURI.resolve(this.relativeURI) : this.relativeURI;
            try {
                this.fileObject = URLMapper.findFileObject((URL)fileURI.toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return this.fileObject;
    }

    public boolean containsAnyBookmarks() {
        return !this.bookmarks.isEmpty();
    }

    public List<BookmarkInfo> getBookmarks() {
        return this.bookmarks;
    }

    void add(BookmarkInfo bookmark) {
        this.bookmarks.add(bookmark);
        bookmark.setFileBookmarks(this);
        this.bookmarks.sort(BookmarkInfo.CURRENT_LINE_COMPARATOR);
    }

    boolean remove(BookmarkInfo bookmark) {
        return this.bookmarks.remove(bookmark);
    }

    StringBuilder appendInfo(StringBuilder sb, int indent) {
        sb.append("uri=").append(this.relativeURI);
        sb.append(", bookmarkCount=").append(this.bookmarks.size()).append('\n');
        for (BookmarkInfo bookmark : this.bookmarks) {
            ArrayUtilities.appendSpaces((StringBuilder)sb, (int)(indent + 4));
            sb.append(bookmark).append('\n');
        }
        return sb;
    }

    public String toString() {
        return this.appendInfo(new StringBuilder(100), 0).toString();
    }
}

