/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.control.AsyncGeneratorResumeNextNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.builtins.JSAsyncGeneratorObject;
import com.oracle.truffle.js.runtime.objects.AsyncGeneratorRequest;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.ArrayDeque;

public class AsyncGeneratorRejectNode
extends JavaScriptBaseNode {
    @Node.Child
    private JSFunctionCallNode callRejectNode = JSFunctionCallNode.createCall();
    @Node.Child
    private AsyncGeneratorResumeNextNode asyncGeneratorResumeNextNode;

    protected AsyncGeneratorRejectNode() {
    }

    public static AsyncGeneratorRejectNode create() {
        return new AsyncGeneratorRejectNode();
    }

    public Object execute(VirtualFrame frame, JSAsyncGeneratorObject generator, Object exception) {
        this.performReject(frame, generator, exception);
        if (this.asyncGeneratorResumeNextNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.asyncGeneratorResumeNextNode = (AsyncGeneratorResumeNextNode)this.insert(AsyncGeneratorResumeNextNode.create(this.getLanguage().getJSContext()));
        }
        this.asyncGeneratorResumeNextNode.execute(frame, generator);
        return Undefined.instance;
    }

    public void performReject(VirtualFrame frame, JSAsyncGeneratorObject generator, Object exception) {
        ArrayDeque<AsyncGeneratorRequest> queue = generator.getAsyncGeneratorQueue();
        assert (!queue.isEmpty());
        AsyncGeneratorRequest next = queue.pollFirst();
        PromiseCapabilityRecord promiseCapability = next.getPromiseCapability();
        Object reject = promiseCapability.getReject();
        this.callRejectNode.executeCall(JSArguments.createOneArg((Object)Undefined.instance, reject, exception));
    }
}

