/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.tool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class ArgTokenizer {
    private final String str;
    private final String prefix;
    private final int length;
    private int next = 0;
    private char[] buf = new char[20];
    private int mark;
    private final byte[] ctype = new byte[256];
    private static final byte CT_ALPHA = 0;
    private static final byte CT_WHITESPACE = 1;
    private static final byte CT_QUOTE = 8;
    private String sval;
    private boolean isQuoted = false;
    private final Map<String, Boolean> options = new HashMap<String, Boolean>();
    private final List<String> badOptions = new ArrayList<String>();

    ArgTokenizer(String prefix, String arg) {
        this.str = arg;
        this.prefix = prefix + " ";
        this.length = arg.length();
        this.quoteChar(34);
        this.quoteChar(39);
        this.whitespaceChars(9, 13);
        this.whitespaceChars(28, 32);
        this.whitespaceChars(133, 133);
        this.whitespaceChars(160, 160);
    }

    String next() {
        while (true) {
            this.nextToken();
            if (this.sval == null || this.isQuoted() || !this.sval.startsWith("-")) break;
            String opt = this.sval.startsWith("--") ? this.sval.substring(1) : this.sval;
            this.foundOption(opt);
        }
        return this.sval;
    }

    private void foundOption(String opt) {
        if (this.options.containsKey(opt)) {
            this.options.put(opt, true);
            return;
        }
        List matches = this.options.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(opt)).collect(Collectors.toList());
        if (matches.size() == 1) {
            ((Map.Entry)matches.get(0)).setValue(true);
        } else {
            this.badOptions.add(opt);
        }
    }

    void allowedOptions(String ... opts) {
        for (String opt : opts) {
            this.options.putIfAbsent(opt, false);
        }
    }

    boolean hasOption(String opt) {
        Boolean has = this.options.get(opt);
        if (has == null) {
            throw new InternalError("hasOption called before allowedOptions or on bad option");
        }
        return has;
    }

    int optionCount() {
        return (int)this.options.entrySet().stream().filter(e -> (Boolean)e.getValue()).count();
    }

    String badOptions() {
        return String.join((CharSequence)" ", this.badOptions);
    }

    String remainder() {
        ArrayList<String> rem = new ArrayList<String>();
        while (this.next() != null) {
            rem.add(this.sval);
        }
        return String.join((CharSequence)" ", rem);
    }

    String val() {
        return this.sval;
    }

    boolean isQuoted() {
        return this.isQuoted;
    }

    String whole() {
        return this.prefix + this.str;
    }

    void mark() {
        this.mark = this.next;
    }

    void rewind() {
        this.next = this.mark;
    }

    private int read() {
        if (this.next >= this.length) {
            return -1;
        }
        return this.str.charAt(this.next++);
    }

    private void whitespaceChars(int low, int hi) {
        if (low < 0) {
            low = 0;
        }
        if (hi >= this.ctype.length) {
            hi = this.ctype.length - 1;
        }
        while (low <= hi) {
            this.ctype[low++] = 1;
        }
    }

    private void quoteChar(int ch) {
        if (ch >= 0 && ch < this.ctype.length) {
            this.ctype[ch] = 8;
        }
    }

    private int unicode2ctype(int c) {
        switch (c) {
            case 5760: 
            case 6158: 
            case 8202: 
            case 8239: 
            case 8287: 
            case 12288: {
                return 1;
            }
        }
        return 0;
    }

    public void nextToken() {
        int c;
        int lctype;
        byte[] ct = this.ctype;
        this.sval = null;
        this.isQuoted = false;
        do {
            if ((c = this.read()) >= 0) continue;
            return;
        } while ((lctype = c < 256 ? ct[c] : this.unicode2ctype(c)) == 1);
        if (lctype == 0) {
            int i = 0;
            do {
                if (i >= this.buf.length) {
                    this.buf = Arrays.copyOf(this.buf, this.buf.length * 2);
                }
                this.buf[i++] = (char)c;
            } while ((lctype = (c = this.read()) < 0 ? 1 : (c < 256 ? ct[c] : this.unicode2ctype(c))) == 0);
            if (c >= 0) {
                --this.next;
            }
            this.sval = String.copyValueOf(this.buf, 0, i);
            return;
        }
        if (lctype == 8) {
            int quote = c;
            int i = 0;
            int d = this.read();
            while (d >= 0 && d != quote) {
                if (d == 92) {
                    int first = c = this.read();
                    if (c >= 48 && c <= 55) {
                        c -= 48;
                        int c2 = this.read();
                        if (48 <= c2 && c2 <= 55) {
                            c = (c << 3) + (c2 - 48);
                            c2 = this.read();
                            if (48 <= c2 && c2 <= 55 && first <= 51) {
                                c = (c << 3) + (c2 - 48);
                                d = this.read();
                            } else {
                                d = c2;
                            }
                        } else {
                            d = c2;
                        }
                    } else {
                        switch (c) {
                            case 97: {
                                c = 7;
                                break;
                            }
                            case 98: {
                                c = 8;
                                break;
                            }
                            case 102: {
                                c = 12;
                                break;
                            }
                            case 110: {
                                c = 10;
                                break;
                            }
                            case 114: {
                                c = 13;
                                break;
                            }
                            case 116: {
                                c = 9;
                                break;
                            }
                            case 118: {
                                c = 11;
                            }
                        }
                        d = this.read();
                    }
                } else {
                    c = d;
                    d = this.read();
                }
                if (i >= this.buf.length) {
                    this.buf = Arrays.copyOf(this.buf, this.buf.length * 2);
                }
                this.buf[i++] = (char)c;
            }
            if (d == quote) {
                this.isQuoted = true;
            }
            this.sval = String.copyValueOf(this.buf, 0, i);
        }
    }
}

