/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.keymanagement.model.OauthMetadataSummary;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExternalKeyManagerMetadataSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="vendor")
    private final String vendor;
    @JsonProperty(value="externalVaultEndpointUrl")
    private final String externalVaultEndpointUrl;
    @JsonProperty(value="privateEndpointId")
    private final String privateEndpointId;
    @JsonProperty(value="oauthMetadataSummary")
    private final OauthMetadataSummary oauthMetadataSummary;

    @Deprecated
    @ConstructorProperties(value={"vendor", "externalVaultEndpointUrl", "privateEndpointId", "oauthMetadataSummary"})
    public ExternalKeyManagerMetadataSummary(String vendor, String externalVaultEndpointUrl, String privateEndpointId, OauthMetadataSummary oauthMetadataSummary) {
        this.vendor = vendor;
        this.externalVaultEndpointUrl = externalVaultEndpointUrl;
        this.privateEndpointId = privateEndpointId;
        this.oauthMetadataSummary = oauthMetadataSummary;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getExternalVaultEndpointUrl() {
        return this.externalVaultEndpointUrl;
    }

    public String getPrivateEndpointId() {
        return this.privateEndpointId;
    }

    public OauthMetadataSummary getOauthMetadataSummary() {
        return this.oauthMetadataSummary;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalKeyManagerMetadataSummary(");
        sb.append("super=").append(super.toString());
        sb.append("vendor=").append(String.valueOf(this.vendor));
        sb.append(", externalVaultEndpointUrl=").append(String.valueOf(this.externalVaultEndpointUrl));
        sb.append(", privateEndpointId=").append(String.valueOf(this.privateEndpointId));
        sb.append(", oauthMetadataSummary=").append(String.valueOf((Object)this.oauthMetadataSummary));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalKeyManagerMetadataSummary)) {
            return false;
        }
        ExternalKeyManagerMetadataSummary other = (ExternalKeyManagerMetadataSummary)((Object)o);
        return Objects.equals(this.vendor, other.vendor) && Objects.equals(this.externalVaultEndpointUrl, other.externalVaultEndpointUrl) && Objects.equals(this.privateEndpointId, other.privateEndpointId) && Objects.equals((Object)this.oauthMetadataSummary, (Object)other.oauthMetadataSummary) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.vendor == null ? 43 : this.vendor.hashCode());
        result = result * 59 + (this.externalVaultEndpointUrl == null ? 43 : this.externalVaultEndpointUrl.hashCode());
        result = result * 59 + (this.privateEndpointId == null ? 43 : this.privateEndpointId.hashCode());
        result = result * 59 + (this.oauthMetadataSummary == null ? 43 : this.oauthMetadataSummary.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="vendor")
        private String vendor;
        @JsonProperty(value="externalVaultEndpointUrl")
        private String externalVaultEndpointUrl;
        @JsonProperty(value="privateEndpointId")
        private String privateEndpointId;
        @JsonProperty(value="oauthMetadataSummary")
        private OauthMetadataSummary oauthMetadataSummary;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder vendor(String vendor) {
            this.vendor = vendor;
            this.__explicitlySet__.add("vendor");
            return this;
        }

        public Builder externalVaultEndpointUrl(String externalVaultEndpointUrl) {
            this.externalVaultEndpointUrl = externalVaultEndpointUrl;
            this.__explicitlySet__.add("externalVaultEndpointUrl");
            return this;
        }

        public Builder privateEndpointId(String privateEndpointId) {
            this.privateEndpointId = privateEndpointId;
            this.__explicitlySet__.add("privateEndpointId");
            return this;
        }

        public Builder oauthMetadataSummary(OauthMetadataSummary oauthMetadataSummary) {
            this.oauthMetadataSummary = oauthMetadataSummary;
            this.__explicitlySet__.add("oauthMetadataSummary");
            return this;
        }

        public ExternalKeyManagerMetadataSummary build() {
            ExternalKeyManagerMetadataSummary model = new ExternalKeyManagerMetadataSummary(this.vendor, this.externalVaultEndpointUrl, this.privateEndpointId, this.oauthMetadataSummary);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExternalKeyManagerMetadataSummary model) {
            if (model.wasPropertyExplicitlySet("vendor")) {
                this.vendor(model.getVendor());
            }
            if (model.wasPropertyExplicitlySet("externalVaultEndpointUrl")) {
                this.externalVaultEndpointUrl(model.getExternalVaultEndpointUrl());
            }
            if (model.wasPropertyExplicitlySet("privateEndpointId")) {
                this.privateEndpointId(model.getPrivateEndpointId());
            }
            if (model.wasPropertyExplicitlySet("oauthMetadataSummary")) {
                this.oauthMetadataSummary(model.getOauthMetadataSummary());
            }
            return this;
        }
    }
}

