/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.web.debug.Context;
import org.netbeans.modules.web.debug.breakpoints.ActionsPanel;
import org.netbeans.modules.web.debug.breakpoints.JspLineBreakpoint;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.util.NbBundle;

public class JspBreakpointPanel
extends JPanel {
    static final long serialVersionUID = -8164649328980808272L;
    private ActionsPanel actionsPanel;
    private JspLineBreakpoint breakpoint;
    private boolean createBreakpoint = false;
    private Controller controller;
    private JTextField cboxJspSourcePath;
    private JPanel jPanel1;
    private JLabel lblJspSourcePath;
    private JLabel lblLineNumber;
    private JPanel pActions;
    private JPanel pSettings;
    private JTextField tfLineNumber;

    public JspBreakpointPanel() {
        this(JspLineBreakpoint.create(Context.getCurrentURL(), Context.getCurrentLineNumber()));
        this.createBreakpoint = true;
    }

    public JspBreakpointPanel(JspLineBreakpoint b) {
        this.breakpoint = b;
        this.controller = new JspBreakpointController();
        this.initComponents();
        this.putClientProperty("HelpID", "jsp_breakpoint");
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JspBreakpointPanel.class, (String)"ACSD_LineBreakpointPanel"));
        String url = b.getURL();
        try {
            URI uri = new URI(url);
            this.cboxJspSourcePath.setText(uri.getPath());
        }
        catch (Exception e) {
            this.cboxJspSourcePath.setText(url);
        }
        int lnum = b.getLineNumber();
        if (lnum < 1) {
            this.tfLineNumber.setText("");
        } else {
            this.tfLineNumber.setText(Integer.toString(lnum));
        }
        this.actionsPanel = new ActionsPanel(b);
        this.pActions.add((Component)this.actionsPanel, "Center");
    }

    public Controller getController() {
        return this.controller;
    }

    private void initComponents() {
        this.pSettings = new JPanel();
        this.lblJspSourcePath = new JLabel();
        this.cboxJspSourcePath = new JTextField();
        this.lblLineNumber = new JLabel();
        this.tfLineNumber = new JTextField();
        this.pActions = new JPanel();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.pSettings.setLayout(new GridBagLayout());
        this.pSettings.setBorder(new TitledBorder(NbBundle.getMessage(JspBreakpointPanel.class, (String)"LBL_Settings")));
        this.lblJspSourcePath.setText(NbBundle.getBundle(JspBreakpointPanel.class).getString("CTL_Source_name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.pSettings.add((Component)this.lblJspSourcePath, gridBagConstraints);
        this.lblJspSourcePath.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(JspBreakpointPanel.class).getString("ACSN_CTL_Source_name"));
        this.cboxJspSourcePath.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 2, 2);
        this.pSettings.add((Component)this.cboxJspSourcePath, gridBagConstraints);
        this.cboxJspSourcePath.getAccessibleContext().setAccessibleName(NbBundle.getBundle(JspBreakpointPanel.class).getString("ACSN_CTL_Source_name"));
        this.cboxJspSourcePath.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(JspBreakpointPanel.class).getString("ACSD_CTL_Source_name"));
        this.lblLineNumber.setLabelFor(this.tfLineNumber);
        this.lblLineNumber.setText(NbBundle.getBundle(JspBreakpointPanel.class).getString("CTL_Line_number"));
        this.lblLineNumber.setDisplayedMnemonic(NbBundle.getBundle(JspBreakpointPanel.class).getString("CTL_Line_number_mnemonic").charAt(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.pSettings.add((Component)this.lblLineNumber, gridBagConstraints);
        this.lblLineNumber.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(JspBreakpointPanel.class).getString("ACSD_CTL_Line_number"));
        this.tfLineNumber.setColumns(7);
        this.tfLineNumber.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                JspBreakpointPanel.this.tfLineNumberFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                JspBreakpointPanel.this.tfLineNumberFocusLost(evt);
            }
        });
        this.tfLineNumber.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                JspBreakpointPanel.this.tfLineNumberKeyTyped(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 2, 2);
        this.pSettings.add((Component)this.tfLineNumber, gridBagConstraints);
        this.tfLineNumber.getAccessibleContext().setAccessibleName(NbBundle.getBundle(JspBreakpointPanel.class).getString("ACSN_CTL_Line_number"));
        this.tfLineNumber.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(JspBreakpointPanel.class).getString("ACSD_CTL_Line_number"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pSettings, gridBagConstraints);
        this.pActions.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pActions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void tfLineNumberKeyTyped(KeyEvent evt) {
    }

    private void tfLineNumberFocusGained(FocusEvent evt) {
        if (!evt.isTemporary()) {
            ((JTextField)evt.getComponent()).selectAll();
        }
    }

    private void tfLineNumberFocusLost(FocusEvent evt) {
    }

    private class JspBreakpointController
    implements Controller {
        private JspBreakpointController() {
        }

        public boolean ok() {
            if (!this.isValid()) {
                return false;
            }
            JspBreakpointPanel.this.actionsPanel.ok();
            JspBreakpointPanel.this.breakpoint.setLineNumber(Integer.parseInt(JspBreakpointPanel.this.tfLineNumber.getText().trim()));
            if (JspBreakpointPanel.this.createBreakpoint) {
                DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)JspBreakpointPanel.this.breakpoint);
            }
            return true;
        }

        public boolean cancel() {
            return true;
        }

        public boolean isValid() {
            try {
                int line = Integer.parseInt(JspBreakpointPanel.this.tfLineNumber.getText().trim());
                return line > 0;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
        }
    }
}

