/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasks.filter;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.bugtracking.spi.IssueScheduleInfo;
import org.netbeans.modules.bugtracking.tasks.Category;
import org.netbeans.modules.bugtracking.tasks.ScheduleCategory;
import org.netbeans.modules.bugtracking.tasks.dashboard.CategoryNode;
import org.netbeans.modules.bugtracking.tasks.filter.DashboardFilter;

public class ScheduleCategoryFilter
implements DashboardFilter<CategoryNode> {
    private final List<IssueScheduleInfo> allowedInfos;

    public ScheduleCategoryFilter(List<IssueScheduleInfo> allowedInfos) {
        this.allowedInfos = allowedInfos;
    }

    public ScheduleCategoryFilter() {
        this(new ArrayList<IssueScheduleInfo>());
    }

    public void removeInfo(IssueScheduleInfo scheduleInfo) {
        this.allowedInfos.remove(scheduleInfo);
    }

    public void addInfo(IssueScheduleInfo scheduleInfo) {
        if (!this.allowedInfos.contains(scheduleInfo)) {
            this.allowedInfos.add(scheduleInfo);
        }
    }

    @Override
    public boolean isInFilter(CategoryNode entry) {
        Category category = entry.getCategory();
        if (category instanceof ScheduleCategory) {
            IssueScheduleInfo info = ((ScheduleCategory)category).getScheduleInfo();
            return this.allowedInfos.contains(info);
        }
        return true;
    }

    @Override
    public boolean expandNodes() {
        return false;
    }

    @Override
    public boolean showHitCount() {
        return false;
    }
}

