/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.search;

import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.MultiKeymap;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentListenerPriority;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.search.SearchBar;
import org.openide.util.Exceptions;

public class SearchComboBoxEditor
implements ComboBoxEditor {
    private final JScrollPane scrollPane;
    private final JEditorPane editorPane = new JEditorPane();
    private Object oldValue;
    private static final JTextField referenceTextField = (JTextField)new JComboBox().getEditor().getEditorComponent();
    private static final Logger LOG = Logger.getLogger(SearchComboBoxEditor.class.getName());
    private static final String NO_ACTION = "no-action";

    public SearchComboBoxEditor() {
        SearchComboBoxEditor.changeToOneLineEditorPane(this.editorPane);
        Set<AWTKeyStroke> tfkeys = referenceTextField.getFocusTraversalKeys(0);
        this.editorPane.setFocusTraversalKeys(0, tfkeys);
        tfkeys = referenceTextField.getFocusTraversalKeys(1);
        this.editorPane.setFocusTraversalKeys(1, tfkeys);
        LOG.log(Level.FINE, "Constructor - Reference Font: Name: {0}, Size: {1}\n", new Object[]{referenceTextField.getFont().getFontName(), referenceTextField.getFont().getSize()});
        this.editorPane.setFont(referenceTextField.getFont());
        LOG.log(Level.FINE, "Constructor - Set Font: Name: {0}, Size: {1}\n", new Object[]{this.editorPane.getFont().getFontName(), this.editorPane.getFont().getSize()});
        final Insets margin = referenceTextField.getMargin();
        this.scrollPane = new JScrollPane(21, 31){

            @Override
            public void setViewportView(Component view) {
                if (view instanceof JComponent) {
                    ((JComponent)view).setBorder(new EmptyBorder(margin));
                }
                if (view instanceof JEditorPane) {
                    SearchComboBoxEditor.adjustScrollPaneSize(this, (JEditorPane)view);
                }
                super.setViewportView(view);
            }
        };
        this.editorPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("editorKit".equals(evt.getPropertyName())) {
                    SearchComboBoxEditor.adjustScrollPaneSize(SearchComboBoxEditor.this.scrollPane, SearchComboBoxEditor.this.editorPane);
                }
            }
        });
        Border border = referenceTextField.getBorder();
        if (border != null) {
            Insets borderInsets = border.getBorderInsets(referenceTextField);
            if (SearchComboBoxEditor.isCurrentLF("Aqua")) {
                this.scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
            } else {
                this.scrollPane.setBorder(new EmptyBorder(borderInsets));
            }
        } else {
            this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        }
        this.scrollPane.setFont(referenceTextField.getFont());
        this.scrollPane.setBackground(referenceTextField.getBackground());
        int preferredHeight = SearchComboBoxEditor.referenceTextField.getPreferredSize().height;
        Dimension spDim = this.scrollPane.getPreferredSize();
        spDim.height = preferredHeight + SearchComboBoxEditor.getLFHeightAdjustment();
        if (!SearchComboBoxEditor.isCurrentLF("Aqua")) {
            spDim.height += margin.bottom + margin.top;
        }
        this.scrollPane.setPreferredSize(spDim);
        this.scrollPane.setMinimumSize(spDim);
        this.scrollPane.setMaximumSize(spDim);
        this.scrollPane.setViewportView(this.editorPane);
        final ManageViewPositionListener manageViewListener = new ManageViewPositionListener(this.editorPane, this.scrollPane);
        DocumentUtilities.addDocumentListener((Document)this.editorPane.getDocument(), (DocumentListener)manageViewListener, (DocumentListenerPriority)DocumentListenerPriority.AFTER_CARET_UPDATE);
        this.editorPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                int markPosition;
                Caret oldCaret;
                int dotPosition;
                if ("document".equals(evt.getPropertyName())) {
                    Document newDoc;
                    Document oldDoc = (Document)evt.getOldValue();
                    if (oldDoc != null) {
                        DocumentUtilities.removeDocumentListener((Document)oldDoc, (DocumentListener)manageViewListener, (DocumentListenerPriority)DocumentListenerPriority.AFTER_CARET_UPDATE);
                    }
                    if ((newDoc = (Document)evt.getNewValue()) != null) {
                        DocumentUtilities.addDocumentListener((Document)newDoc, (DocumentListener)manageViewListener, (DocumentListenerPriority)DocumentListenerPriority.AFTER_CARET_UPDATE);
                    }
                }
                if ("caret".equals(evt.getPropertyName()) && evt.getOldValue() instanceof Caret && evt.getNewValue() instanceof Caret && (dotPosition = (oldCaret = (Caret)evt.getOldValue()).getDot()) != (markPosition = oldCaret.getMark())) {
                    try {
                        SearchComboBoxEditor.this.editorPane.getDocument().remove(Math.min(markPosition, dotPosition), Math.abs(markPosition - dotPosition));
                    }
                    catch (BadLocationException ex) {
                        LOG.log(Level.WARNING, "Invalid removal offset: {0}", ex.offsetRequested());
                    }
                }
            }
        });
    }

    public static void changeToOneLineEditorPane(JEditorPane editorPane) {
        editorPane.putClientProperty("AsTextField", Boolean.TRUE);
        editorPane.putClientProperty("HighlightsLayerExcludes", ".*(?<!TextSelectionHighlighting)$");
        EditorKit kit = (EditorKit)MimeLookup.getLookup((String)"text/x-editor-search").lookup(EditorKit.class);
        if (kit == null) {
            throw new IllegalArgumentException("No EditorKit for 'text/x-editor-search' mimetype.");
        }
        editorPane.setEditorKit(kit);
        ActionInvoker.putActionToComponent(new ActionInvoker("find", editorPane), editorPane);
        ActionInvoker.putActionToComponent(new ActionInvoker("replace", editorPane), editorPane);
        ActionInvoker.putActionToComponent(new ActionInvoker("goto", editorPane), editorPane);
        InputMap im = editorPane.getInputMap();
        im.put(KeyStroke.getKeyStroke(27, 0), NO_ACTION);
        im.put(KeyStroke.getKeyStroke(9, 0), NO_ACTION);
        im.put(KeyStroke.getKeyStroke(40, 0), NO_ACTION);
        im.put(KeyStroke.getKeyStroke(38, 0), NO_ACTION);
        im.put(KeyStroke.getKeyStroke(10, 0), NO_ACTION);
        ((AbstractDocument)editorPane.getDocument()).setDocumentFilter(new DocumentFilter(){

            @Override
            public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                if (string != null) {
                    fb.insertString(offset, string.replace("\t", "").replace("\n", ""), attr);
                }
            }

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String string, AttributeSet attr) throws BadLocationException {
                if (string != null) {
                    fb.replace(offset, length, string.replace("\t", "").replace("\n", ""), attr);
                }
            }
        });
        editorPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        if (SearchComboBoxEditor.isCurrentLF("GTK")) {
            editorPane.setBackground((Color)UIManager.get("text"));
        } else {
            editorPane.setBackground(referenceTextField.getBackground());
        }
        LOG.log(Level.FINE, "Changed editorkit - Set Font: Name: {0}, Size: {1}\n", new Object[]{editorPane.getFont().getFontName(), editorPane.getFont().getSize()});
        editorPane.setFont(referenceTextField.getFont());
        if (!SearchComboBoxEditor.isCurrentLF("Nimbus")) {
            editorPane.setCaretColor(referenceTextField.getCaretColor());
        }
        LOG.log(Level.FINE, "Changed editorkit - Set Font: Name: {0}, Size: {1}\n", new Object[]{editorPane.getFont().getFontName(), editorPane.getFont().getSize()});
    }

    private static void adjustScrollPaneSize(JScrollPane sp, JEditorPane editorPane) {
        int height;
        Dimension prefSize = sp.getPreferredSize();
        Insets borderInsets = sp.getBorder() != null ? sp.getBorder().getBorderInsets(sp) : sp.getInsets();
        int vBorder = borderInsets.bottom + borderInsets.top;
        EditorUI eui = Utilities.getEditorUI((JTextComponent)editorPane);
        if (eui != null) {
            height = eui.getLineHeight();
            if (height < eui.getLineAscent()) {
                height = eui.getLineAscent() * 4 / 3;
            }
        } else {
            Font font = editorPane.getFont();
            FontMetrics fontMetrics = editorPane.getFontMetrics(font);
            height = fontMetrics.getHeight();
        }
        if (prefSize.height < (height += vBorder + SearchComboBoxEditor.getLFHeightAdjustment())) {
            prefSize.height = height;
            sp.setPreferredSize(prefSize);
            sp.setMinimumSize(prefSize);
            sp.setMaximumSize(prefSize);
            Container c = sp.getParent();
            if (c instanceof JComponent) {
                ((JComponent)c).revalidate();
            }
        }
    }

    private static boolean isCurrentLF(String lf) {
        LookAndFeel laf = UIManager.getLookAndFeel();
        String lfID = laf.getID();
        return lf.equals(lfID);
    }

    private static int getLFHeightAdjustment() {
        if (SearchComboBoxEditor.isCurrentLF("Metal")) {
            return -7;
        }
        if (SearchComboBoxEditor.isCurrentLF("GTK")) {
            return 2;
        }
        if (SearchComboBoxEditor.isCurrentLF("Motif")) {
            return 3;
        }
        if (SearchComboBoxEditor.isCurrentLF("Nimbus")) {
            return 0;
        }
        if (SearchComboBoxEditor.isCurrentLF("Aqua")) {
            return -10;
        }
        return 0;
    }

    @Override
    public Component getEditorComponent() {
        return this.scrollPane;
    }

    @Override
    public void setItem(Object anObject) {
        String text;
        if (anObject != null) {
            text = anObject.toString();
            this.oldValue = anObject;
        } else {
            text = "";
        }
        if (!text.equals(this.editorPane.getText())) {
            this.editorPane.setText(text);
        }
    }

    @Override
    public Object getItem() {
        Object newValue = this.editorPane.getText();
        if (this.oldValue != null && !(this.oldValue instanceof String)) {
            if (newValue.equals(this.oldValue.toString())) {
                return this.oldValue;
            }
            Class<?> cls = this.oldValue.getClass();
            try {
                Method method = cls.getMethod("valueOf", String.class);
                newValue = method.invoke(this.oldValue, this.editorPane.getText());
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return newValue;
    }

    @Override
    public void selectAll() {
        this.editorPane.selectAll();
        this.editorPane.requestFocus();
    }

    @Override
    public void addActionListener(ActionListener l) {
    }

    @Override
    public void removeActionListener(ActionListener l) {
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public JEditorPane getEditorPane() {
        return this.editorPane;
    }

    private static final class ManageViewPositionListener
    implements DocumentListener {
        private final JEditorPane editorPane;
        private final JScrollPane sp;

        public ManageViewPositionListener(JEditorPane editorPane, JScrollPane sp) {
            this.editorPane = editorPane;
            this.sp = sp;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changed();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changed();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.changed();
        }

        private void changed() {
            JViewport viewport = this.sp.getViewport();
            Point viewPosition = viewport.getViewPosition();
            if (viewPosition.x > 0) {
                try {
                    Rectangle textRect = this.editorPane.getUI().modelToView(this.editorPane, this.editorPane.getDocument().getLength());
                    int textLength = textRect.x + textRect.width;
                    int viewLength = viewport.getExtentSize().width;
                    if (textLength < viewPosition.x + viewLength) {
                        viewPosition.x = Math.max(textLength - viewLength, 0);
                        viewport.setViewPosition(viewPosition);
                    }
                }
                catch (BadLocationException blex) {
                    Exceptions.printStackTrace((Throwable)blex);
                }
            }
        }
    }

    private static final class ActionInvoker
    extends AbstractAction {
        private static final String PREFIX = "search-invoke-";
        private final String originalActionName;
        private final Action delegateAction;

        public ActionInvoker(String name, JTextComponent component) {
            super(PREFIX + name);
            this.originalActionName = name;
            this.delegateAction = component.getActionMap().get(this.originalActionName);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SearchBar.getInstance().getActualTextComponent() != null) {
                ActionEvent newE = new ActionEvent(SearchBar.getInstance().getActualTextComponent(), e.getID(), e.getActionCommand());
                this.delegateAction.actionPerformed(newE);
            }
        }

        private static void putActionToComponent(ActionInvoker action, JTextComponent component) {
            Keymap keymap = component.getKeymap();
            if (keymap instanceof MultiKeymap) {
                MultiKeymap multiKeymap = (MultiKeymap)keymap;
                KeyStroke[] keyStrokesForAction = multiKeymap.getKeyStrokesForAction(component.getActionMap().get(action.getOriginalActionName()));
                if (keyStrokesForAction == null) {
                    return;
                }
                for (KeyStroke ks : keyStrokesForAction) {
                    component.getInputMap().put(KeyStroke.getKeyStroke(ks.getKeyCode(), ks.getModifiers()), PREFIX + action.getOriginalActionName());
                }
                component.getActionMap().put(PREFIX + action.getOriginalActionName(), action);
            }
        }

        public String getOriginalActionName() {
            return this.originalActionName;
        }
    }
}

