/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelFactory;
import org.netbeans.modules.php.editor.model.Occurence;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.impl.ModelVisitor;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class FindUsageSupport {
    private final Set<FileObject> files;
    private final ModelElement element;
    private final ElementQuery.Index index;

    public static FindUsageSupport getInstance(ElementQuery.Index index, ModelElement element) {
        return new FindUsageSupport(index, element);
    }

    private FindUsageSupport(ElementQuery.Index index, ModelElement element) {
        this.element = element;
        this.files = new LinkedHashSet<FileObject>();
        this.index = index;
    }

    public Collection<MethodElement> overridingMethods() {
        if (this.element instanceof MethodElement) {
            MethodElement method = (MethodElement)((Object)this.element);
            TypeElement type = method.getType();
            HashSet<MethodElement> inheritedByMethods = new HashSet<MethodElement>();
            for (TypeElement nextType : this.index.getInheritedByTypes(type)) {
                inheritedByMethods.addAll(this.index.getDeclaredMethods(nextType));
            }
            return ElementFilter.forName(NameKind.exact(method.getName())).filter(inheritedByMethods);
        }
        if (this.element instanceof MethodScope) {
            MethodScope method = (MethodScope)this.element;
            TypeScope type = (TypeScope)method.getInScope();
            HashSet<MethodElement> inheritedByMethods = new HashSet<MethodElement>();
            for (TypeElement nextType : this.index.getInheritedByTypes(type)) {
                inheritedByMethods.addAll(this.index.getDeclaredMethods(nextType));
            }
            return ElementFilter.forName(NameKind.exact(method.getName())).filter(inheritedByMethods);
        }
        return Collections.emptyList();
    }

    public Collection<TypeElement> subclasses() {
        if (this.element instanceof TypeElement) {
            return this.index.getInheritedByTypes((TypeElement)((Object)this.element));
        }
        return Collections.emptySet();
    }

    public Collection<TypeElement> directSubclasses() {
        if (this.element instanceof TypeElement) {
            return this.index.getDirectInheritedByTypes((TypeElement)((Object)this.element));
        }
        return Collections.emptySet();
    }

    @CheckForNull
    public Collection<Occurence> occurences(FileObject fileObject) {
        final TreeSet<Occurence> retval = new TreeSet<Occurence>(new Comparator<Occurence>(){

            @Override
            public int compare(Occurence o1, Occurence o2) {
                return o1.getOccurenceRange().compareTo(o2.getOccurenceRange());
            }
        });
        if (fileObject != null && fileObject.isValid()) {
            try {
                ParserManager.parse(Collections.singleton(Source.create((FileObject)fileObject)), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        Parser.Result parameter = resultIterator.getParserResult();
                        if (parameter instanceof PHPParseResult) {
                            Model model = ModelFactory.getModel((PHPParseResult)parameter);
                            ModelVisitor modelVisitor = model.getModelVisitor();
                            retval.addAll(modelVisitor.getOccurence(FindUsageSupport.this.element));
                        }
                    }
                });
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<FileObject> inFiles() {
        FindUsageSupport findUsageSupport = this;
        synchronized (findUsageSupport) {
            if (this.files.isEmpty()) {
                this.addFile(this.element.getFileObject());
                String name = this.element.getName();
                PhpElementKind kind = this.element.getPhpElementKind();
                if (kind.equals((Object)PhpElementKind.VARIABLE) || kind.equals((Object)PhpElementKind.FIELD)) {
                    name = name.startsWith("$") ? name.substring(1) : name;
                } else if (kind.equals((Object)PhpElementKind.METHOD) && "__construct".equalsIgnoreCase(name)) {
                    name = this.element.getInScope().getName();
                }
                for (FileObject fo : this.index.getLocationsForIdentifiers(name)) {
                    this.addFile(fo);
                }
            }
        }
        return this.files;
    }

    private synchronized void addFile(FileObject fileObject) {
        PhpSourcePath.FileType fileType = PhpSourcePath.getFileType((FileObject)fileObject);
        if (fileType != PhpSourcePath.FileType.INCLUDE && fileType != PhpSourcePath.FileType.INTERNAL) {
            this.files.add(fileObject);
        }
    }

    public ModelElement elementToFind() {
        return this.element;
    }
}

