/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.debugger;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIRecord;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIResult;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MITList;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIValue;
import org.netbeans.modules.cpplite.debugger.CPPFrame;
import org.netbeans.modules.cpplite.debugger.CPPLiteDebugger;
import org.netbeans.modules.cpplite.debugger.Command;
import org.netbeans.modules.cpplite.debugger.debuggingview.DebuggingViewSupportImpl;
import org.netbeans.spi.debugger.ui.DebuggingView;
import org.openide.util.Pair;

public final class CPPThread
implements DebuggingView.DVThread {
    private final CPPLiteDebugger debugger;
    private final String id;
    private volatile Pair<String, String> nameDetails;
    private Status status;
    private volatile CPPFrame topFrame;
    private CPPFrame[] stack;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    CPPThread(CPPLiteDebugger debugger, String id) {
        this.debugger = debugger;
        this.id = id;
        this.status = Status.CREATED;
    }

    String getId() {
        return this.id;
    }

    public Status getStatus() {
        return this.status;
    }

    void setTopFrame(CPPFrame frame) {
        this.topFrame = frame;
    }

    @CheckForNull
    public CPPFrame getTopFrame() {
        return this.topFrame;
    }

    public String getName() {
        return (String)this.getNameDetails().first();
    }

    @CheckForNull
    public String getDetails() {
        return (String)this.getNameDetails().second();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<String, String> getNameDetails() {
        Pair nd = this.nameDetails;
        if (nd == null) {
            CPPThread cPPThread = this;
            synchronized (cPPThread) {
                nd = this.nameDetails;
                if (nd == null) {
                    MIRecord record;
                    if (this.status == Status.CREATED) {
                        return Pair.of((Object)this.id, null);
                    }
                    try {
                        record = this.debugger.sendAndGet("-thread-info " + this.id, true);
                    }
                    catch (InterruptedException ex) {
                        return null;
                    }
                    if (record.isError() || record.isEmpty()) {
                        this.nameDetails = nd = Pair.of((Object)record.error(), null);
                    } else {
                        MITList infoList = (MITList)record.results().valueOf("threads").asList().get(0);
                        MIValue nameValue = infoList.valueOf("name");
                        if (nameValue == null) {
                            nameValue = infoList.valueOf("target-id");
                        }
                        MIValue detailsValue = infoList.valueOf("details");
                        String name = nameValue.asConst().value();
                        String details = detailsValue != null ? detailsValue.asConst().value() : null;
                        this.nameDetails = nd = Pair.of((Object)name, (Object)details);
                    }
                }
            }
        }
        return nd;
    }

    public boolean isSuspended() {
        return Status.SUSPENDED == this.status;
    }

    public void resume() {
        if (this.isSuspended()) {
            this.notifyRunning();
            this.debugger.send(new Command("-exec-continue --thread " + this.id));
        }
    }

    public void suspend() {
        if (!this.isSuspended()) {
            this.debugger.send(new Command("-exec-interrupt --thread " + this.id));
        }
    }

    public void makeCurrent() {
        this.debugger.setCurrentThread(this);
    }

    public int getFrameCount() {
        CPPFrame[] stack = this.getStack();
        if (stack != null) {
            return stack.length;
        }
        return 0;
    }

    public List<DebuggingView.DVFrame> getFrames() {
        CPPFrame[] stack = this.getStack();
        if (stack != null) {
            return new FrameList(stack, 0, stack.length);
        }
        return Collections.emptyList();
    }

    public List<DebuggingView.DVFrame> getFrames(int from, int to) {
        CPPFrame[] stack = this.getStack();
        if (stack != null) {
            return new FrameList(stack, from, to);
        }
        return Collections.emptyList();
    }

    public DebuggingView.DVSupport getDVSupport() {
        return this.debugger.getDVSupport();
    }

    public List<DebuggingView.DVThread> getLockerThreads() {
        return Collections.emptyList();
    }

    public void resumeBlockingThreads() {
    }

    public Breakpoint getCurrentBreakpoint() {
        return null;
    }

    public boolean isInStep() {
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }

    @CheckForNull
    public synchronized CPPFrame[] getStack() {
        if (this.status != Status.SUSPENDED) {
            return null;
        }
        CPPFrame[] stack = this.stack;
        if (stack == null) {
            MIRecord record;
            try {
                record = this.debugger.sendAndGet("-stack-list-frames --thread " + this.id);
            }
            catch (InterruptedException ex) {
                return null;
            }
            MITList stackList = record.results().valueOf("stack").asList();
            int l = stackList.size();
            stack = new CPPFrame[l];
            int i = 0;
            if (this.topFrame != null) {
                stack[0] = this.topFrame;
                ++i;
            }
            for (int li = i; li < l; ++li) {
                CPPFrame frame = CPPFrame.create(this, (MITList)((MIResult)stackList.get(li)).value());
                if (frame == null) continue;
                stack[i++] = frame;
            }
            if (i < l) {
                stack = Arrays.copyOf(stack, i);
            }
            this.stack = stack;
        }
        return stack;
    }

    CPPLiteDebugger getDebugger() {
        return this.debugger;
    }

    synchronized void notifyExited() {
        this.status = Status.EXITED;
        this.topFrame = null;
        this.stack = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyStopped() {
        CPPThread cPPThread = this;
        synchronized (cPPThread) {
            this.status = Status.SUSPENDED;
        }
        this.pcs.firePropertyChange("suspended", false, true);
        ((DebuggingViewSupportImpl)this.debugger.getDVSupport()).doFirePropertyChange("threadSuspended", null, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyRunning() {
        CPPThread cPPThread = this;
        synchronized (cPPThread) {
            if (this.status == Status.RUNNING) {
                return;
            }
            this.status = Status.RUNNING;
            this.topFrame = null;
            this.stack = null;
        }
        this.pcs.firePropertyChange("suspended", true, false);
        ((DebuggingViewSupportImpl)this.debugger.getDVSupport()).doFirePropertyChange("threadResumed", null, this);
    }

    public static enum Status {
        CREATED,
        RUNNING,
        SUSPENDED,
        EXITED;

    }

    private static final class FrameList
    extends AbstractList<DebuggingView.DVFrame> {
        private final CPPFrame[] array;
        private final int from;
        private final int to;

        FrameList(CPPFrame[] array, int from, int to) {
            this.array = array;
            this.from = from;
            this.to = Math.min(to, array.length);
        }

        @Override
        public CPPFrame get(int index) {
            return this.array[index + this.from];
        }

        @Override
        public int size() {
            return this.to - this.from;
        }
    }
}

