/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle;

import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.GradleBaseProject;
import org.netbeans.modules.gradle.api.GradleTask;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;

public final class FavoriteTaskManager {
    Set<GradleTask> favorites;
    private static final String FAVORITE_TASKS_PROP = "favorite.tasks";
    ChangeSupport support;
    PropertyChangeListener listener;
    private boolean loaded;
    final Project project;

    public FavoriteTaskManager(Project p) {
        this.project = p;
        this.listener = e -> this.updateFavorites(p);
        NbGradleProject.addPropertyChangeListener(p, WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)NbGradleProject.get(p)));
    }

    public boolean isFavorite(GradleTask task) {
        return this.favorites() != null ? this.favorites().contains(task) : false;
    }

    public void setFavorite(GradleTask task, boolean favorite) {
        boolean changed = false;
        if (this.favorites == null) {
            changed = true;
            this.favorites = new TreeSet<GradleTask>(Comparator.comparing(GradleTask::getName));
        }
        boolean bl = changed = favorite ? this.favorites.add(task) : this.favorites.remove(task);
        if (changed) {
            StringBuilder sb = new StringBuilder();
            String separator = "";
            for (GradleTask t : this.favorites) {
                sb.append(separator).append(t.getName());
                separator = ",";
            }
            Preferences prefs = NbGradleProject.getPreferences(this.project, false);
            prefs.put(FAVORITE_TASKS_PROP, sb.toString());
            this.fireChange();
        }
    }

    public Set<GradleTask> getFavoriteTasks() {
        return this.favorites() != null ? new LinkedHashSet<GradleTask>(this.favorites) : Collections.emptySet();
    }

    public void addChangeListener(ChangeListener l) {
        if (this.support == null) {
            this.support = new ChangeSupport((Object)this);
        }
        this.support.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        if (this.support != null) {
            this.support.removeChangeListener(l);
            if (!this.support.hasListeners()) {
                this.support = null;
            }
        }
    }

    private void fireChange() {
        if (this.support != null) {
            this.support.fireChange();
        }
    }

    private void updateFavorites(Project project) {
        Preferences prefs = NbGradleProject.getPreferences(project, false);
        String favoriteProp = prefs.get(FAVORITE_TASKS_PROP, "");
        GradleBaseProject gbp = GradleBaseProject.get(project);
        if (gbp != null) {
            TreeSet<GradleTask> newFavorites = new TreeSet<GradleTask>(Comparator.comparing(GradleTask::getName));
            for (String taskName : favoriteProp.split(",")) {
                GradleTask task = gbp.getTaskByName(taskName);
                if (task == null) continue;
                newFavorites.add(task);
            }
            if (!Objects.equals(this.favorites, newFavorites)) {
                this.favorites = newFavorites;
                this.fireChange();
            }
        } else if (this.favorites != null) {
            this.favorites = null;
            this.fireChange();
        }
    }

    private Set<GradleTask> favorites() {
        if (!this.loaded) {
            this.updateFavorites(this.project);
            this.loaded = true;
        }
        return this.favorites;
    }
}

