/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl.ast;

import java.util.List;
import java.util.Objects;
import org.netbeans.modules.languages.hcl.ast.HCLAttribute;
import org.netbeans.modules.languages.hcl.ast.HCLBlock;
import org.netbeans.modules.languages.hcl.ast.HCLElement;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class HCLContainer
implements HCLElement {
    protected final List<HCLElement> elements;
    private final List<HCLBlock> blocks;
    private final List<HCLAttribute> attributes;

    protected HCLContainer(List<HCLElement> elements) {
        Objects.requireNonNull(elements, "elements can be empty, but cannot be null");
        this.elements = List.copyOf(elements);
        this.blocks = elements.stream().filter(HCLBlock.class::isInstance).map(HCLBlock.class::cast).toList();
        this.attributes = elements.stream().filter(HCLAttribute.class::isInstance).map(HCLAttribute.class::cast).toList();
    }

    public boolean hasBlock() {
        return !this.blocks.isEmpty();
    }

    public boolean hasAttribute() {
        return !this.attributes.isEmpty();
    }

    public List<HCLBlock> blocks() {
        return this.blocks;
    }

    public List<HCLAttribute> attributes() {
        return this.attributes;
    }

    @Override
    public List<? extends HCLElement> elements() {
        return this.elements;
    }
}

