/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git;

import java.awt.Color;
import java.io.File;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.libs.git.GitConflictDescriptor;
import org.netbeans.libs.git.GitStatus;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitFileNode;
import org.openide.util.NbBundle;

public class FileInformation
extends GitFileNode.FileNodeInformation {
    private final EnumSet<Status> status;
    private boolean seenInUI;
    private final boolean directory;
    private final boolean renamed;
    private final boolean copied;
    private final File oldFile;
    private GitConflictDescriptor.Type conflictType;
    public static final EnumSet<Status> STATUS_ALL = EnumSet.allOf(Status.class);
    public static final EnumSet<Status> STATUS_MANAGED = EnumSet.complementOf(EnumSet.of(Status.NOTVERSIONED_NOTMANAGED));
    public static final EnumSet<Status> STATUS_REMOVED = EnumSet.of(Status.REMOVED_HEAD_INDEX, Status.REMOVED_INDEX_WORKING_TREE);
    public static final EnumSet<Status> STATUS_LOCAL_CHANGES = EnumSet.of(Status.NEW_HEAD_INDEX, new Status[]{Status.NEW_INDEX_WORKING_TREE, Status.NEW_HEAD_WORKING_TREE, Status.IN_CONFLICT, Status.REMOVED_HEAD_INDEX, Status.REMOVED_INDEX_WORKING_TREE, Status.REMOVED_HEAD_WORKING_TREE, Status.MODIFIED_HEAD_INDEX, Status.MODIFIED_HEAD_WORKING_TREE, Status.MODIFIED_INDEX_WORKING_TREE});
    public static final EnumSet<Status> STATUS_MODIFIED_HEAD_VS_WORKING = EnumSet.of(Status.NEW_HEAD_WORKING_TREE, Status.IN_CONFLICT, Status.REMOVED_HEAD_WORKING_TREE, Status.MODIFIED_HEAD_WORKING_TREE);
    public static final EnumSet<Status> STATUS_MODIFIED_HEAD_VS_INDEX = EnumSet.of(Status.NEW_HEAD_INDEX, Status.IN_CONFLICT, Status.REMOVED_HEAD_INDEX, Status.MODIFIED_HEAD_INDEX);
    public static final EnumSet<Status> STATUS_MODIFIED_INDEX_VS_WORKING = EnumSet.of(Status.NEW_INDEX_WORKING_TREE, Status.IN_CONFLICT, Status.REMOVED_INDEX_WORKING_TREE, Status.MODIFIED_INDEX_WORKING_TREE);

    FileInformation(EnumSet<Status> status, boolean isDirectory) {
        this.status = status;
        this.directory = isDirectory;
        this.copied = false;
        this.renamed = false;
        this.oldFile = null;
    }

    public FileInformation(GitStatus status) {
        this.directory = status.isFolder();
        this.seenInUI = true;
        this.renamed = status.isRenamed();
        this.copied = status.isCopied();
        this.oldFile = status.getOldPath();
        if (!status.isTracked()) {
            this.status = GitStatus.Status.STATUS_IGNORED.equals((Object)status.getStatusIndexWC()) ? EnumSet.of(Status.NOTVERSIONED_EXCLUDED) : EnumSet.of(Status.NEW_INDEX_WORKING_TREE, Status.NEW_HEAD_WORKING_TREE);
        } else if (status.isConflict()) {
            this.status = EnumSet.of(Status.IN_CONFLICT);
            this.conflictType = status.getConflictDescriptor().getType();
        } else {
            GitStatus.Status statusHeadIndex = status.getStatusHeadIndex();
            GitStatus.Status statusIndexWC = status.getStatusIndexWC();
            GitStatus.Status statusHeadWC = status.getStatusHeadWC();
            EnumSet<Status> s = EnumSet.noneOf(Status.class);
            if (GitStatus.Status.STATUS_ADDED.equals((Object)statusHeadIndex)) {
                s.add(Status.NEW_HEAD_INDEX);
            } else if (GitStatus.Status.STATUS_MODIFIED.equals((Object)statusHeadIndex)) {
                s.add(Status.MODIFIED_HEAD_INDEX);
            } else if (GitStatus.Status.STATUS_REMOVED.equals((Object)statusHeadIndex)) {
                s.add(Status.REMOVED_HEAD_INDEX);
            }
            if (GitStatus.Status.STATUS_ADDED.equals((Object)statusIndexWC)) {
                s.add(Status.NEW_INDEX_WORKING_TREE);
            } else if (GitStatus.Status.STATUS_MODIFIED.equals((Object)statusIndexWC)) {
                s.add(Status.MODIFIED_INDEX_WORKING_TREE);
            } else if (GitStatus.Status.STATUS_REMOVED.equals((Object)statusIndexWC)) {
                s.add(Status.REMOVED_INDEX_WORKING_TREE);
            }
            if (GitStatus.Status.STATUS_MODIFIED.equals((Object)statusHeadWC)) {
                s.add(Status.MODIFIED_HEAD_WORKING_TREE);
            } else if (GitStatus.Status.STATUS_ADDED.equals((Object)statusHeadWC)) {
                s.add(Status.NEW_HEAD_WORKING_TREE);
            } else if (GitStatus.Status.STATUS_REMOVED.equals((Object)statusHeadWC)) {
                s.add(Status.REMOVED_HEAD_WORKING_TREE);
            }
            if (s.size() == 1) {
                if (s.contains((Object)Status.MODIFIED_INDEX_WORKING_TREE) || s.contains((Object)Status.MODIFIED_HEAD_INDEX)) {
                    Git.STATUS_LOG.log(Level.WARNING, "inconsistent status found for {0}: {1}", new Object[]{status.getFile(), s});
                    s.add(Status.MODIFIED_HEAD_WORKING_TREE);
                } else if (s.contains((Object)Status.REMOVED_INDEX_WORKING_TREE) || s.contains((Object)Status.REMOVED_HEAD_INDEX)) {
                    Git.STATUS_LOG.log(Level.WARNING, "inconsistent status found for {0}: {1}", new Object[]{status.getFile(), s});
                    s.add(Status.REMOVED_HEAD_WORKING_TREE);
                }
            }
            if (GitStatus.Status.STATUS_REMOVED.equals((Object)statusIndexWC) && !GitStatus.Status.STATUS_ADDED.equals((Object)statusHeadIndex) || GitStatus.Status.STATUS_REMOVED.equals((Object)statusHeadIndex) && GitStatus.Status.STATUS_NORMAL.equals((Object)statusIndexWC)) {
                s.add(Status.REMOVED_HEAD_WORKING_TREE);
            }
            if (s.isEmpty()) {
                s.add(Status.UPTODATE);
            }
            this.status = s;
        }
    }

    public boolean containsStatus(Set<Status> includeStatus) {
        Object intersection = this.status.clone();
        ((AbstractCollection)intersection).retainAll(includeStatus);
        return !((AbstractCollection)intersection).isEmpty();
    }

    public boolean containsStatus(Status includeStatus) {
        return this.containsStatus(EnumSet.of(includeStatus));
    }

    void setSeenInUI(boolean flag) {
        this.seenInUI = flag;
    }

    boolean seenInUI() {
        return this.seenInUI;
    }

    public Set<Status> getStatus() {
        return this.status;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public int getComparableStatus() {
        if (this.containsStatus(Status.IN_CONFLICT)) {
            return 0;
        }
        if (this.containsStatus(Status.UPTODATE)) {
            return 850;
        }
        if (this.containsStatus(Status.NOTVERSIONED_EXCLUDED)) {
            return 900;
        }
        if (this.containsStatus(Status.NOTVERSIONED_NOTMANAGED)) {
            return 901;
        }
        if (this.containsStatus(Status.UNKNOWN)) {
            return 902;
        }
        int value = 400;
        if (this.containsStatus(Status.REMOVED_HEAD_WORKING_TREE)) {
            value -= 100;
        }
        if (this.containsStatus(Status.MODIFIED_HEAD_WORKING_TREE)) {
            value -= 200;
        }
        if (this.containsStatus(Status.NEW_HEAD_WORKING_TREE)) {
            value -= 300;
        }
        if (this.containsStatus(Status.REMOVED_HEAD_INDEX)) {
            value -= 10;
        }
        if (this.containsStatus(Status.MODIFIED_HEAD_INDEX)) {
            value -= 20;
        }
        if (this.containsStatus(Status.NEW_HEAD_INDEX)) {
            value -= 30;
        }
        if (this.containsStatus(Status.REMOVED_INDEX_WORKING_TREE)) {
            --value;
        }
        if (this.containsStatus(Status.MODIFIED_INDEX_WORKING_TREE)) {
            value -= 2;
        }
        if (this.containsStatus(Status.NEW_INDEX_WORKING_TREE)) {
            value -= 3;
        }
        if (value == 400) {
            throw new IllegalArgumentException("Uncomparable status: " + this.getStatus());
        }
        return value;
    }

    public String getShortStatusText() {
        String sIndex = "";
        String sWorkingTree = "";
        sIndex = this.containsStatus(Status.NEW_HEAD_INDEX) ? (this.isRenamed() ? "R" : (this.isCopied() ? "C" : "A")) : (this.containsStatus(Status.MODIFIED_HEAD_INDEX) ? "M" : (this.containsStatus(Status.REMOVED_HEAD_INDEX) ? "D" : "-"));
        sWorkingTree = this.containsStatus(Status.NEW_INDEX_WORKING_TREE) ? "A" : (this.containsStatus(Status.MODIFIED_INDEX_WORKING_TREE) ? "M" : (this.containsStatus(Status.REMOVED_INDEX_WORKING_TREE) ? "D" : "-"));
        if (this.containsStatus(Status.NOTVERSIONED_EXCLUDED)) {
            return "I";
        }
        if (this.containsStatus(Status.IN_CONFLICT)) {
            switch (this.conflictType) {
                case ADDED_BY_THEM: {
                    return "UA";
                }
                case ADDED_BY_US: {
                    return "AU";
                }
                case BOTH_ADDED: {
                    return "AA";
                }
                case BOTH_DELETED: {
                    return "DD";
                }
                case BOTH_MODIFIED: {
                    return "UU";
                }
                case DELETED_BY_THEM: {
                    return "UD";
                }
                case DELETED_BY_US: {
                    return "DU";
                }
            }
            throw new IllegalStateException("Unknown conflict type: " + this.conflictType.toString());
        }
        if ("-".equals(sIndex) && "-".equals(sWorkingTree)) {
            return "";
        }
        return new MessageFormat("{0}/{1}").format(new Object[]{sIndex, sWorkingTree}, new StringBuffer(), (FieldPosition)null).toString();
    }

    public String getStatusText() {
        return this.getStatusText(Mode.HEAD_VS_WORKING_TREE);
    }

    public String getStatusText(Mode mode) {
        String sIndex = "";
        String sWorkingTree = "";
        sIndex = this.containsStatus(Status.NEW_HEAD_INDEX) ? (this.isRenamed() ? NbBundle.getMessage(FileInformation.class, (String)"CTL_FileInfoStatus_AddedRenamed_Short") : (this.isCopied() ? NbBundle.getMessage(FileInformation.class, (String)"CTL_FileInfoStatus_AddedCopied_Short") : NbBundle.getMessage(FileInformation.class, (String)"CTL_FileInfoStatus_Added_Short"))) : (this.containsStatus(Status.MODIFIED_HEAD_INDEX) ? NbBundle.getMessage(FileInformation.class, (String)"CTL_FileInfoStatus_Modified_Short") : (this.containsStatus(Status.REMOVED_HEAD_INDEX) ? NbBundle.getMessage(FileInformation.class, (String)"CTL_FileInfoStatus_Removed_Short") : "-"));
        sWorkingTree = this.containsStatus(Status.NEW_INDEX_WORKING_TREE) ? NbBundle.getMessage(FileInformation.class, (String)"CTL_FileInfoStatus_Added_Short") : (this.containsStatus(Status.MODIFIED_INDEX_WORKING_TREE) ? NbBundle.getMessage(FileInformation.class, (String)"CTL_FileInfoStatus_Modified_Short") : (this.containsStatus(Status.REMOVED_INDEX_WORKING_TREE) ? NbBundle.getMessage(FileInformation.class, (String)"CTL_FileInfoStatus_Removed_Short") : "-"));
        if (this.containsStatus(Status.NOTVERSIONED_EXCLUDED)) {
            return NbBundle.getMessage(FileInformation.class, (String)"CTL_FileInfoStatus_Excluded_Short");
        }
        if (this.containsStatus(Status.IN_CONFLICT)) {
            switch (this.conflictType) {
                case ADDED_BY_THEM: {
                    return NbBundle.getMessage(FileInformation.class, (String)"CTL_FileInfoStatus_Conflict_AddedByThem");
                }
                case ADDED_BY_US: {
                    return NbBundle.getMessage(FileInformation.class, (String)"CTL_FileInfoStatus_Conflict_AddedByUs");
                }
                case BOTH_ADDED: {
                    return NbBundle.getMessage(FileInformation.class, (String)"CTL_FileInfoStatus_Conflict_BothAdded");
                }
                case BOTH_DELETED: {
                    return NbBundle.getMessage(FileInformation.class, (String)"CTL_FileInfoStatus_Conflict_BothDeleted");
                }
                case BOTH_MODIFIED: {
                    return NbBundle.getMessage(FileInformation.class, (String)"CTL_FileInfoStatus_Conflict_BothModified");
                }
                case DELETED_BY_THEM: {
                    return NbBundle.getMessage(FileInformation.class, (String)"CTL_FileInfoStatus_Conflict_DeletedByThem");
                }
                case DELETED_BY_US: {
                    return NbBundle.getMessage(FileInformation.class, (String)"CTL_FileInfoStatus_Conflict_DeletedByUs");
                }
            }
            throw new IllegalStateException("Unknown conflict type: " + this.conflictType.toString());
        }
        if (Mode.HEAD_VS_INDEX == mode) {
            return new MessageFormat("{0}").format(new Object[]{sIndex});
        }
        if (Mode.INDEX_VS_WORKING_TREE == mode) {
            return new MessageFormat("{0}").format(new Object[]{sWorkingTree});
        }
        return new MessageFormat("{0}/{1}").format(new Object[]{sIndex, sWorkingTree}, new StringBuffer(), (FieldPosition)null).toString();
    }

    @Override
    public boolean isRenamed() {
        return this.renamed;
    }

    @Override
    public boolean isCopied() {
        return this.copied;
    }

    @Override
    public File getOldFile() {
        return this.oldFile;
    }

    public String annotateNameHtml(String name) {
        return Git.getInstance().getVCSAnnotator().annotateNameHtml(name, this, null);
    }

    public Color getAnnotatedColor() {
        return Git.getInstance().getVCSAnnotator().getAnnotatedColor(this);
    }

    public String toString() {
        return this.status.toString();
    }

    public static enum Status {
        UNKNOWN,
        NOTVERSIONED_NOTMANAGED,
        NOTVERSIONED_EXCLUDED,
        NEW_HEAD_INDEX,
        NEW_INDEX_WORKING_TREE,
        NEW_HEAD_WORKING_TREE,
        UPTODATE,
        MODIFIED_HEAD_INDEX,
        MODIFIED_HEAD_WORKING_TREE,
        MODIFIED_INDEX_WORKING_TREE,
        IN_CONFLICT,
        REMOVED_HEAD_INDEX,
        REMOVED_INDEX_WORKING_TREE,
        REMOVED_HEAD_WORKING_TREE;

    }

    public static enum Mode {
        HEAD_VS_WORKING_TREE,
        HEAD_VS_INDEX,
        INDEX_VS_WORKING_TREE;

    }
}

