/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TunnelSecurityAssociationSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="cpeSubnet")
    private final String cpeSubnet;
    @JsonProperty(value="oracleSubnet")
    private final String oracleSubnet;
    @JsonProperty(value="tunnelSaStatus")
    private final TunnelSaStatus tunnelSaStatus;
    @JsonProperty(value="tunnelSaErrorInfo")
    private final String tunnelSaErrorInfo;
    @JsonProperty(value="time")
    private final String time;

    @Deprecated
    @ConstructorProperties(value={"cpeSubnet", "oracleSubnet", "tunnelSaStatus", "tunnelSaErrorInfo", "time"})
    public TunnelSecurityAssociationSummary(String cpeSubnet, String oracleSubnet, TunnelSaStatus tunnelSaStatus, String tunnelSaErrorInfo, String time) {
        this.cpeSubnet = cpeSubnet;
        this.oracleSubnet = oracleSubnet;
        this.tunnelSaStatus = tunnelSaStatus;
        this.tunnelSaErrorInfo = tunnelSaErrorInfo;
        this.time = time;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCpeSubnet() {
        return this.cpeSubnet;
    }

    public String getOracleSubnet() {
        return this.oracleSubnet;
    }

    public TunnelSaStatus getTunnelSaStatus() {
        return this.tunnelSaStatus;
    }

    public String getTunnelSaErrorInfo() {
        return this.tunnelSaErrorInfo;
    }

    public String getTime() {
        return this.time;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TunnelSecurityAssociationSummary(");
        sb.append("super=").append(super.toString());
        sb.append("cpeSubnet=").append(String.valueOf(this.cpeSubnet));
        sb.append(", oracleSubnet=").append(String.valueOf(this.oracleSubnet));
        sb.append(", tunnelSaStatus=").append(String.valueOf((Object)this.tunnelSaStatus));
        sb.append(", tunnelSaErrorInfo=").append(String.valueOf(this.tunnelSaErrorInfo));
        sb.append(", time=").append(String.valueOf(this.time));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TunnelSecurityAssociationSummary)) {
            return false;
        }
        TunnelSecurityAssociationSummary other = (TunnelSecurityAssociationSummary)((Object)o);
        return Objects.equals(this.cpeSubnet, other.cpeSubnet) && Objects.equals(this.oracleSubnet, other.oracleSubnet) && Objects.equals((Object)this.tunnelSaStatus, (Object)other.tunnelSaStatus) && Objects.equals(this.tunnelSaErrorInfo, other.tunnelSaErrorInfo) && Objects.equals(this.time, other.time) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.cpeSubnet == null ? 43 : this.cpeSubnet.hashCode());
        result = result * 59 + (this.oracleSubnet == null ? 43 : this.oracleSubnet.hashCode());
        result = result * 59 + (this.tunnelSaStatus == null ? 43 : this.tunnelSaStatus.hashCode());
        result = result * 59 + (this.tunnelSaErrorInfo == null ? 43 : this.tunnelSaErrorInfo.hashCode());
        result = result * 59 + (this.time == null ? 43 : this.time.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum TunnelSaStatus implements BmcEnum
    {
        Initiating("INITIATING"),
        Listening("LISTENING"),
        Up("UP"),
        Down("DOWN"),
        Error("ERROR"),
        Unknown("UNKNOWN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TunnelSaStatus> map;

        private TunnelSaStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TunnelSaStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TunnelSaStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TunnelSaStatus.class);
            map = new HashMap<String, TunnelSaStatus>();
            for (TunnelSaStatus v : TunnelSaStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="cpeSubnet")
        private String cpeSubnet;
        @JsonProperty(value="oracleSubnet")
        private String oracleSubnet;
        @JsonProperty(value="tunnelSaStatus")
        private TunnelSaStatus tunnelSaStatus;
        @JsonProperty(value="tunnelSaErrorInfo")
        private String tunnelSaErrorInfo;
        @JsonProperty(value="time")
        private String time;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder cpeSubnet(String cpeSubnet) {
            this.cpeSubnet = cpeSubnet;
            this.__explicitlySet__.add("cpeSubnet");
            return this;
        }

        public Builder oracleSubnet(String oracleSubnet) {
            this.oracleSubnet = oracleSubnet;
            this.__explicitlySet__.add("oracleSubnet");
            return this;
        }

        public Builder tunnelSaStatus(TunnelSaStatus tunnelSaStatus) {
            this.tunnelSaStatus = tunnelSaStatus;
            this.__explicitlySet__.add("tunnelSaStatus");
            return this;
        }

        public Builder tunnelSaErrorInfo(String tunnelSaErrorInfo) {
            this.tunnelSaErrorInfo = tunnelSaErrorInfo;
            this.__explicitlySet__.add("tunnelSaErrorInfo");
            return this;
        }

        public Builder time(String time) {
            this.time = time;
            this.__explicitlySet__.add("time");
            return this;
        }

        public TunnelSecurityAssociationSummary build() {
            TunnelSecurityAssociationSummary model = new TunnelSecurityAssociationSummary(this.cpeSubnet, this.oracleSubnet, this.tunnelSaStatus, this.tunnelSaErrorInfo, this.time);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TunnelSecurityAssociationSummary model) {
            if (model.wasPropertyExplicitlySet("cpeSubnet")) {
                this.cpeSubnet(model.getCpeSubnet());
            }
            if (model.wasPropertyExplicitlySet("oracleSubnet")) {
                this.oracleSubnet(model.getOracleSubnet());
            }
            if (model.wasPropertyExplicitlySet("tunnelSaStatus")) {
                this.tunnelSaStatus(model.getTunnelSaStatus());
            }
            if (model.wasPropertyExplicitlySet("tunnelSaErrorInfo")) {
                this.tunnelSaErrorInfo(model.getTunnelSaErrorInfo());
            }
            if (model.wasPropertyExplicitlySet("time")) {
                this.time(model.getTime());
            }
            return this;
        }
    }
}

