/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.eecommon.api.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.common.EjbRef;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestination;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestinationRef;
import org.netbeans.modules.j2ee.dd.api.common.PortComponentRef;
import org.netbeans.modules.j2ee.dd.api.common.ResourceEnvRef;
import org.netbeans.modules.j2ee.dd.api.common.ResourceRef;
import org.netbeans.modules.j2ee.dd.api.common.RootInterface;
import org.netbeans.modules.j2ee.dd.api.common.SecurityRole;
import org.netbeans.modules.j2ee.dd.api.common.ServiceRef;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.EntityAndSession;
import org.netbeans.modules.j2ee.dd.api.ejb.MessageDriven;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.dd.api.webservices.PortComponent;
import org.netbeans.modules.j2ee.dd.api.webservices.ServiceImplBean;
import org.netbeans.modules.j2ee.dd.api.webservices.WebserviceDescription;
import org.netbeans.modules.j2ee.dd.api.webservices.Webservices;
import org.netbeans.modules.payara.eecommon.api.Utils;
import org.netbeans.modules.payara.eecommon.api.config.PayaraConfiguration;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class DescriptorListener
implements PropertyChangeListener {
    private final PayaraConfiguration config;
    private RootInterface stdRootDD = null;
    private PropertyChangeListener stdRootDDWeakListener = null;
    private RootInterface wsRootDD = null;
    private PropertyChangeListener wsRootDDWeakListener = null;
    private static final int EVENT_DELAY = 100;
    private PropertyChangeEvent lastEvent = null;
    private final Object lastEventMonitor = new Object();
    private final RequestProcessor.Task lastEventTask = RequestProcessor.getDefault().create(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = DescriptorListener.this.lastEventMonitor;
            synchronized (object) {
                if (DescriptorListener.this.lastEvent != null) {
                    DescriptorListener.this.processEvent(DescriptorListener.this.lastEvent);
                    DescriptorListener.this.lastEvent = null;
                }
            }
        }
    }, true);
    private static WeakHashMap<Class, WeakReference<NameVisitor>> visitorCache = new WeakHashMap();
    private static final List<NameVisitorFactory> nameVisitorFactories = new CopyOnWriteArrayList<NameVisitorFactory>();
    private static Map<String, BeanVisitor> handlerCache;

    public DescriptorListener(PayaraConfiguration sdc) {
        this.config = sdc;
    }

    public void addListener(RootInterface rootDD) {
        PropertyChangeListener weakListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)rootDD);
        if (rootDD instanceof Webservices) {
            if (this.wsRootDD != null && this.wsRootDDWeakListener != null) {
                this.wsRootDD.removePropertyChangeListener(this.wsRootDDWeakListener);
            }
            this.wsRootDD = rootDD;
            this.wsRootDDWeakListener = weakListener;
        } else {
            if (this.stdRootDD != null && this.stdRootDDWeakListener != null) {
                this.stdRootDD.removePropertyChangeListener(this.stdRootDDWeakListener);
            }
            this.stdRootDD = rootDD;
            this.stdRootDDWeakListener = weakListener;
        }
        rootDD.addPropertyChangeListener(weakListener);
    }

    public void removeListener(RootInterface rootDD) {
        if (this.wsRootDD == rootDD) {
            this.wsRootDD.removePropertyChangeListener(this.wsRootDDWeakListener);
            this.wsRootDDWeakListener = null;
            this.wsRootDD = null;
        } else if (this.stdRootDD == rootDD) {
            this.stdRootDD.removePropertyChangeListener(this.stdRootDDWeakListener);
            this.stdRootDDWeakListener = null;
            this.stdRootDD = null;
        }
    }

    public void removeListeners() {
        if (this.stdRootDD != null) {
            this.removeListener(this.stdRootDD);
        }
        if (this.wsRootDD != null) {
            this.removeListener(this.wsRootDD);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object object = this.lastEventMonitor;
        synchronized (object) {
            Logger.getLogger("payara-eecommon").log(Level.FINEST, "RAW EVENT: " + evt.getPropertyName() + ", old = " + evt.getOldValue() + ", new = " + evt.getNewValue() + ", source = " + evt.getSource());
            if (this.lastEvent != null) {
                this.lastEventTask.cancel();
                if (!(this.isCreateBeanEvent(evt) && this.isVeiledRenameEvent(this.lastEvent, evt) && this.processAsChangeNameEvent(this.lastEvent, evt))) {
                    this.processEvent(this.lastEvent);
                    this.processEvent(evt);
                }
                this.lastEvent = null;
            } else if (this.isDeleteBeanEvent(evt)) {
                this.lastEvent = evt;
                this.lastEventTask.schedule(100);
            } else {
                this.processEvent(evt);
            }
        }
    }

    private boolean isDeleteBeanEvent(PropertyChangeEvent evt) {
        return evt.getOldValue() instanceof CommonDDBean && evt.getNewValue() == null;
    }

    private boolean isCreateBeanEvent(PropertyChangeEvent evt) {
        return evt.getOldValue() == null && evt.getNewValue() instanceof CommonDDBean;
    }

    private boolean isVeiledRenameEvent(PropertyChangeEvent deleteEvent, PropertyChangeEvent createEvent) {
        if (deleteEvent.getSource() != createEvent.getSource()) {
            return false;
        }
        if (!deleteEvent.getOldValue().getClass().equals(createEvent.getNewValue().getClass())) {
            return false;
        }
        return DescriptorListener.xcompare(deleteEvent.getPropertyName(), createEvent.getPropertyName());
    }

    private boolean processAsChangeNameEvent(PropertyChangeEvent deleteEvent, PropertyChangeEvent createEvent) {
        boolean result = false;
        CommonDDBean newBean = (CommonDDBean)createEvent.getNewValue();
        NameVisitor nameVisitor = DescriptorListener.getNameVisitor(newBean);
        if (nameVisitor != null) {
            String newName;
            CommonDDBean oldBean = (CommonDDBean)deleteEvent.getOldValue();
            String oldName = nameVisitor.getName(oldBean);
            if (!Utils.strEquals(oldName, newName = nameVisitor.getName(newBean))) {
                PropertyChangeEvent changeEvent = new PropertyChangeEvent(newBean, createEvent.getPropertyName() + nameVisitor.getNameProperty(), oldName, newName);
                Logger.getLogger("payara-eecommon").log(Level.FINE, "processing delete/create sequence as change name event.");
                this.processEvent(changeEvent);
                result = true;
            }
        } else {
            Logger.getLogger("payara-eecommon").log(Level.FINE, "No support for delete/create sequence from type " + newBean.getClass().getSimpleName());
        }
        return result;
    }

    private void processEvent(PropertyChangeEvent evt) {
        Logger.getLogger("payara-eecommon").log(Level.FINER, "PROCESSED EVENT: " + evt.getPropertyName() + ", old = " + evt.getOldValue() + ", new = " + evt.getNewValue() + ", source = " + evt.getSource());
        String xpath = this.makeXpath(evt.getPropertyName());
        BeanVisitor visitor = handlerCache.get(xpath);
        if (visitor != null) {
            Object oldValue = evt.getOldValue();
            Object newValue = evt.getNewValue();
            if (oldValue == null) {
                if (newValue instanceof CommonDDBean) {
                    visitor.beanCreated(this.config, xpath, (CommonDDBean)evt.getSource(), (CommonDDBean)newValue);
                } else if (newValue != null) {
                    visitor.fieldCreated(this.config, xpath, (CommonDDBean)evt.getSource(), newValue);
                }
            } else if (newValue == null) {
                if (oldValue instanceof CommonDDBean) {
                    visitor.beanDeleted(this.config, xpath, (CommonDDBean)evt.getSource(), (CommonDDBean)oldValue);
                } else if (oldValue != null) {
                    visitor.fieldDeleted(this.config, xpath, (CommonDDBean)evt.getSource(), oldValue);
                }
            } else if (oldValue instanceof CommonDDBean && newValue instanceof CommonDDBean) {
                visitor.beanChanged(this.config, xpath, (CommonDDBean)evt.getSource(), (CommonDDBean)oldValue, (CommonDDBean)newValue);
            } else if (oldValue != null && newValue != null) {
                visitor.fieldChanged(this.config, xpath, (CommonDDBean)evt.getSource(), oldValue, newValue);
            }
        }
    }

    private String makeXpath(String ddpath) {
        StringBuilder xpathBuilder = new StringBuilder(ddpath.length());
        int len = ddpath.length();
        for (int i = 0; i < len; ++i) {
            char c = ddpath.charAt(i);
            if (c == '.') {
                while (++i < len && (c = ddpath.charAt(i)) != '/') {
                }
            }
            if (i >= len) continue;
            xpathBuilder.append(c);
        }
        return xpathBuilder.toString();
    }

    private static boolean xcompare(String a, String b) {
        int j;
        boolean result = true;
        int alen = a.length();
        int blen = b.length();
        int i = 0;
        for (j = 0; i < alen && j < blen; ++i, ++j) {
            char bb;
            char aa = a.charAt(i);
            if (aa == (bb = b.charAt(j))) {
                if (aa != '.') continue;
                boolean aslash = false;
                boolean bslash = false;
                while (++i < alen) {
                    if (a.charAt(i) != '/') continue;
                    aslash = true;
                    break;
                }
                while (++j < blen) {
                    if (b.charAt(j) != '/') continue;
                    bslash = true;
                    break;
                }
                if (aslash == bslash) continue;
                result = false;
                break;
            }
            result = false;
            break;
        }
        if (result && (i < alen || j < blen)) {
            result = false;
        }
        return result;
    }

    public static synchronized NameVisitor getNameVisitor(CommonDDBean bean) {
        NameVisitor result = null;
        Class<?> beanClass = bean.getClass();
        WeakReference<NameVisitor> ref = visitorCache.get(beanClass);
        if (ref != null) {
            result = (NameVisitor)ref.get();
        }
        if (result == null && (result = DescriptorListener.createNameVisitor(bean)) != null) {
            visitorCache.put(beanClass, new WeakReference<NameVisitor>(result));
        }
        return result;
    }

    public static void addNameVisitorFactory(NameVisitorFactory factory) {
        nameVisitorFactories.add(factory);
    }

    private static final NameVisitor createNameVisitor(CommonDDBean bean) {
        NameVisitorFactory factory;
        NameVisitor result = null;
        Iterator<NameVisitorFactory> iterator = nameVisitorFactories.iterator();
        while (iterator.hasNext() && (result = (factory = iterator.next()).createNameVisitor(bean)) == null) {
        }
        return result;
    }

    public static void addBeanVisitorMappings(Map<String, BeanVisitor> mappings) {
        handlerCache.putAll(mappings);
    }

    private static void initBeanVisitorMap() {
        EntityAndSessionVisitor entitySessionVisitor = new EntityAndSessionVisitor();
        EntityAndSessionRemoteVisitor entitySessionRemoteVisitor = new EntityAndSessionRemoteVisitor();
        handlerCache.put("/EjbJar/EnterpriseBeans", entitySessionVisitor);
        handlerCache.put("/EjbJar/EnterpriseBeans/Session", entitySessionVisitor);
        handlerCache.put("/EjbJar/EnterpriseBeans/Session/Remote", entitySessionRemoteVisitor);
        handlerCache.put("/EjbJar/EnterpriseBeans/Entity", entitySessionVisitor);
        handlerCache.put("/EjbJar/EnterpriseBeans/Entity/Remote", entitySessionRemoteVisitor);
        WebserviceDescriptionBeanVisitor wsDescVisitor = new WebserviceDescriptionBeanVisitor();
        handlerCache.put("/Webservices/WebserviceDescription", wsDescVisitor);
        handlerCache.put("/Webservices/WebserviceDescription/PortComponent", wsDescVisitor);
    }

    static {
        nameVisitorFactories.add(new BasicNameVisitorFactory());
        handlerCache = new HashMap<String, BeanVisitor>(37);
        DescriptorListener.initBeanVisitorMap();
    }

    public static interface NameVisitor {
        public String getName(CommonDDBean var1);

        public String getNameProperty();
    }

    public static interface BeanVisitor {
        public void beanCreated(PayaraConfiguration var1, String var2, CommonDDBean var3, CommonDDBean var4);

        public void beanDeleted(PayaraConfiguration var1, String var2, CommonDDBean var3, CommonDDBean var4);

        public void beanChanged(PayaraConfiguration var1, String var2, CommonDDBean var3, CommonDDBean var4, CommonDDBean var5);

        public void fieldCreated(PayaraConfiguration var1, String var2, Object var3, Object var4);

        public void fieldDeleted(PayaraConfiguration var1, String var2, Object var3, Object var4);

        public void fieldChanged(PayaraConfiguration var1, String var2, Object var3, Object var4, Object var5);
    }

    public static interface NameVisitorFactory {
        public NameVisitor createNameVisitor(CommonDDBean var1);
    }

    public static class EntityAndSessionVisitor
    extends AbstractBeanVisitor {
        @Override
        public void beanCreated(PayaraConfiguration config, String xpath, CommonDDBean sourceDD, CommonDDBean newDD) {
            if (newDD instanceof EntityAndSession) {
                this.entitySessionUpdated(config, (EntityAndSession)newDD, PayaraConfiguration.ChangeOperation.CREATE);
            } else if (newDD instanceof EnterpriseBeans) {
                this.enterpriseBeansUpdated(config, (EnterpriseBeans)newDD, PayaraConfiguration.ChangeOperation.CREATE);
            }
        }

        @Override
        public void beanDeleted(PayaraConfiguration config, String xpath, CommonDDBean sourceDD, CommonDDBean oldDD) {
            if (oldDD instanceof EntityAndSession) {
                this.entitySessionUpdated(config, (EntityAndSession)oldDD, PayaraConfiguration.ChangeOperation.DELETE);
            } else if (oldDD instanceof EnterpriseBeans) {
                this.enterpriseBeansUpdated(config, (EnterpriseBeans)oldDD, PayaraConfiguration.ChangeOperation.DELETE);
            }
        }

        private void enterpriseBeansUpdated(PayaraConfiguration config, EnterpriseBeans ebDD, PayaraConfiguration.ChangeOperation operation) {
            Entity[] entityDDs;
            Session[] sessionDDs = ebDD.getSession();
            if (sessionDDs != null && sessionDDs.length > 0) {
                for (Session sessionDD : sessionDDs) {
                    if (sessionDD == null) continue;
                    this.entitySessionUpdated(config, (EntityAndSession)sessionDD, operation);
                }
            }
            if ((entityDDs = ebDD.getEntity()) != null && entityDDs.length > 0) {
                for (Entity entityDD : entityDDs) {
                    if (entityDD == null) continue;
                    this.entitySessionUpdated(config, (EntityAndSession)entityDD, operation);
                }
            }
        }

        private void entitySessionUpdated(PayaraConfiguration config, EntityAndSession ejbDD, PayaraConfiguration.ChangeOperation operation) {
            String ejbName = ejbDD.getEjbName();
            String remote = ejbDD.getRemote();
            if (Utils.notEmpty(ejbName) && (operation == PayaraConfiguration.ChangeOperation.DELETE || Utils.notEmpty(remote))) {
                config.updateDefaultEjbJndiName(ejbName, "ejb/", operation);
            }
        }
    }

    public static final class EntityAndSessionRemoteVisitor
    extends AbstractBeanVisitor {
        @Override
        public void fieldCreated(PayaraConfiguration config, String xpath, Object sourceDD, Object newValue) {
            this.remoteFieldUpdated(config, (EntityAndSession)sourceDD, (String)newValue, PayaraConfiguration.ChangeOperation.CREATE);
        }

        @Override
        public void fieldDeleted(PayaraConfiguration config, String xpath, Object sourceDD, Object newValue) {
            this.remoteFieldUpdated(config, (EntityAndSession)sourceDD, null, PayaraConfiguration.ChangeOperation.DELETE);
        }

        private void remoteFieldUpdated(PayaraConfiguration config, EntityAndSession ejbDD, String remote, PayaraConfiguration.ChangeOperation operation) {
            String ejbName = ejbDD.getEjbName();
            if (Utils.notEmpty(ejbName) && (operation == PayaraConfiguration.ChangeOperation.DELETE || Utils.notEmpty(remote))) {
                config.updateDefaultEjbJndiName(ejbName, "ejb/", operation);
            }
        }
    }

    public static final class WebserviceDescriptionBeanVisitor
    extends AbstractBeanVisitor {
        @Override
        public void beanCreated(PayaraConfiguration config, String xpath, CommonDDBean sourceDD, CommonDDBean newDD) {
            if (newDD instanceof WebserviceDescription) {
                this.webserviceDescriptionUpdated(config, (WebserviceDescription)newDD, PayaraConfiguration.ChangeOperation.CREATE);
            } else if (newDD instanceof PortComponent) {
                this.portComponentUpdated(config, (PortComponent)newDD, PayaraConfiguration.ChangeOperation.CREATE);
            }
        }

        @Override
        public void beanDeleted(PayaraConfiguration config, String xpath, CommonDDBean sourceDD, CommonDDBean oldDD) {
            if (oldDD instanceof WebserviceDescription) {
                this.webserviceDescriptionUpdated(config, (WebserviceDescription)oldDD, PayaraConfiguration.ChangeOperation.DELETE);
            } else if (oldDD instanceof PortComponent) {
                this.portComponentUpdated(config, (PortComponent)oldDD, PayaraConfiguration.ChangeOperation.DELETE);
            }
        }

        private void webserviceDescriptionUpdated(PayaraConfiguration config, WebserviceDescription wsDescDD, PayaraConfiguration.ChangeOperation operation) {
            PortComponent[] portDDs = wsDescDD.getPortComponent();
            if (portDDs != null && portDDs.length > 0) {
                for (PortComponent portDD : portDDs) {
                    if (portDD == null) continue;
                    this.portComponentUpdated(config, portDD, operation);
                }
            }
        }

        private void portComponentUpdated(PayaraConfiguration config, PortComponent portDD, PayaraConfiguration.ChangeOperation operation) {
            String portName = portDD.getPortComponentName();
            String linkName = this.getLinkName(portDD);
            if (Utils.notEmpty(portName) && Utils.notEmpty(linkName)) {
                config.updateDefaultEjbEndpointUri(linkName, portName, operation);
            }
        }

        private String getLinkName(PortComponent portDD) {
            String result = null;
            ServiceImplBean sib = portDD.getServiceImplBean();
            if (sib != null && (result = sib.getServletLink()) == null) {
                result = sib.getEjbLink();
            }
            return result;
        }
    }

    private static final class BasicNameVisitorFactory
    implements NameVisitorFactory {
        private BasicNameVisitorFactory() {
        }

        @Override
        public NameVisitor createNameVisitor(CommonDDBean bean) {
            NameVisitor result = null;
            if (bean instanceof Session) {
                result = new SessionBeanVisitor();
            } else if (bean instanceof MessageDriven) {
                result = new MDBeanVisitor();
            } else if (bean instanceof Entity) {
                result = new EntityBeanVisitor();
            } else if (bean instanceof EjbRef) {
                result = new EjbRefVisitor();
            } else if (bean instanceof MessageDestinationRef) {
                result = new MessageDestinationRefVisitor();
            } else if (bean instanceof ResourceEnvRef) {
                result = new ResourceEnvRefVisitor();
            } else if (bean instanceof ResourceRef) {
                result = new ResourceRefVisitor();
            } else if (bean instanceof ServiceRef) {
                result = new ServiceRefVisitor();
            } else if (bean instanceof MessageDestination) {
                result = new MessageDestinationVisitor();
            } else if (bean instanceof SecurityRole) {
                result = new SecurityRoleVisitor();
            } else if (bean instanceof PortComponent) {
                result = new PortComponentVisitor();
            } else if (bean instanceof PortComponentRef) {
                result = new PortComponentRefVisitor();
            }
            return result;
        }
    }

    public static final class MessageDrivenVisitor
    extends AbstractBeanVisitor {
        @Override
        public void beanCreated(PayaraConfiguration config, String xpath, CommonDDBean sourceDD, CommonDDBean newDD) {
            this.mdbUpdated(config, (MessageDriven)newDD, PayaraConfiguration.ChangeOperation.CREATE);
        }

        @Override
        public void beanDeleted(PayaraConfiguration config, String xpath, CommonDDBean sourceDD, CommonDDBean oldDD) {
            this.mdbUpdated(config, (MessageDriven)oldDD, PayaraConfiguration.ChangeOperation.DELETE);
        }

        private void mdbUpdated(PayaraConfiguration config, MessageDriven mdbDD, PayaraConfiguration.ChangeOperation operation) {
            String ejbName = mdbDD.getEjbName();
            if (Utils.notEmpty(ejbName)) {
                config.updateDefaultEjbJndiName(ejbName, "jms/", operation);
            }
        }
    }

    public static abstract class AbstractBeanVisitor
    implements BeanVisitor {
        @Override
        public void beanCreated(PayaraConfiguration config, String xpath, CommonDDBean sourceDD, CommonDDBean newDD) {
        }

        @Override
        public void beanDeleted(PayaraConfiguration config, String xpath, CommonDDBean sourceDD, CommonDDBean oldDD) {
        }

        @Override
        public void beanChanged(PayaraConfiguration config, String xpath, CommonDDBean sourceDD, CommonDDBean oldDD, CommonDDBean newDD) {
        }

        @Override
        public void fieldCreated(PayaraConfiguration config, String xpath, Object sourceDD, Object newValue) {
        }

        @Override
        public void fieldDeleted(PayaraConfiguration config, String xpath, Object sourceDD, Object oldValue) {
        }

        @Override
        public void fieldChanged(PayaraConfiguration config, String xpath, Object sourceDD, Object oldValue, Object newValue) {
        }
    }

    public static class SecurityRoleVisitor
    implements NameVisitor {
        @Override
        public String getName(CommonDDBean bean) {
            return ((SecurityRole)bean).getRoleName();
        }

        @Override
        public String getNameProperty() {
            return "/RoleName";
        }
    }

    public static class MessageDestinationVisitor
    implements NameVisitor {
        @Override
        public String getName(CommonDDBean bean) {
            return ((MessageDestination)bean).getMessageDestinationName();
        }

        @Override
        public String getNameProperty() {
            return "/MessageDestinationName";
        }
    }

    public static class PortComponentVisitor
    implements NameVisitor {
        @Override
        public String getName(CommonDDBean bean) {
            return ((PortComponent)bean).getPortComponentName();
        }

        @Override
        public String getNameProperty() {
            return "/PortComponentName";
        }
    }

    public static class PortComponentRefVisitor
    implements NameVisitor {
        @Override
        public String getName(CommonDDBean bean) {
            return ((PortComponentRef)bean).getServiceEndpointInterface();
        }

        @Override
        public String getNameProperty() {
            return "/ServiceEndpointInterface";
        }
    }

    public static class ServiceRefVisitor
    implements NameVisitor {
        @Override
        public String getName(CommonDDBean bean) {
            return ((ServiceRef)bean).getServiceRefName();
        }

        @Override
        public String getNameProperty() {
            return "/ServiceRefName";
        }
    }

    public static class ResourceRefVisitor
    implements NameVisitor {
        @Override
        public String getName(CommonDDBean bean) {
            return ((ResourceRef)bean).getResRefName();
        }

        @Override
        public String getNameProperty() {
            return "/ResRefName";
        }
    }

    public static class ResourceEnvRefVisitor
    implements NameVisitor {
        @Override
        public String getName(CommonDDBean bean) {
            return ((ResourceEnvRef)bean).getResourceEnvRefName();
        }

        @Override
        public String getNameProperty() {
            return "/ResourceEnvRefName";
        }
    }

    public static class MessageDestinationRefVisitor
    implements NameVisitor {
        @Override
        public String getName(CommonDDBean bean) {
            return ((MessageDestinationRef)bean).getMessageDestinationRefName();
        }

        @Override
        public String getNameProperty() {
            return "/MessageDestinationRefName";
        }
    }

    public static class EjbRefVisitor
    implements NameVisitor {
        @Override
        public String getName(CommonDDBean bean) {
            return ((EjbRef)bean).getEjbRefName();
        }

        @Override
        public String getNameProperty() {
            return "/EjbRefName";
        }
    }

    public static class EntityBeanVisitor
    implements NameVisitor {
        @Override
        public String getName(CommonDDBean bean) {
            return ((Entity)bean).getEjbName();
        }

        @Override
        public String getNameProperty() {
            return "/EjbName";
        }
    }

    public static class MDBeanVisitor
    implements NameVisitor {
        @Override
        public String getName(CommonDDBean bean) {
            return ((MessageDriven)bean).getEjbName();
        }

        @Override
        public String getNameProperty() {
            return "/EjbName";
        }
    }

    public static class SessionBeanVisitor
    implements NameVisitor {
        @Override
        public String getName(CommonDDBean bean) {
            return ((Session)bean).getEjbName();
        }

        @Override
        public String getNameProperty() {
            return "/EjbName";
        }
    }
}

