/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.transfer;

import com.oracle.bmc.util.internal.Validate;
import java.time.Duration;
import java.util.concurrent.ExecutorService;

public class DownloadConfiguration {
    static final int MIN_PART_SIZE_IN_BYTES = 0x400000;
    private static final int MAX_PART_SIZE_IN_BYTES = 0x40000000;
    private static final int MAX_PARALLEL_DOWNLOADS = 256;
    private static final long MAX_MULTIPART_DOWNLOAD_THRESHOLD = 0x140000000L;
    private final int maxRetries;
    private final Duration initialBackoff;
    private final Duration maxBackoff;
    private final int partSizeInBytes;
    private final long multipartDownloadThresholdInBytes;
    private final int parallelDownloads;
    private final ExecutorService executorService;

    public DownloadConfiguration(int maxRetries, Duration initialBackoff, Duration maxBackoff, int partSizeInBytes, long multipartDownloadThresholdInBytes, int parallelDownloads, ExecutorService executorService) {
        Validate.isTrue((maxRetries >= 0 ? 1 : 0) != 0, (String)"maxRetries [%s] must be greater than or equal to %s", (Object[])new Object[]{maxRetries, 0});
        Validate.isTrue((initialBackoff.compareTo(Duration.ofMillis(1L)) >= 0 ? 1 : 0) != 0, (String)"initialBackoff [%s] must be greater than %s", (Object[])new Object[]{initialBackoff, Duration.ZERO});
        Validate.isTrue((maxBackoff.compareTo(initialBackoff) >= 0 ? 1 : 0) != 0, (String)"maxBackoff [%s] must be greater than or equal to initialBackoff [%s]", (Object[])new Object[]{maxBackoff, initialBackoff});
        Validate.inclusiveBetween((long)0x400000L, (long)0x40000000L, (long)partSizeInBytes, (String)"partSizeInBytes [%s] must be between %s and %s", (Object[])new Object[]{partSizeInBytes, 0x400000, 0x40000000});
        Validate.inclusiveBetween((long)0x400000L, (long)0x140000000L, (long)multipartDownloadThresholdInBytes, (String)"multipartDownloadThresholdInBytes [%s] must be between %s and %s", (Object[])new Object[]{multipartDownloadThresholdInBytes, 0x400000, 0x140000000L});
        Validate.inclusiveBetween((long)0L, (long)256L, (long)parallelDownloads, (String)"parallelDownloads [%s] must be between %s and %s", (Object[])new Object[]{parallelDownloads, 0, 256});
        this.maxRetries = maxRetries;
        this.initialBackoff = initialBackoff;
        this.maxBackoff = maxBackoff;
        this.partSizeInBytes = partSizeInBytes;
        this.multipartDownloadThresholdInBytes = multipartDownloadThresholdInBytes;
        this.parallelDownloads = parallelDownloads;
        this.executorService = executorService;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public Duration getInitialBackoff() {
        return this.initialBackoff;
    }

    public Duration getMaxBackoff() {
        return this.maxBackoff;
    }

    public int getPartSizeInBytes() {
        return this.partSizeInBytes;
    }

    public long getMultipartDownloadThresholdInBytes() {
        return this.multipartDownloadThresholdInBytes;
    }

    public int getParallelDownloads() {
        return this.parallelDownloads;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public static class Builder {
        private int maxRetries = 10;
        private Duration initialBackoff = Duration.ofMillis(100L);
        private Duration maxBackoff = Duration.ofSeconds(30L);
        private int partSizeInBytes = 0x2000000;
        private long multipartDownloadThresholdInBytes = 0x800000L;
        private int parallelDownloads = 3;
        private ExecutorService executorService = null;

        private Builder() {
        }

        public DownloadConfiguration build() {
            return new DownloadConfiguration(this.maxRetries, this.initialBackoff, this.maxBackoff, this.partSizeInBytes, this.multipartDownloadThresholdInBytes, this.parallelDownloads, this.executorService);
        }

        public Builder copy(DownloadConfiguration that) {
            this.maxRetries = that.maxRetries;
            this.initialBackoff = that.initialBackoff;
            this.maxBackoff = that.maxBackoff;
            this.partSizeInBytes = that.partSizeInBytes;
            this.multipartDownloadThresholdInBytes = that.multipartDownloadThresholdInBytes;
            this.parallelDownloads = that.parallelDownloads;
            this.executorService = that.executorService;
            return this;
        }

        public Builder maxRetries(int value) {
            this.maxRetries = value;
            return this;
        }

        public Builder initialBackoff(Duration value) {
            this.initialBackoff = value;
            return this;
        }

        public Builder maxBackoff(Duration value) {
            this.maxBackoff = value;
            return this;
        }

        public Builder partSizeInBytes(int value) {
            this.partSizeInBytes = value;
            return this;
        }

        public Builder multipartDownloadThresholdInBytes(long value) {
            this.multipartDownloadThresholdInBytes = value;
            return this;
        }

        public Builder parallelDownloads(int value) {
            this.parallelDownloads = value;
            return this;
        }

        public Builder executorService(ExecutorService value) {
            this.executorService = value;
            return this;
        }
    }
}

