/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.primefaces;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.netbeans.modules.web.jsfapi.api.Attribute;
import org.netbeans.modules.web.jsfapi.api.DefaultLibraryInfo;
import org.netbeans.modules.web.jsfapi.api.Library;
import org.netbeans.modules.web.jsfapi.api.LibraryInfo;
import org.netbeans.modules.web.jsfapi.api.Tag;
import org.netbeans.modules.web.jsfapi.api.TagFeature;
import org.netbeans.modules.web.jsfapi.spi.TagFeatureProvider;

public class PrimeFacesTagFeatureProvider
implements TagFeatureProvider {
    private static final String VALUE = "value";
    private static final String VAR = "var";
    private static final Map<LibraryInfo, Map<String, IterableTag>> TAGS_MAP = Stream.of(IterableTag.values()).collect(Collectors.groupingBy(IterableTag::getLibraryInfo, Collectors.toMap(IterableTag::getName, Function.identity())));

    public <T extends TagFeature> Collection<T> getFeatures(final Tag tag, Library library, Class<T> clazz) {
        IterableTag iterableTag;
        if (clazz.equals(TagFeature.IterableTagPattern.class) && (iterableTag = this.resolveIterableTag(library, tag)) != null) {
            return Collections.singleton((TagFeature)clazz.cast(new TagFeature.IterableTagPattern(){

                public Attribute getVariable() {
                    return tag.getAttribute(iterableTag.getVariableAttribute());
                }

                public Attribute getItems() {
                    return tag.getAttribute(iterableTag.getItemsAttribute());
                }
            }));
        }
        return Collections.emptyList();
    }

    private IterableTag resolveIterableTag(Library library, Tag tag) {
        String libraryNamespace = library.getNamespace();
        if (libraryNamespace == null) {
            return null;
        }
        LibraryInfo libraryInfo = DefaultLibraryInfo.forNamespace((String)libraryNamespace);
        if (libraryInfo == null) {
            return null;
        }
        return Optional.ofNullable(TAGS_MAP.get(libraryInfo)).map(subMap -> (IterableTag)((Object)((Object)subMap.get(tag.getName())))).orElse(null);
    }

    private static enum IterableTag {
        ACCORDION_PANEL(DefaultLibraryInfo.PRIMEFACES, "accordionPanel", "value", "var"),
        CAROUSEL(DefaultLibraryInfo.PRIMEFACES, "carousel", "value", "var"),
        CHRONOLINE(DefaultLibraryInfo.PRIMEFACES, "chronoline", "value", "var"),
        COLUMNS(DefaultLibraryInfo.PRIMEFACES, "columns", "value", "var"),
        DATA_GRID(DefaultLibraryInfo.PRIMEFACES, "dataGrid", "value", "var"),
        DATA_LIST(DefaultLibraryInfo.PRIMEFACES, "dataList", "value", "var"),
        DATA_SCROLLER(DefaultLibraryInfo.PRIMEFACES, "dataScroller", "value", "var"),
        DATA_TABLE(DefaultLibraryInfo.PRIMEFACES, "dataTable", "value", "var"),
        DATA_VIEW(DefaultLibraryInfo.PRIMEFACES, "dataView", "value", "var"),
        FEED_READER(DefaultLibraryInfo.PRIMEFACES, "feedReader", "value", "var"),
        GALLERIA(DefaultLibraryInfo.PRIMEFACES, "galleria", "value", "var"),
        ORDER_LIST(DefaultLibraryInfo.PRIMEFACES, "orderList", "value", "var"),
        PICK_LIST(DefaultLibraryInfo.PRIMEFACES, "pickList", "value", "var"),
        RING(DefaultLibraryInfo.PRIMEFACES, "ring", "value", "var"),
        SHEET(DefaultLibraryInfo.PRIMEFACES, "sheet", "value", "var"),
        SUB_TABLE(DefaultLibraryInfo.PRIMEFACES, "subTable", "value", "var"),
        TAB_VIEW(DefaultLibraryInfo.PRIMEFACES, "tabView", "value", "var"),
        TREE(DefaultLibraryInfo.PRIMEFACES, "tree", "value", "var"),
        TREE_TABLE(DefaultLibraryInfo.PRIMEFACES, "treeTable", "value", "var"),
        PE_FLUID_GRID(DefaultLibraryInfo.PRIMEFACES_EXTENSIONS, "fluidGrid", "value", "var"),
        PE_SHEET(DefaultLibraryInfo.PRIMEFACES_EXTENSIONS, "sheet", "value", "var");

        private final DefaultLibraryInfo libraryInfo;
        private final String name;
        private final String itemsAttribute;
        private final String variableAttribute;

        private IterableTag(DefaultLibraryInfo libraryInfo, String name, String itemsAttribute, String variableAttribute) {
            this.libraryInfo = libraryInfo;
            this.name = name;
            this.itemsAttribute = itemsAttribute;
            this.variableAttribute = variableAttribute;
        }

        public DefaultLibraryInfo getLibraryInfo() {
            return this.libraryInfo;
        }

        public String getName() {
            return this.name;
        }

        public String getItemsAttribute() {
            return this.itemsAttribute;
        }

        public String getVariableAttribute() {
            return this.variableAttribute;
        }
    }
}

