/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui;

import java.lang.reflect.Method;
import org.netbeans.modules.debugger.ui.DebuggerManagerListener;
import org.openide.LifecycleManager;
import org.openide.modules.ModuleInstall;
import org.openide.util.Exceptions;
import org.openide.windows.WindowManager;
import org.openide.windows.WindowSystemEvent;
import org.openide.windows.WindowSystemListener;

public class DebuggerModule
extends ModuleInstall
implements WindowSystemListener {
    private volatile boolean closing = false;

    public void restored() {
        WindowManager.getDefault().addWindowSystemListener((WindowSystemListener)this);
        super.restored();
    }

    public boolean closing() {
        this.closing = true;
        return true;
    }

    public boolean isClosing() {
        return this.closing && this.isExiting();
    }

    private boolean isExiting() {
        LifecycleManager lcm = LifecycleManager.getDefault();
        try {
            Method isExitingMethod = lcm.getClass().getMethod("isExiting", new Class[0]);
            return (Boolean)isExitingMethod.invoke((Object)lcm, new Object[0]);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
    }

    public void close() {
        WindowManager.getDefault().removeWindowSystemListener((WindowSystemListener)this);
        super.close();
    }

    public void uninstalled() {
        super.uninstalled();
        WindowManager.getDefault().removeWindowSystemListener((WindowSystemListener)this);
    }

    public void beforeLoad(WindowSystemEvent event) {
    }

    public void afterLoad(WindowSystemEvent event) {
    }

    public void beforeSave(WindowSystemEvent event) {
        if (this.isClosing()) {
            DebuggerManagerListener.closeDebuggerUI();
        }
    }

    public void afterSave(WindowSystemEvent event) {
    }
}

