/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.editor.codetemplates;

import java.util.Set;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateFilter;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.editor.completion.GsfCompletionProvider;

public class GsfCodeTemplateFilter
implements CodeTemplateFilter {
    private int startOffset;
    private int endOffset;
    private Set<String> templates;

    private GsfCodeTemplateFilter(Document doc, int startOffset, int endOffset) {
        CodeCompletionHandler completer;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        CodeCompletionHandler codeCompletionHandler = completer = doc == null ? null : GsfCompletionProvider.getCompletable(doc, startOffset);
        if (completer != null) {
            this.templates = completer.getApplicableTemplates(doc, startOffset, endOffset);
        }
    }

    public boolean accept(CodeTemplate template) {
        if (this.templates != null && template != null && template.getParametrizedText().indexOf("${selection") != -1) {
            return this.templates.contains(template.getAbbreviation()) || template.getParametrizedText().indexOf("allowSurround") != -1;
        }
        return true;
    }

    public static final class Factory
    implements CodeTemplateFilter.Factory {
        public CodeTemplateFilter createFilter(JTextComponent component, int offset) {
            return this.createFilter(component.getDocument(), offset, component.getSelectionStart() == offset ? component.getSelectionEnd() : -1);
        }

        public CodeTemplateFilter createFilter(Document doc, int startOffset, int endOffset) {
            return new GsfCodeTemplateFilter(doc, startOffset, endOffset);
        }
    }
}

