/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javap;

import com.sun.tools.classfile.AccessFlags;
import com.sun.tools.classfile.Attribute;
import com.sun.tools.classfile.Attributes;
import com.sun.tools.classfile.ClassFile;
import com.sun.tools.classfile.Code_attribute;
import com.sun.tools.classfile.ConstantPool;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.classfile.ConstantValue_attribute;
import com.sun.tools.classfile.Descriptor;
import com.sun.tools.classfile.Exceptions_attribute;
import com.sun.tools.classfile.Field;
import com.sun.tools.classfile.Method;
import com.sun.tools.classfile.Module_attribute;
import com.sun.tools.classfile.Signature;
import com.sun.tools.classfile.Signature_attribute;
import com.sun.tools.classfile.SourceFile_attribute;
import com.sun.tools.classfile.Type;
import com.sun.tools.javap.AttributeWriter;
import com.sun.tools.javap.BasicWriter;
import com.sun.tools.javap.CodeWriter;
import com.sun.tools.javap.ConstantWriter;
import com.sun.tools.javap.Context;
import com.sun.tools.javap.Options;
import java.net.URI;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class ClassWriter
extends BasicWriter {
    private static final int DEFAULT_ALLOWED_MAJOR_VERSION = 52;
    private static final int DEFAULT_ALLOWED_MINOR_VERSION = 0;
    private final Options options;
    private final AttributeWriter attrWriter;
    private final CodeWriter codeWriter;
    private final ConstantWriter constantWriter;
    private ClassFile classFile;
    private URI uri;
    private long lastModified;
    private String digestName;
    private byte[] digest;
    private int size;
    private ConstantPool constant_pool;
    private Method method;

    static ClassWriter instance(Context context) {
        ClassWriter instance = context.get(ClassWriter.class);
        if (instance == null) {
            instance = new ClassWriter(context);
        }
        return instance;
    }

    protected ClassWriter(Context context) {
        super(context);
        context.put(ClassWriter.class, this);
        this.options = Options.instance(context);
        this.attrWriter = AttributeWriter.instance(context);
        this.codeWriter = CodeWriter.instance(context);
        this.constantWriter = ConstantWriter.instance(context);
    }

    void setDigest(String name, byte[] digest) {
        this.digestName = name;
        this.digest = digest;
    }

    void setFile(URI uri) {
        this.uri = uri;
    }

    void setFileSize(int size) {
        this.size = size;
    }

    void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    protected ClassFile getClassFile() {
        return this.classFile;
    }

    protected void setClassFile(ClassFile cf) {
        this.classFile = cf;
        this.constant_pool = this.classFile.constant_pool;
    }

    protected Method getMethod() {
        return this.method;
    }

    protected void setMethod(Method m) {
        this.method = m;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(ClassFile cf) {
        AccessFlags flags;
        block41: {
            block40: {
                Attribute sfa;
                this.setClassFile(cf);
                if (this.options.sysInfo || this.options.verbose) {
                    if (this.uri != null) {
                        if (this.uri.getScheme().equals("file")) {
                            this.println("Classfile " + this.uri.getPath());
                        } else {
                            this.println("Classfile " + this.uri);
                        }
                    }
                    this.indent(1);
                    if (this.lastModified != -1L) {
                        Date lm = new Date(this.lastModified);
                        DateFormat df = DateFormat.getDateInstance();
                        if (this.size > 0) {
                            this.println("Last modified " + df.format(lm) + "; size " + this.size + " bytes");
                        } else {
                            this.println("Last modified " + df.format(lm));
                        }
                    } else if (this.size > 0) {
                        this.println("Size " + this.size + " bytes");
                    }
                    if (this.digestName != null && this.digest != null) {
                        StringBuilder sb = new StringBuilder();
                        for (Object b : (DateFormat)this.digest) {
                            sb.append(String.format("%02x", (byte)b));
                        }
                        this.println(this.digestName + " checksum " + sb);
                    }
                }
                if ((sfa = cf.getAttribute("SourceFile")) instanceof SourceFile_attribute) {
                    this.println("Compiled from \"" + this.getSourceFile((SourceFile_attribute)sfa) + "\"");
                }
                if (this.options.sysInfo || this.options.verbose) {
                    this.indent(-1);
                }
                flags = cf.access_flags;
                this.writeModifiers(flags.getClassModifiers());
                if (!this.classFile.access_flags.is(32768)) break block40;
                Attribute attr = this.classFile.attributes.get("Module");
                if (attr instanceof Module_attribute) {
                    String name;
                    Module_attribute modAttr = (Module_attribute)attr;
                    try {
                        name = this.constant_pool.get(modAttr.module_name).getTag() == 19 ? ClassWriter.getJavaName(this.constant_pool.getModuleInfo(modAttr.module_name).getName()) : ClassWriter.getJavaName(this.constant_pool.getUTF8Value(modAttr.module_name));
                    }
                    catch (ConstantPoolException e) {
                        name = this.report(e);
                    }
                    if ((modAttr.module_flags & 0x20) != 0) {
                        this.print("open ");
                    }
                    this.print("module ");
                    this.print(name);
                    if (modAttr.module_version_index != 0) {
                        this.print("@");
                        this.print(this.getUTF8Value(modAttr.module_version_index));
                    }
                    break block41;
                } else {
                    this.print("class ");
                    this.print(this.getJavaName(this.classFile));
                }
                break block41;
            }
            if (this.classFile.isClass()) {
                this.print("class ");
            } else if (this.classFile.isInterface()) {
                this.print("interface ");
            }
            this.print(this.getJavaName(this.classFile));
        }
        Signature_attribute sigAttr = this.getSignature(cf.attributes);
        if (sigAttr != null) {
            try {
                Type t = sigAttr.getParsedSignature().getType(this.constant_pool);
                JavaTypePrinter p = new JavaTypePrinter(this.classFile.isInterface());
                if (t instanceof Type.ClassSigType) {
                    this.print(p.print(t));
                } else if (this.options.verbose || !t.isObject()) {
                    this.print(" extends ");
                    this.print(p.print(t));
                }
            }
            catch (ConstantPoolException e) {
                this.print(this.report(e));
            }
            catch (IllegalStateException e) {
                this.report("Invalid value for Signature attribute: " + e.getMessage());
            }
        } else {
            String sn;
            if (this.classFile.isClass() && this.classFile.super_class != 0 && !(sn = this.getJavaSuperclassName(cf)).equals("java.lang.Object")) {
                this.print(" extends ");
                this.print(sn);
            }
            for (int i = 0; i < this.classFile.interfaces.length; ++i) {
                this.print(i == 0 ? (this.classFile.isClass() ? " implements " : " extends ") : ",");
                this.print(this.getJavaInterfaceName(this.classFile, i));
            }
        }
        if (this.options.verbose) {
            this.println();
            this.indent(1);
            this.println("minor version: " + cf.minor_version);
            this.println("major version: " + cf.major_version);
            this.writeList(String.format("flags: (0x%04x) ", flags.flags), flags.getClassFlags(), "\n");
            this.print("this_class: #" + cf.this_class);
            if (cf.this_class != 0) {
                this.tab();
                this.print("// " + this.constantWriter.stringValue(cf.this_class));
            }
            this.println();
            this.print("super_class: #" + cf.super_class);
            if (cf.super_class != 0) {
                this.tab();
                this.print("// " + this.constantWriter.stringValue(cf.super_class));
            }
            this.println();
            this.print("interfaces: " + cf.interfaces.length);
            this.print(", fields: " + cf.fields.length);
            this.print(", methods: " + cf.methods.length);
            this.println(", attributes: " + cf.attributes.attrs.length);
            this.indent(-1);
            this.constantWriter.writeConstantPool();
        } else {
            this.print(" ");
        }
        this.println("{");
        this.indent(1);
        if (flags.is(32768) && !this.options.verbose) {
            this.writeDirectives();
        }
        this.writeFields();
        this.writeMethods();
        this.indent(-1);
        this.println("}");
        if (this.options.verbose) {
            this.attrWriter.write((Object)cf, cf.attributes, this.constant_pool);
        }
    }

    protected void writeFields() {
        for (Field f : this.classFile.fields) {
            this.writeField(f);
        }
    }

    protected void writeField(Field f) {
        Attribute a;
        if (!this.options.checkAccess(f.access_flags)) {
            return;
        }
        AccessFlags flags = f.access_flags;
        this.writeModifiers(flags.getFieldModifiers());
        Signature_attribute sigAttr = this.getSignature(f.attributes);
        if (sigAttr == null) {
            this.print(this.getJavaFieldType(f.descriptor));
        } else {
            try {
                Type t = sigAttr.getParsedSignature().getType(this.constant_pool);
                this.print(ClassWriter.getJavaName(t.toString()));
            }
            catch (ConstantPoolException e) {
                this.print(this.getJavaFieldType(f.descriptor));
            }
        }
        this.print(" ");
        this.print(this.getFieldName(f));
        if (this.options.showConstants && (a = f.attributes.get("ConstantValue")) instanceof ConstantValue_attribute) {
            this.print(" = ");
            ConstantValue_attribute cv = (ConstantValue_attribute)a;
            this.print(this.getConstantValue(f.descriptor, cv.constantvalue_index));
        }
        this.print(";");
        this.println();
        this.indent(1);
        boolean showBlank = false;
        if (this.options.showDescriptors) {
            this.println("descriptor: " + this.getValue(f.descriptor));
        }
        if (this.options.verbose) {
            this.writeList(String.format("flags: (0x%04x) ", flags.flags), flags.getFieldFlags(), "\n");
        }
        if (this.options.showAllAttrs) {
            for (Attribute attr : f.attributes) {
                this.attrWriter.write((Object)f, attr, this.constant_pool);
            }
            showBlank = true;
        }
        this.indent(-1);
        if (showBlank || this.options.showDisassembled || this.options.showLineAndLocalVariableTables) {
            this.println();
        }
    }

    protected void writeMethods() {
        for (Method m : this.classFile.methods) {
            this.writeMethod(m);
        }
        this.setPendingNewline(false);
    }

    protected void writeMethod(Method m) {
        List<? extends Type> methodExceptions;
        Type.MethodType methodType;
        Descriptor d;
        if (!this.options.checkAccess(m.access_flags)) {
            return;
        }
        this.method = m;
        AccessFlags flags = m.access_flags;
        Signature_attribute sigAttr = this.getSignature(m.attributes);
        if (sigAttr == null) {
            d = m.descriptor;
            methodType = null;
            methodExceptions = null;
        } else {
            Signature methodSig = sigAttr.getParsedSignature();
            d = methodSig;
            try {
                methodType = (Type.MethodType)methodSig.getType(this.constant_pool);
                methodExceptions = methodType.throwsTypes;
                if (methodExceptions != null && methodExceptions.isEmpty()) {
                    methodExceptions = null;
                }
            }
            catch (ConstantPoolException | IllegalStateException e) {
                methodType = null;
                methodExceptions = null;
            }
        }
        Set<String> modifiers = flags.getMethodModifiers();
        String name = this.getName(m);
        if (this.classFile.isInterface() && !flags.is(1024) && !name.equals("<clinit>") && (this.classFile.major_version > 52 || this.classFile.major_version == 52 && this.classFile.minor_version >= 0) && !flags.is(10)) {
            modifiers.add("default");
        }
        this.writeModifiers(modifiers);
        if (methodType != null) {
            this.print(new JavaTypePrinter(false).printTypeArgs(methodType.typeParamTypes));
        }
        switch (name) {
            case "<init>": {
                this.print(this.getJavaName(this.classFile));
                this.print(this.getJavaParameterTypes(d, flags));
                break;
            }
            case "<clinit>": {
                this.print("{}");
                break;
            }
            default: {
                this.print(this.getJavaReturnType(d));
                this.print(" ");
                this.print(name);
                this.print(this.getJavaParameterTypes(d, flags));
            }
        }
        Attribute e_attr = m.attributes.get("Exceptions");
        if (e_attr != null) {
            if (e_attr instanceof Exceptions_attribute) {
                Exceptions_attribute exceptions = (Exceptions_attribute)e_attr;
                this.print(" throws ");
                if (methodExceptions != null) {
                    this.writeList("", methodExceptions, "");
                } else {
                    for (int i = 0; i < exceptions.number_of_exceptions; ++i) {
                        if (i > 0) {
                            this.print(", ");
                        }
                        this.print(this.getJavaException(exceptions, i));
                    }
                }
            } else {
                this.report("Unexpected or invalid value for Exceptions attribute");
            }
        }
        this.println(";");
        this.indent(1);
        if (this.options.showDescriptors) {
            this.println("descriptor: " + this.getValue(m.descriptor));
        }
        if (this.options.verbose) {
            this.writeList(String.format("flags: (0x%04x) ", flags.flags), flags.getMethodFlags(), "\n");
        }
        Code_attribute code = null;
        Attribute c_attr = m.attributes.get("Code");
        if (c_attr != null) {
            if (c_attr instanceof Code_attribute) {
                code = (Code_attribute)c_attr;
            } else {
                this.report("Unexpected or invalid value for Code attribute");
            }
        }
        if (this.options.showAllAttrs) {
            Attribute[] attrs;
            for (Attribute attr : attrs = m.attributes.attrs) {
                this.attrWriter.write((Object)m, attr, this.constant_pool);
            }
        } else if (code != null) {
            if (this.options.showDisassembled) {
                this.println("Code:");
                this.codeWriter.writeInstrs(code);
                this.codeWriter.writeExceptionTable(code);
            }
            if (this.options.showLineAndLocalVariableTables) {
                this.attrWriter.write((Object)code, code.attributes.get("LineNumberTable"), this.constant_pool);
                this.attrWriter.write((Object)code, code.attributes.get("LocalVariableTable"), this.constant_pool);
            }
        }
        this.indent(-1);
        this.setPendingNewline(this.options.showDisassembled || this.options.showAllAttrs || this.options.showDescriptors || this.options.showLineAndLocalVariableTables || this.options.verbose);
    }

    void writeModifiers(Collection<String> items) {
        for (String item : items) {
            this.print((Object)item);
            this.print(" ");
        }
    }

    void writeDirectives() {
        String mname;
        int i;
        int n;
        int n2;
        int[] nArray;
        String pname;
        Attribute attr = this.classFile.attributes.get("Module");
        if (!(attr instanceof Module_attribute)) {
            return;
        }
        Module_attribute m = (Module_attribute)attr;
        for (Module_attribute.RequiresEntry requiresEntry : m.requires) {
            String mname2;
            this.print("requires");
            if ((requiresEntry.requires_flags & 0x40) != 0) {
                this.print(" static");
            }
            if ((requiresEntry.requires_flags & 0x20) != 0) {
                this.print(" transitive");
            }
            this.print(" ");
            try {
                String mname22 = this.getModuleName(requiresEntry.requires_index);
            }
            catch (ConstantPoolException e) {
                mname2 = this.report(e);
            }
            this.print(mname2);
            this.println(";");
        }
        for (Module_attribute.ExportsEntry exportsEntry : m.exports) {
            this.print("exports");
            this.print(" ");
            try {
                pname = this.getPackageName(exportsEntry.exports_index).replace('/', '.');
            }
            catch (ConstantPoolException e) {
                pname = this.report(e);
            }
            this.print(pname);
            boolean first = true;
            nArray = exportsEntry.exports_to_index;
            n2 = nArray.length;
            for (n = 0; n < n2; ++n) {
                i = nArray[n];
                try {
                    mname = this.getModuleName(i);
                }
                catch (ConstantPoolException e) {
                    mname = this.report(e);
                }
                if (first) {
                    this.println(" to");
                    this.indent(1);
                    first = false;
                } else {
                    this.println(",");
                }
                this.print(mname);
            }
            this.println(";");
            if (first) continue;
            this.indent(-1);
        }
        for (Module_attribute.OpensEntry opensEntry : m.opens) {
            this.print("opens");
            this.print(" ");
            try {
                pname = this.getPackageName(opensEntry.opens_index).replace('/', '.');
            }
            catch (ConstantPoolException e) {
                pname = this.report(e);
            }
            this.print(pname);
            boolean first = true;
            nArray = opensEntry.opens_to_index;
            n2 = nArray.length;
            for (n = 0; n < n2; ++n) {
                i = nArray[n];
                try {
                    mname = this.getModuleName(i);
                }
                catch (ConstantPoolException e) {
                    mname = this.report(e);
                }
                if (first) {
                    this.println(" to");
                    this.indent(1);
                    first = false;
                } else {
                    this.println(",");
                }
                this.print(mname);
            }
            this.println(";");
            if (first) continue;
            this.indent(-1);
        }
        for (int n3 : m.uses_index) {
            this.print("uses ");
            this.print(this.getClassName(n3).replace('/', '.'));
            this.println(";");
        }
        for (Module_attribute.ProvidesEntry providesEntry : m.provides) {
            this.print("provides  ");
            this.print(this.getClassName(providesEntry.provides_index).replace('/', '.'));
            boolean first = true;
            for (int i2 : providesEntry.with_index) {
                if (first) {
                    this.println(" with");
                    this.indent(1);
                    first = false;
                } else {
                    this.println(",");
                }
                this.print(this.getClassName(i2).replace('/', '.'));
            }
            this.println(";");
            if (first) continue;
            this.indent(-1);
        }
    }

    String getModuleName(int index) throws ConstantPoolException {
        if (this.constant_pool.get(index).getTag() == 19) {
            return this.constant_pool.getModuleInfo(index).getName();
        }
        return this.constant_pool.getUTF8Value(index);
    }

    String getPackageName(int index) throws ConstantPoolException {
        if (this.constant_pool.get(index).getTag() == 20) {
            return this.constant_pool.getPackageInfo(index).getName();
        }
        return this.constant_pool.getUTF8Value(index);
    }

    String getUTF8Value(int index) {
        try {
            return this.classFile.constant_pool.getUTF8Value(index);
        }
        catch (ConstantPoolException e) {
            return this.report(e);
        }
    }

    String getClassName(int index) {
        try {
            return this.classFile.constant_pool.getClassInfo(index).getName();
        }
        catch (ConstantPoolException e) {
            return this.report(e);
        }
    }

    void writeList(String prefix, Collection<?> items, String suffix) {
        this.print(prefix);
        String sep = "";
        for (Object item : items) {
            this.print(sep);
            this.print(item);
            sep = ", ";
        }
        this.print(suffix);
    }

    void writeListIfNotEmpty(String prefix, List<?> items, String suffix) {
        if (items != null && items.size() > 0) {
            this.writeList(prefix, items, suffix);
        }
    }

    Signature_attribute getSignature(Attributes attributes) {
        return (Signature_attribute)attributes.get("Signature");
    }

    String adjustVarargs(AccessFlags flags, String params) {
        int i;
        if (flags.is(128) && (i = params.lastIndexOf("[]")) > 0) {
            return params.substring(0, i) + "..." + params.substring(i + 2);
        }
        return params;
    }

    String getJavaName(ClassFile cf) {
        try {
            return ClassWriter.getJavaName(cf.getName());
        }
        catch (ConstantPoolException e) {
            return this.report(e);
        }
    }

    String getJavaSuperclassName(ClassFile cf) {
        try {
            return ClassWriter.getJavaName(cf.getSuperclassName());
        }
        catch (ConstantPoolException e) {
            return this.report(e);
        }
    }

    String getJavaInterfaceName(ClassFile cf, int index) {
        try {
            return ClassWriter.getJavaName(cf.getInterfaceName(index));
        }
        catch (ConstantPoolException e) {
            return this.report(e);
        }
    }

    String getJavaFieldType(Descriptor d) {
        try {
            return ClassWriter.getJavaName(d.getFieldType(this.constant_pool));
        }
        catch (ConstantPoolException e) {
            return this.report(e);
        }
        catch (Descriptor.InvalidDescriptor e) {
            return this.report(e);
        }
    }

    String getJavaReturnType(Descriptor d) {
        try {
            return ClassWriter.getJavaName(d.getReturnType(this.constant_pool));
        }
        catch (ConstantPoolException e) {
            return this.report(e);
        }
        catch (Descriptor.InvalidDescriptor e) {
            return this.report(e);
        }
    }

    String getJavaParameterTypes(Descriptor d, AccessFlags flags) {
        try {
            return ClassWriter.getJavaName(this.adjustVarargs(flags, d.getParameterTypes(this.constant_pool)));
        }
        catch (ConstantPoolException e) {
            return this.report(e);
        }
        catch (Descriptor.InvalidDescriptor e) {
            return this.report(e);
        }
    }

    String getJavaException(Exceptions_attribute attr, int index) {
        try {
            return ClassWriter.getJavaName(attr.getException(index, this.constant_pool));
        }
        catch (ConstantPoolException e) {
            return this.report(e);
        }
    }

    String getValue(Descriptor d) {
        try {
            return d.getValue(this.constant_pool);
        }
        catch (ConstantPoolException e) {
            return this.report(e);
        }
    }

    String getFieldName(Field f) {
        try {
            return f.getName(this.constant_pool);
        }
        catch (ConstantPoolException e) {
            return this.report(e);
        }
    }

    String getName(Method m) {
        try {
            return m.getName(this.constant_pool);
        }
        catch (ConstantPoolException e) {
            return this.report(e);
        }
    }

    static String getJavaName(String name) {
        return name.replace('/', '.');
    }

    String getSourceFile(SourceFile_attribute attr) {
        try {
            return attr.getSourceFile(this.constant_pool);
        }
        catch (ConstantPoolException e) {
            return this.report(e);
        }
    }

    String getConstantValue(Descriptor d, int index) {
        try {
            ConstantPool.CPInfo cpInfo = this.constant_pool.get(index);
            switch (cpInfo.getTag()) {
                case 3: {
                    String t;
                    ConstantPool.CONSTANT_Integer_info info = (ConstantPool.CONSTANT_Integer_info)cpInfo;
                    switch (t = d.getValue(this.constant_pool)) {
                        case "C": {
                            return this.getConstantCharValue((char)info.value);
                        }
                        case "Z": {
                            return String.valueOf(info.value == 1);
                        }
                    }
                    return String.valueOf(info.value);
                }
                case 8: {
                    ConstantPool.CONSTANT_String_info info = (ConstantPool.CONSTANT_String_info)cpInfo;
                    return this.getConstantStringValue(info.getString());
                }
            }
            return this.constantWriter.stringValue(cpInfo);
        }
        catch (ConstantPoolException e) {
            return "#" + index;
        }
    }

    private String getConstantCharValue(char c) {
        StringBuilder sb = new StringBuilder();
        sb.append('\'');
        sb.append(this.esc(c, '\''));
        sb.append('\'');
        return sb.toString();
    }

    private String getConstantStringValue(String s) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        for (int i = 0; i < s.length(); ++i) {
            sb.append(this.esc(s.charAt(i), '\"'));
        }
        sb.append("\"");
        return sb.toString();
    }

    private String esc(char c, char quote) {
        if (' ' <= c && c <= '~' && c != quote && c != '\\') {
            return String.valueOf(c);
        }
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\n': {
                return "\\n";
            }
            case '\t': {
                return "\\t";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\\': {
                return "\\\\";
            }
            case '\'': {
                return "\\'";
            }
            case '\"': {
                return "\\\"";
            }
        }
        return String.format("\\u%04x", c);
    }

    class JavaTypePrinter
    implements Type.Visitor<StringBuilder, StringBuilder> {
        boolean isInterface;

        JavaTypePrinter(boolean isInterface) {
            this.isInterface = isInterface;
        }

        String print(Type t) {
            return t.accept(this, new StringBuilder()).toString();
        }

        String printTypeArgs(List<? extends Type.TypeParamType> typeParamTypes) {
            StringBuilder builder = new StringBuilder();
            this.appendIfNotEmpty(builder, "<", typeParamTypes, "> ");
            return builder.toString();
        }

        @Override
        public StringBuilder visitSimpleType(Type.SimpleType type, StringBuilder sb) {
            sb.append(ClassWriter.getJavaName(type.name));
            return sb;
        }

        @Override
        public StringBuilder visitArrayType(Type.ArrayType type, StringBuilder sb) {
            this.append(sb, type.elemType);
            sb.append("[]");
            return sb;
        }

        @Override
        public StringBuilder visitMethodType(Type.MethodType type, StringBuilder sb) {
            this.appendIfNotEmpty(sb, "<", type.typeParamTypes, "> ");
            this.append(sb, type.returnType);
            this.append(sb, " (", type.paramTypes, ")");
            this.appendIfNotEmpty(sb, " throws ", type.throwsTypes, "");
            return sb;
        }

        @Override
        public StringBuilder visitClassSigType(Type.ClassSigType type, StringBuilder sb) {
            this.appendIfNotEmpty(sb, "<", type.typeParamTypes, ">");
            if (this.isInterface) {
                this.appendIfNotEmpty(sb, " extends ", type.superinterfaceTypes, "");
            } else {
                if (type.superclassType != null && (((ClassWriter)ClassWriter.this).options.verbose || !type.superclassType.isObject())) {
                    sb.append(" extends ");
                    this.append(sb, type.superclassType);
                }
                this.appendIfNotEmpty(sb, " implements ", type.superinterfaceTypes, "");
            }
            return sb;
        }

        @Override
        public StringBuilder visitClassType(Type.ClassType type, StringBuilder sb) {
            if (type.outerType != null) {
                this.append(sb, type.outerType);
                sb.append(".");
            }
            sb.append(ClassWriter.getJavaName(type.name));
            this.appendIfNotEmpty(sb, "<", type.typeArgs, ">");
            return sb;
        }

        @Override
        public StringBuilder visitTypeParamType(Type.TypeParamType type, StringBuilder sb) {
            sb.append(type.name);
            String sep = " extends ";
            if (type.classBound != null && (((ClassWriter)ClassWriter.this).options.verbose || !type.classBound.isObject())) {
                sb.append(sep);
                this.append(sb, type.classBound);
                sep = " & ";
            }
            if (type.interfaceBounds != null) {
                for (Type bound : type.interfaceBounds) {
                    sb.append(sep);
                    this.append(sb, bound);
                    sep = " & ";
                }
            }
            return sb;
        }

        @Override
        public StringBuilder visitWildcardType(Type.WildcardType type, StringBuilder sb) {
            switch (type.kind) {
                case UNBOUNDED: {
                    sb.append("?");
                    break;
                }
                case EXTENDS: {
                    sb.append("? extends ");
                    this.append(sb, type.boundType);
                    break;
                }
                case SUPER: {
                    sb.append("? super ");
                    this.append(sb, type.boundType);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return sb;
        }

        private void append(StringBuilder sb, Type t) {
            t.accept(this, sb);
        }

        private void append(StringBuilder sb, String prefix, List<? extends Type> list, String suffix) {
            sb.append(prefix);
            String sep = "";
            for (Type type : list) {
                sb.append(sep);
                this.append(sb, type);
                sep = ", ";
            }
            sb.append(suffix);
        }

        private void appendIfNotEmpty(StringBuilder sb, String prefix, List<? extends Type> list, String suffix) {
            if (!this.isEmpty(list)) {
                this.append(sb, prefix, list, suffix);
            }
        }

        private boolean isEmpty(List<? extends Type> list) {
            return list == null || list.isEmpty();
        }
    }
}

