/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl.critic.impl;

import ca.sqlpower.architect.ArchitectUtils;
import ca.sqlpower.architect.ddl.critic.CriticAndSettings;
import ca.sqlpower.architect.ddl.critic.CriticFix;
import ca.sqlpower.architect.ddl.critic.Criticism;
import ca.sqlpower.architect.ddl.critic.impl.Messages;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLTable;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class DuplicateNameCritic
extends CriticAndSettings {
    private Multimap<String, SQLObject> topLevelPhysicalNameMap = ArrayListMultimap.create();
    private Multimap<SQLTable, SQLColumn> columnPhysicalNameMap = ArrayListMultimap.create();

    public DuplicateNameCritic() {
        super(CriticAndSettings.StarterPlatformTypes.GENERIC.getName(), Messages.getString("DuplicateNameCritic.name"));
    }

    @Override
    public void start() {
        super.start();
        this.topLevelPhysicalNameMap.clear();
        this.columnPhysicalNameMap.clear();
    }

    @Override
    public void end() {
        super.end();
        this.topLevelPhysicalNameMap.clear();
        this.columnPhysicalNameMap.clear();
    }

    @Override
    public List<Criticism> criticize(Object subject) {
        String newPhysicalName;
        if (!(subject instanceof SQLObject)) {
            return Collections.emptyList();
        }
        ArrayList<Criticism> criticisms = new ArrayList<Criticism>();
        if (subject instanceof SQLColumn) {
            final SQLColumn col = (SQLColumn)subject;
            SQLTable parent = col.getParent();
            if (col.getPhysicalName() == null) {
                return criticisms;
            }
            int count = 0;
            for (SQLColumn otherCol : this.columnPhysicalNameMap.get((Object)parent)) {
                if (!col.getPhysicalName().equals(otherCol.getPhysicalName())) continue;
                ++count;
            }
            if (count > 0) {
                newPhysicalName = col.getPhysicalName() + "_" + count;
                criticisms.add(new Criticism(subject, "Duplicate physical name \"" + col.getPhysicalName() + "\"", this, new CriticFix("Replace physical name " + col.getPhysicalName() + " with " + newPhysicalName, CriticFix.FixType.QUICK_FIX){

                    @Override
                    public void apply() {
                        col.setPhysicalName(newPhysicalName);
                    }
                }));
            }
            this.columnPhysicalNameMap.put((Object)parent, (Object)col);
        }
        if (subject instanceof SQLTable || subject instanceof SQLRelationship || subject instanceof SQLIndex || subject instanceof SQLColumn) {
            Collection sameNameObjects;
            final SQLObject obj = (SQLObject)subject;
            String physicalName = obj.getPhysicalName();
            if (obj instanceof SQLColumn) {
                physicalName = ((SQLColumn)obj).getAutoIncrementSequenceName();
            }
            if (!(sameNameObjects = this.topLevelPhysicalNameMap.get((Object)physicalName)).isEmpty()) {
                newPhysicalName = physicalName + "_" + sameNameObjects.size();
                SQLObject duplicate = (SQLObject)sameNameObjects.iterator().next();
                criticisms.add(new Criticism(subject, "Duplicate physical name \"" + physicalName + "\". There is a " + ArchitectUtils.convertClassToString(duplicate.getClass()) + " in " + duplicate.getParent().getName() + " with this name already.", this, new CriticFix("Replace physical name " + obj.getPhysicalName() + " with " + newPhysicalName, CriticFix.FixType.QUICK_FIX){

                    @Override
                    public void apply() {
                        if (obj instanceof SQLColumn) {
                            ((SQLColumn)obj).setAutoIncrementSequenceName(newPhysicalName);
                        } else {
                            obj.setPhysicalName(newPhysicalName);
                        }
                    }
                }));
            }
            this.topLevelPhysicalNameMap.put((Object)physicalName, (Object)obj);
        }
        return criticisms;
    }
}

