/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.awt.StatusDisplayer;

final class StatusLine
extends JLabel
implements ChangeListener,
Runnable {
    private static int SURVIVING_TIME = Integer.getInteger("org.openide.awt.StatusDisplayer.DISPLAY_TIME", 5000);
    private StatusDisplayer d = StatusDisplayer.getDefault();
    Object clearing;

    public void addNotify() {
        super.addNotify();
        this.run();
        this.d.addChangeListener((ChangeListener)this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.d.removeChangeListener((ChangeListener)this);
    }

    public void updateUI() {
        super.updateUI();
        Font font = UIManager.getFont("controlFont");
        if (font == null) {
            font = UIManager.getFont("Tree.font");
        }
        if (font != null) {
            this.setFont(font);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeLater(this);
        }
    }

    public void run() {
        String string = this.d.getStatusText();
        this.setForeground(UIManager.getColor("Label.foreground"));
        this.setText(string);
        if (SURVIVING_TIME != 0) {
            Object object;
            this.clearing = object = new Object();
            if (!"".equals(string)) {
                new Updater(object).schedule();
            }
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, super.getPreferredSize().height);
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, super.getMinimumSize().height);
    }

    private class Updater
    implements ActionListener {
        private Object token;
        private long startTime;
        private Timer controller;

        public Updater(Object object) {
            this.token = object;
        }

        public void schedule() {
            this.controller = new Timer(SURVIVING_TIME, this);
            this.controller.setDelay(100);
            this.controller.start();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (StatusLine.this.clearing == this.token) {
                long l = System.currentTimeMillis();
                if (this.startTime != 0L) {
                    Color color = UIManager.getColor("Label.foreground");
                    if (color != null) {
                        int n = 256 * (int)(l - this.startTime) / 2000;
                        StatusLine.this.setForeground(new Color(color.getRed(), color.getGreen(), color.getBlue(), 255 - Math.min(255, n)));
                    }
                } else {
                    this.startTime = l;
                }
                if (l > this.startTime + 2000L) {
                    this.controller.stop();
                }
            } else {
                this.controller.stop();
            }
        }
    }
}

