/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.laf.flatlaf.ui;

import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.laf.flatlaf.HiDPIUtils;
import org.netbeans.swing.laf.flatlaf.ui.FlatEditorTabCellRenderer;
import org.netbeans.swing.laf.flatlaf.ui.FlatTabControlIcon;
import org.netbeans.swing.laf.flatlaf.ui.Utils;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.BasicScrollingTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.TabCellRenderer;

public class FlatEditorTabDisplayerUI
extends BasicScrollingTabDisplayerUI {
    private static final int ICON_X_PAD = 4;
    private final Color background = UIManager.getColor("EditorTab.background");
    private final Color activeBackground = Utils.getUIColor("EditorTab.activeBackground", this.background);
    private final Color contentBorderColor = UIManager.getColor("TabbedContainer.editor.contentBorderColor");
    private final boolean unscaledBorders = Utils.getUIBoolean("EditorTab.unscaledBorders", false);
    private final Insets tabInsets = UIScale.scale((Insets)UIManager.getInsets("EditorTab.tabInsets"));

    public FlatEditorTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatEditorTabDisplayerUI((TabDisplayer)jComponent);
    }

    protected TabCellRenderer createDefaultRenderer() {
        return new FlatEditorTabCellRenderer();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Graphics2D graphics2D = BasicScrollingTabDisplayerUI.getOffscreenGraphics((JComponent)jComponent);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.displayer.getFont());
        Insets insets = this.getTabAreaInsets();
        int n = Math.max(fontMetrics.getHeight(), 16) + insets.top + insets.bottom + this.tabInsets.top + this.tabInsets.bottom;
        return new Dimension(this.displayer.getWidth(), n);
    }

    public TabCellRenderer getTabCellRenderer(int n) {
        TabCellRenderer tabCellRenderer = super.getTabCellRenderer(n);
        if (tabCellRenderer instanceof FlatEditorTabCellRenderer) {
            FlatEditorTabCellRenderer flatEditorTabCellRenderer = (FlatEditorTabCellRenderer)tabCellRenderer;
            int n2 = this.displayer.getModel().size();
            flatEditorTabCellRenderer.firstTab = n == 0;
            flatEditorTabCellRenderer.lastTab = n == n2 - 1;
            flatEditorTabCellRenderer.nextTabSelected = n + 1 < n2 && (this.tabState.getState(n + 1) & 0x10) != 0;
        }
        return tabCellRenderer;
    }

    public Insets getTabAreaInsets() {
        return new Insets(0, 0, 0, this.getControlButtons().getPreferredSize().width + 4);
    }

    protected Rectangle getControlButtonsRectangle(Container container) {
        Component component = this.getControlButtons();
        return new Rectangle(container.getWidth() - component.getWidth() - 4, (container.getHeight() - component.getHeight()) / 2, component.getWidth(), component.getHeight());
    }

    public void paintBackground(Graphics graphics) {
        int n = this.displayer.getWidth();
        int n2 = this.displayer.getHeight();
        HiDPIUtils.paintAtScale1x(graphics, 0, 0, n, n2, this::paintBackgroundAtScale1x);
    }

    private void paintBackgroundAtScale1x(Graphics2D graphics2D, int n, int n2, double d) {
        graphics2D.setColor(this.displayer.isActive() ? this.activeBackground : this.background);
        graphics2D.fillRect(0, 0, n, n2);
        int n3 = this.unscaledBorders ? 1 : HiDPIUtils.deviceBorderWidth(d, 1);
        graphics2D.setColor(this.contentBorderColor);
        graphics2D.fillRect(0, n2 - n3, n, n3);
    }

    public Icon getButtonIcon(int n, int n2) {
        Icon icon = FlatTabControlIcon.get(n, n2);
        return icon != null ? icon : super.getButtonIcon(n, n2);
    }
}

