/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.css3.CssColumnRuleColor;
import org.w3c.css.properties.css3.CssColumnRuleStyle;
import org.w3c.css.properties.css3.CssColumnRuleWidth;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssColumnRule
extends org.w3c.css.properties.css.CssColumnRule {
    public CssColumnRule() {
    }

    public CssColumnRule(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        int nb_val = expression.getCount();
        if (check && nb_val > 3) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        block11: while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            if (op != ' ') {
                throw new InvalidParamException("operator", Character.toString(op), ac);
            }
            switch (val.getType()) {
                case 3: 
                case 11: 
                case 15: {
                    if (this.rule_color != null) {
                        throw new InvalidParamException("unrecognize", ac);
                    }
                    this.rule_color = new CssColumnRuleColor(ac, expression, false);
                    continue block11;
                }
                case 5: 
                case 6: {
                    if (this.rule_width != null) {
                        throw new InvalidParamException("unrecognize", ac);
                    }
                    this.rule_width = new CssColumnRuleWidth(ac, expression, false);
                    continue block11;
                }
                case 0: {
                    CssIdent id = val.getIdent();
                    if (CssIdent.isCssWide(id)) {
                        if (nb_val > 1) {
                            throw new InvalidParamException("unrecognize", ac);
                        }
                        this.value = val;
                        expression.next();
                        continue block11;
                    }
                    if (this.rule_color == null) {
                        try {
                            this.rule_color = new CssColumnRuleColor(ac, expression, false);
                            continue block11;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.rule_width == null) {
                        try {
                            this.rule_width = new CssColumnRuleWidth(ac, expression);
                            continue block11;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.rule_style != null) break;
                    try {
                        this.rule_style = new CssColumnRuleStyle(ac, expression);
                        continue block11;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            throw new InvalidParamException("value", expression.getValue(), this.getPropertyName(), ac);
        }
        if (this.rule_color != null || this.rule_width != null || this.rule_style != null) {
            ArrayList<CssValue> v = new ArrayList<CssValue>();
            if (this.rule_width != null) {
                v.add(this.rule_width.value);
            }
            if (this.rule_style != null) {
                v.add(this.rule_style.value);
            }
            if (this.rule_color != null) {
                v.add(this.rule_color.value);
            }
            this.value = new CssValueList(v);
        }
    }

    public CssColumnRule(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    @Override
    public boolean equals(CssProperty property) {
        return false;
    }
}

