/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.result.DefaultResolvedVariantResult;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.internal.Describables;
import org.gradle.internal.component.external.model.ExternalComponentResolveMetadata;
import org.gradle.internal.component.external.model.ExternalModuleComponentGraphResolveMetadata;
import org.gradle.internal.component.external.model.ExternalModuleComponentGraphResolveState;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.model.AbstractComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveMetadata;
import org.gradle.internal.component.model.ComponentIdGenerator;
import org.gradle.internal.component.model.ConfigurationGraphResolveMetadata;
import org.gradle.internal.component.model.ConfigurationGraphResolveState;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.GraphSelectionCandidates;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleConfigurationMetadata;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.component.model.VariantArtifactResolveState;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.lazy.Lazy;

public class DefaultExternalModuleComponentGraphResolveState<G extends ExternalModuleComponentGraphResolveMetadata, A extends ExternalComponentResolveMetadata>
extends AbstractComponentGraphResolveState<G>
implements ExternalModuleComponentGraphResolveState {
    private final ComponentIdGenerator idGenerator;
    private final A legacyMetadata;
    private final ConcurrentMap<ModuleConfigurationMetadata, DefaultConfigurationGraphResolveState> variants = new ConcurrentHashMap<ModuleConfigurationMetadata, DefaultConfigurationGraphResolveState>();
    private final Lazy<List<? extends VariantGraphResolveState>> allVariantsForGraphResolution;
    private final List<ResolvedVariantResult> selectableVariantResults;

    public DefaultExternalModuleComponentGraphResolveState(long instanceId, G graphMetadata, A legacyMetadata, AttributeDesugaring attributeDesugaring, ComponentIdGenerator idGenerator) {
        super(instanceId, graphMetadata, attributeDesugaring);
        this.legacyMetadata = legacyMetadata;
        this.allVariantsForGraphResolution = Lazy.locking().of(() -> graphMetadata.getVariantsForGraphTraversal().stream().map(ModuleConfigurationMetadata.class::cast).map(variant -> this.resolveStateFor((ModuleConfigurationMetadata)variant).asVariant()).collect(Collectors.toList()));
        this.idGenerator = idGenerator;
        this.selectableVariantResults = graphMetadata.getVariantsForGraphTraversal().stream().map(ConfigurationMetadata.class::cast).flatMap(variant -> variant.getArtifactVariants().stream()).map(variant -> new DefaultResolvedVariantResult((ComponentIdentifier)this.getId(), Describables.of((Object)variant.getName()), (AttributeContainer)attributeDesugaring.desugar(variant.getAttributes().asImmutable()), this.capabilitiesFor(variant.getCapabilities()), null)).collect(Collectors.toList());
    }

    @Override
    public ModuleComponentIdentifier getId() {
        return ((ExternalModuleComponentGraphResolveMetadata)this.getMetadata()).getId();
    }

    @Deprecated
    public A getLegacyMetadata() {
        return this.legacyMetadata;
    }

    @Override
    public ComponentArtifactResolveMetadata getArtifactMetadata() {
        A legacyMetadata = this.getLegacyMetadata();
        return new ExternalArtifactResolveMetadata((ExternalComponentResolveMetadata)legacyMetadata);
    }

    @Override
    public List<ResolvedVariantResult> getAllSelectableVariantResults() {
        return this.selectableVariantResults;
    }

    @Override
    public GraphSelectionCandidates getCandidatesForGraphVariantSelection() {
        return new ExternalGraphSelectionCandidates(this);
    }

    protected ConfigurationGraphResolveState resolveStateFor(ModuleConfigurationMetadata configuration) {
        return this.variants.computeIfAbsent(configuration, c -> this.newVariantState(configuration));
    }

    private DefaultConfigurationGraphResolveState newVariantState(ModuleConfigurationMetadata configuration) {
        return new DefaultConfigurationGraphResolveState(this.idGenerator.nextVariantId(), configuration);
    }

    protected static class ExternalArtifactResolveMetadata
    implements ComponentArtifactResolveMetadata {
        private final ExternalComponentResolveMetadata metadata;

        public ExternalArtifactResolveMetadata(ExternalComponentResolveMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public ComponentIdentifier getId() {
            return this.metadata.getId();
        }

        @Override
        public ModuleVersionIdentifier getModuleVersionId() {
            return this.metadata.getModuleVersionId();
        }

        @Override
        public ModuleSources getSources() {
            return this.metadata.getSources();
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return this.metadata.getAttributes();
        }

        @Override
        public ImmutableAttributesSchema getAttributesSchema() {
            return this.metadata.getAttributesSchema();
        }
    }

    private static class ExternalGraphSelectionCandidates
    implements GraphSelectionCandidates {
        private final List<? extends VariantGraphResolveState> variants;
        private final DefaultExternalModuleComponentGraphResolveState<?, ?> component;

        public ExternalGraphSelectionCandidates(DefaultExternalModuleComponentGraphResolveState<?, ?> component) {
            this.variants = (List)((DefaultExternalModuleComponentGraphResolveState)component).allVariantsForGraphResolution.get();
            this.component = component;
        }

        @Override
        public List<? extends VariantGraphResolveState> getVariantsForAttributeMatching() {
            return this.variants;
        }

        @Override
        @Nullable
        public VariantGraphResolveState getLegacyVariant() {
            return this.doGetVariantByConfigurationName("default");
        }

        @Override
        @Nullable
        public VariantGraphResolveState getVariantByConfigurationName(String name) {
            ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateBehaviour((String)"Selecting a variant by configuration name from a non-Ivy external component.").willBecomeAnErrorInGradle9().withUpgradeGuideSection(8, "selecting_variant_by_configuration_name")).nagUser();
            return this.doGetVariantByConfigurationName(name);
        }

        @Nullable
        private VariantGraphResolveState doGetVariantByConfigurationName(String name) {
            ModuleConfigurationMetadata configuration = (ModuleConfigurationMetadata)((ExternalModuleComponentGraphResolveMetadata)this.component.getMetadata()).getConfiguration(name);
            if (configuration == null) {
                return null;
            }
            return this.component.resolveStateFor(configuration).asVariant();
        }
    }

    private static class DefaultConfigurationGraphResolveState
    implements VariantGraphResolveState,
    ConfigurationGraphResolveState {
        private final long instanceId;
        private final ModuleConfigurationMetadata configuration;
        private final DefaultConfigurationArtifactResolveState artifactResolveState;

        public DefaultConfigurationGraphResolveState(long instanceId, ModuleConfigurationMetadata configuration) {
            this.instanceId = instanceId;
            this.configuration = configuration;
            this.artifactResolveState = new DefaultConfigurationArtifactResolveState(configuration);
        }

        @Override
        public long getInstanceId() {
            return this.instanceId;
        }

        @Override
        public String getName() {
            return this.configuration.getName();
        }

        @Override
        public ImmutableAttributes getAttributes() {
            return this.configuration.getAttributes();
        }

        @Override
        public ImmutableCapabilities getCapabilities() {
            return this.configuration.getCapabilities();
        }

        @Override
        public List<? extends DependencyMetadata> getDependencies() {
            return this.configuration.getDependencies();
        }

        @Override
        public List<? extends ExcludeMetadata> getExcludes() {
            return this.configuration.getExcludes();
        }

        @Override
        public ConfigurationGraphResolveMetadata getMetadata() {
            return this.configuration;
        }

        @Override
        public VariantGraphResolveState asVariant() {
            return this;
        }

        @Override
        public VariantArtifactResolveState prepareForArtifactResolution() {
            return this.artifactResolveState;
        }
    }

    private static class DefaultConfigurationArtifactResolveState
    implements VariantArtifactResolveState {
        private final ConfigurationMetadata configuration;

        public DefaultConfigurationArtifactResolveState(ConfigurationMetadata configuration) {
            this.configuration = configuration;
        }

        @Override
        public ImmutableList<ComponentArtifactMetadata> getAdhocArtifacts(List<IvyArtifactName> dependencyArtifacts) {
            ImmutableList.Builder artifacts = ImmutableList.builderWithExpectedSize((int)dependencyArtifacts.size());
            for (IvyArtifactName dependencyArtifact : dependencyArtifacts) {
                artifacts.add((Object)this.configuration.artifact(dependencyArtifact));
            }
            return artifacts.build();
        }

        @Override
        public Set<? extends VariantResolveMetadata> getArtifactVariants() {
            return this.configuration.getArtifactVariants();
        }
    }
}

