/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.api.DelegateArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.api.PsiCallParameter;
import org.jetbrains.plugins.groovy.lang.resolve.impl.PsiCallParameterImpl;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\f\u0012\u0004\u0012\u00020\u00060\u0010j\u0002`\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R&\u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00060\u00180\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/impl/GdkArgumentMapping;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/DelegateArgumentMapping;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/PsiCallParameter;", "method", "Lcom/intellij/psi/PsiMethod;", "receiverArgument", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "context", "Lcom/intellij/psi/PsiElement;", "delegate", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/ArgumentMapping;", "<init>", "(Lcom/intellij/psi/PsiMethod;Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/plugins/groovy/lang/resolve/api/ArgumentMapping;)V", "receiverParameter", "Lcom/intellij/psi/PsiParameter;", "arguments", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "getArguments", "()Ljava/util/List;", "targetParameter", "argument", "expectedTypes", "", "Lkotlin/Pair;", "Lcom/intellij/psi/PsiType;", "getExpectedTypes", "()Ljava/lang/Iterable;", "intellij.groovy.psi"})
public final class GdkArgumentMapping
extends DelegateArgumentMapping<PsiCallParameter> {
    @NotNull
    private final Argument receiverArgument;
    @NotNull
    private final PsiElement context;
    @NotNull
    private final PsiParameter receiverParameter;
    @NotNull
    private final List<Argument> arguments;

    public GdkArgumentMapping(@NotNull PsiMethod method, @NotNull Argument receiverArgument, @NotNull PsiElement context, @NotNull ArgumentMapping<? extends PsiCallParameter> delegate) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)receiverArgument, (String)"receiverArgument");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        super(delegate);
        this.receiverArgument = receiverArgument;
        this.context = context;
        PsiParameter[] psiParameterArray = method.getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
        Object object = ArraysKt.first((Object[])psiParameterArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
        this.receiverParameter = (PsiParameter)object;
        this.arguments = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.receiverArgument), (Iterable)super.getArguments());
    }

    @Override
    @NotNull
    public List<Argument> getArguments() {
        return this.arguments;
    }

    @Override
    @Nullable
    public PsiCallParameter targetParameter(@NotNull Argument argument) {
        PsiCallParameter psiCallParameter;
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        if (Intrinsics.areEqual((Object)argument, (Object)this.receiverArgument)) {
            PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor, (String)"EMPTY");
            psiCallParameter = new PsiCallParameterImpl(this.receiverParameter, psiSubstitutor, this.context);
        } else {
            psiCallParameter = (PsiCallParameter)super.targetParameter(argument);
        }
        return psiCallParameter;
    }

    @Override
    @NotNull
    public Iterable<Pair<PsiType, Argument>> getExpectedTypes() {
        return SequencesKt.asIterable((Sequence)SequencesKt.plus((Sequence)SequencesKt.sequenceOf((Object)new Pair((Object)this.receiverParameter.getType(), (Object)this.receiverArgument)), super.getExpectedTypes()));
    }
}

