/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index;

import java.util.HashSet;
import java.util.Set;
import org.sonatype.nexus.index.ArtifactInfo;
import org.sonatype.nexus.index.ArtifactInfoFilter;
import org.sonatype.nexus.index.context.IndexingContext;

public class UniqueGAArtifactFilterPostprocessor
implements ArtifactInfoFilter {
    private static final String VERSION_LATEST = "LATEST";
    private final boolean repositoriesIgnored;
    private final Set<String> gas = new HashSet<String>();

    public UniqueGAArtifactFilterPostprocessor(boolean repositoriesIgnored) {
        this.repositoriesIgnored = repositoriesIgnored;
    }

    public boolean accepts(IndexingContext ctx, ArtifactInfo ai) {
        String key = ai.groupId + ai.artifactId + ai.packaging + ai.classifier;
        if (!this.repositoriesIgnored) {
            key = ai.repository + key;
        }
        if (this.gas.contains(key)) {
            return false;
        }
        this.gas.add(key);
        this.postprocess(ctx, ai);
        return true;
    }

    public void postprocess(IndexingContext ctx, ArtifactInfo ai) {
        ai.version = VERSION_LATEST;
        if (this.repositoriesIgnored) {
            ai.context = null;
            ai.repository = null;
        }
    }
}

