/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.ide.IdeView;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataMap;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class VcsVirtualFilesRule {
    private static final Logger LOG = Logger.getInstance(VcsVirtualFilesRule.class);

    @Nullable
    public static Iterable<VirtualFile> getData(@NotNull DataMap dataProvider) {
        JBIterable directories;
        Object[] files;
        if (dataProvider == null) {
            VcsVirtualFilesRule.$$$reportNull$$$0(0);
        }
        if ((files = (VirtualFile[])dataProvider.get(CommonDataKeys.VIRTUAL_FILE_ARRAY)) != null) {
            return JBIterable.of((Object[])files);
        }
        VirtualFile file = (VirtualFile)dataProvider.get(CommonDataKeys.VIRTUAL_FILE);
        if (file != null) {
            return JBIterable.of((Object)file);
        }
        IdeView view = (IdeView)dataProvider.get(LangDataKeys.IDE_VIEW);
        if (view != null && (directories = JBIterable.of((Object[])view.getDirectories())).isNotEmpty()) {
            if (directories.contains(null)) {
                LOG.error("Array with null provided by " + view.getClass().getName());
            }
            return directories.filterNotNull().filterMap(o -> o.getVirtualFile()).collect();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataProvider", "com/intellij/openapi/vcs/VcsVirtualFilesRule", "getData"));
    }
}

