/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.thumbnail.actions;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.intellij.images.search.ImageTagManager;
import org.intellij.images.search.TagFilter;
import org.intellij.images.thumbnail.ThumbnailView;
import org.intellij.images.thumbnail.actionSystem.ThumbnailViewActionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FilterByTagActionGroup
extends ActionGroup
implements PopupAction {
    public FilterByTagActionGroup() {
        this.setPopup(true);
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            FilterByTagActionGroup.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        ThumbnailView view = ThumbnailViewActionUtil.getVisibleThumbnailView(e);
        ImageTagManager tagManager = ImageTagManager.getInstance(project);
        e.getPresentation().setVisible(view != null && !tagManager.getAllTags().isEmpty());
        Object[] filters = view != null ? view.getTagFilters() : null;
        e.getPresentation().setText(filters == null ? CommonBundle.message((String)"action.text.all", (Object[])new Object[0]) : StringUtil.join((Object[])filters, filter -> filter.getDisplayName(), (String)","));
        e.getPresentation().setIcon(AllIcons.Duplicates.SendToTheRight);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            FilterByTagActionGroup.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                FilterByTagActionGroup.$$$reportNull$$$0(2);
            }
            return AnAction.EMPTY_ARRAY;
        }
        DefaultActionGroup group = new DefaultActionGroup();
        Project project = e.getProject();
        ThumbnailView view = ThumbnailViewActionUtil.getVisibleThumbnailView(e);
        if (view == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                FilterByTagActionGroup.$$$reportNull$$$0(3);
            }
            return AnAction.EMPTY_ARRAY;
        }
        ImageTagManager tagManager = ImageTagManager.getInstance(project);
        final List tagActions = ContainerUtil.map(tagManager.getAllTags(), tag -> new MyToggleAction(view, new TagFilter((String)tag, tagManager)));
        group.add(new AnAction(IdeBundle.messagePointer((String)"action.Anonymous.text.all", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (MyToggleAction tagAction : tagActions) {
                    tagAction.setSelected(e, false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/intellij/images/thumbnail/actions/FilterByTagActionGroup$1", "actionPerformed"));
            }
        });
        group.add((AnAction)Separator.getInstance());
        group.addAll((Collection)tagActions);
        AnAction[] anActionArray = group.getChildren(e);
        if (anActionArray == null) {
            FilterByTagActionGroup.$$$reportNull$$$0(4);
        }
        return anActionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/images/thumbnail/actions/FilterByTagActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/images/thumbnail/actions/FilterByTagActionGroup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    private static class MyToggleAction
    extends ToggleAction {
        private final ThumbnailView myView;
        private final TagFilter myFilter;

        MyToggleAction(ThumbnailView view, TagFilter filter) {
            super(filter.getDisplayName());
            this.myView = view;
            this.myFilter = filter;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Object[] filters;
            if (e == null) {
                MyToggleAction.$$$reportNull$$$0(0);
            }
            return (filters = this.myView.getTagFilters()) != null && ContainerUtil.exists((Object[])filters, f -> this.myFilter.getDisplayName().equals(f.getDisplayName()));
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MyToggleAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MyToggleAction.$$$reportNull$$$0(2);
            }
            if (state) {
                this.myFilter.setFilter(this.myView);
            } else {
                this.myFilter.clearFilter(this.myView);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/images/thumbnail/actions/FilterByTagActionGroup$MyToggleAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/images/thumbnail/actions/FilterByTagActionGroup$MyToggleAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

