/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.data.input;

import com.intellij.jupyter.core.core.api.actions.NotebookCellLinesEditHelper;
import com.intellij.jupyter.core.core.impl.actions.NotebookCellConverter;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.handlers.DataInputCodeGenerationContext;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellMetadata;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellMetadataKt;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputCellTableMetadataKt;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputPathWithVariableName;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputUtil;
import com.intellij.jupyter.core.jupyter.editor.JupyterCellLinesProvider;
import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.jupyter.core.jupyter.lang.JupyterLangData;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellSelectionModel;
import com.intellij.notebooks.visualization.NotebookCellSelectionModelProviderKt;
import com.intellij.notebooks.visualization.context.NotebookDataContext;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputConvertToCodeAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.jupyter.core"})
final class JupyterDataInputConvertToCodeAction
extends DumbAwareAction {
    private JupyterDataInputConvertToCodeAction() {
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        NotebookCellLines.Interval selectedInterval = NotebookDataContext.INSTANCE.getSelectedCellInterval(dataContext);
        if (selectedInterval == null || JupyterCellLinesProvider.Util.INSTANCE.getJupyterCellType(selectedInterval) != JupyterCellType.DATA_INPUT) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        DataContext dataContext2 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        Object object = JupyterDataContextExtensionsKt.getJupyterNotebookFile(dataContext2);
        JupyterCell cell = object != null && (object = object.getNotebook()) != null ? object.getCellOrNull(selectedInterval.getOrdinal()) : null;
        if (cell != null && JupyterDataInputCellMetadataKt.getHasFileMetadata(cell)) {
            e.getPresentation().setEnabledAndVisible(true);
            e.getPresentation().setText(JupyterBundle.message("action.JupyterConvertDataImportToCodeAction.to.code.text", new Object[0]));
            e.getPresentation().setDescription(JupyterBundle.message("action.JupyterConvertDataImportToCodeAction.to.code.description", new Object[0]));
        } else if (cell != null && JupyterDataInputCellTableMetadataKt.getHasTableMetadata(cell)) {
            e.getPresentation().setEnabledAndVisible(true);
            e.getPresentation().setText(JupyterBundle.message("action.JupyterConvertDataImportToCodeAction.to.sql.text", new Object[0]));
            e.getPresentation().setDescription(JupyterBundle.message("action.JupyterConvertDataImportToCodeAction.to.sql.description", new Object[0]));
        } else {
            e.getPresentation().setEnabledAndVisible(false);
            e.getPresentation().setText(JupyterBundle.message("action.JupyterConvertDataImportToCodeAction.to.code.text", new Object[0]));
            e.getPresentation().setDescription(JupyterBundle.message("action.JupyterConvertDataImportToCodeAction.to.code.description", new Object[0]));
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        NotebookCellLines.Interval interval = NotebookDataContext.INSTANCE.getSelectedCellInterval(dataContext);
        if (interval == null) {
            return;
        }
        NotebookCellLines.Interval interval2 = interval;
        DataContext dataContext2 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterDataContextExtensionsKt.getJupyterNotebookFile(dataContext2);
        if (backedNotebookVirtualFile == null) {
            return;
        }
        BackedNotebookVirtualFile notebookFile = backedNotebookVirtualFile;
        JupyterCell cell = notebookFile.getNotebook().getCell(interval2.getOrdinal());
        if (JupyterDataInputCellMetadataKt.getHasFileMetadata(cell)) {
            JupyterDataInputCellMetadata jupyterDataInputCellMetadata = JupyterDataInputCellMetadataKt.getDataInputMetadata(cell);
            if (jupyterDataInputCellMetadata == null) {
                return;
            }
            JupyterDataInputCellMetadata metadata = jupyterDataInputCellMetadata;
            DataContext dataContext3 = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext3, (String)"getDataContext(...)");
            EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor(dataContext3);
            if (editorImpl == null) {
                return;
            }
            EditorImpl editor = editorImpl;
            Project project = editor.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            Path path = notebookFile.getFile().toNioPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
            Path path2 = metadata.getFilePath(path);
            if (path2 == null) {
                return;
            }
            Path path3 = path2;
            String generatedCell = JupyterDataInputUtil.INSTANCE.generateCell(notebookFile, project2, new JupyterDataInputPathWithVariableName(path3, metadata.getVariableName()), DataInputCodeGenerationContext.FOR_CONVERSION);
            Object object = NotebookCellLinesEditHelper.Companion.getOrNull((Editor)editor);
            if (object == null || (object = NotebookCellLinesEditHelper.makeCell$default((NotebookCellLinesEditHelper)object, generatedCell, NotebookCellLines.CellType.CODE, null, 4, null)) == null) {
                return;
            }
            Object cellText = object;
            WriteCommandAction.writeCommandAction((Project)project2).withName(e.getPresentation().getText()).run(() -> JupyterDataInputConvertToCodeAction.actionPerformed$lambda$0(editor, (String)cellText, interval2));
        } else if (JupyterDataInputCellTableMetadataKt.getHasTableMetadata(cell)) {
            DataContext dataContext4 = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext4, (String)"getDataContext(...)");
            EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor(dataContext4);
            if (editorImpl == null) {
                return;
            }
            EditorImpl editor = editorImpl;
            Project project = editor.getProject();
            if (project == null) {
                return;
            }
            Project project3 = project;
            WriteCommandAction.writeCommandAction((Project)project3).withName(e.getPresentation().getText()).run(() -> JupyterDataInputConvertToCodeAction.actionPerformed$lambda$1(editor, notebookFile));
        } else {
            return;
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private static final void actionPerformed$lambda$0(EditorImpl $editor, String $cellText, NotebookCellLines.Interval $interval) {
        NotebookCellConverter.Companion.replaceCellWithUndoSupport((Editor)$editor, $cellText, $interval, NotebookCellLines.Companion.get((Editor)$editor));
    }

    private static final void actionPerformed$lambda$1(EditorImpl $editor, BackedNotebookVirtualFile $notebookFile) {
        NotebookCellSelectionModel notebookCellSelectionModel = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)((Editor)$editor));
        if (notebookCellSelectionModel == null) {
            return;
        }
        NotebookCellSelectionModel cellSelectionModel = notebookCellSelectionModel;
        JupyterLangData jupyterLangData = JupyterLangData.Companion.getDataByJupyterCellType($notebookFile, JupyterCellType.SQL);
        if (jupyterLangData == null) {
            return;
        }
        JupyterLangData langData = jupyterLangData;
        NotebookCellConverter.Companion.convertCells((Editor)$editor, NotebookCellLines.Companion.get((Editor)$editor), cellSelectionModel, langData);
    }
}

