/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.detector;

import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.pdf417.detector.PDF417DetectorResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class Detector {
    private static final int[] INDEXES_START_PATTERN = new int[]{0, 4, 1, 5};
    private static final int[] INDEXES_STOP_PATTERN = new int[]{6, 2, 7, 3};
    private static final float MAX_AVG_VARIANCE = 0.42f;
    private static final float MAX_INDIVIDUAL_VARIANCE = 0.8f;
    private static final int[] START_PATTERN = new int[]{8, 1, 1, 1, 1, 1, 1, 3};
    private static final int[] STOP_PATTERN = new int[]{7, 1, 1, 3, 1, 1, 1, 2, 1};
    private static final int MAX_PIXEL_DRIFT = 3;
    private static final int MAX_PATTERN_DRIFT = 5;
    private static final int SKIPPED_ROW_COUNT_MAX = 25;
    private static final int ROW_STEP = 5;
    private static final int BARCODE_MIN_HEIGHT = 10;

    private Detector() {
    }

    public static PDF417DetectorResult detect(BinaryBitmap image, Map<DecodeHintType, ?> hints, boolean multiple) throws NotFoundException {
        BitMatrix bitMatrix = image.getBlackMatrix();
        List<ResultPoint[]> barcodeCoordinates = Detector.detect(multiple, bitMatrix);
        if (barcodeCoordinates.isEmpty()) {
            bitMatrix = bitMatrix.clone();
            bitMatrix.rotate180();
            barcodeCoordinates = Detector.detect(multiple, bitMatrix);
        }
        return new PDF417DetectorResult(bitMatrix, barcodeCoordinates);
    }

    private static List<ResultPoint[]> detect(boolean multiple, BitMatrix bitMatrix) {
        ArrayList<ResultPoint[]> barcodeCoordinates = new ArrayList<ResultPoint[]>();
        int row = 0;
        int column = 0;
        boolean foundBarcodeInRow = false;
        while (row < bitMatrix.getHeight()) {
            ResultPoint[] vertices = Detector.findVertices(bitMatrix, row, column);
            if (vertices[0] == null && vertices[3] == null) {
                if (!foundBarcodeInRow) break;
                foundBarcodeInRow = false;
                column = 0;
                for (ResultPoint[] barcodeCoordinate : barcodeCoordinates) {
                    if (barcodeCoordinate[1] != null) {
                        row = (int)Math.max((float)row, barcodeCoordinate[1].getY());
                    }
                    if (barcodeCoordinate[3] == null) continue;
                    row = Math.max(row, (int)barcodeCoordinate[3].getY());
                }
                row += 5;
                continue;
            }
            foundBarcodeInRow = true;
            barcodeCoordinates.add(vertices);
            if (!multiple) break;
            if (vertices[2] != null) {
                column = (int)vertices[2].getX();
                row = (int)vertices[2].getY();
                continue;
            }
            column = (int)vertices[4].getX();
            row = (int)vertices[4].getY();
        }
        return barcodeCoordinates;
    }

    private static ResultPoint[] findVertices(BitMatrix matrix, int startRow, int startColumn) {
        int height = matrix.getHeight();
        int width = matrix.getWidth();
        ResultPoint[] result = new ResultPoint[8];
        Detector.copyToResult(result, Detector.findRowsWithPattern(matrix, height, width, startRow, startColumn, START_PATTERN), INDEXES_START_PATTERN);
        if (result[4] != null) {
            startColumn = (int)result[4].getX();
            startRow = (int)result[4].getY();
        }
        Detector.copyToResult(result, Detector.findRowsWithPattern(matrix, height, width, startRow, startColumn, STOP_PATTERN), INDEXES_STOP_PATTERN);
        return result;
    }

    private static void copyToResult(ResultPoint[] result, ResultPoint[] tmpResult, int[] destinationIndexes) {
        for (int i = 0; i < destinationIndexes.length; ++i) {
            result[destinationIndexes[i]] = tmpResult[i];
        }
    }

    private static ResultPoint[] findRowsWithPattern(BitMatrix matrix, int height, int width, int startRow, int startColumn, int[] pattern) {
        int stopRow;
        Object[] result = new ResultPoint[4];
        boolean found = false;
        int[] counters = new int[pattern.length];
        while (startRow < height) {
            int[] loc = Detector.findGuardPattern(matrix, startColumn, startRow, width, false, pattern, counters);
            if (loc != null) {
                while (startRow > 0) {
                    int[] previousRowLoc;
                    if ((previousRowLoc = Detector.findGuardPattern(matrix, startColumn, --startRow, width, false, pattern, counters)) != null) {
                        loc = previousRowLoc;
                        continue;
                    }
                    ++startRow;
                    break;
                }
                result[0] = new ResultPoint(loc[0], startRow);
                result[1] = new ResultPoint(loc[1], startRow);
                found = true;
                break;
            }
            startRow += 5;
        }
        if (found) {
            int skippedRowCount = 0;
            int[] previousRowLoc = new int[]{(int)((ResultPoint)result[0]).getX(), (int)((ResultPoint)result[1]).getX()};
            for (stopRow = startRow + 1; stopRow < height; ++stopRow) {
                int[] loc = Detector.findGuardPattern(matrix, previousRowLoc[0], stopRow, width, false, pattern, counters);
                if (loc != null && Math.abs(previousRowLoc[0] - loc[0]) < 5 && Math.abs(previousRowLoc[1] - loc[1]) < 5) {
                    previousRowLoc = loc;
                    skippedRowCount = 0;
                    continue;
                }
                if (skippedRowCount > 25) break;
                ++skippedRowCount;
            }
            result[2] = new ResultPoint(previousRowLoc[0], stopRow -= skippedRowCount + 1);
            result[3] = new ResultPoint(previousRowLoc[1], stopRow);
        }
        if (stopRow - startRow < 10) {
            Arrays.fill(result, null);
        }
        return result;
    }

    private static int[] findGuardPattern(BitMatrix matrix, int column, int row, int width, boolean whiteFirst, int[] pattern, int[] counters) {
        int x;
        int patternStart;
        Arrays.fill(counters, 0, counters.length, 0);
        int pixelDrift = 0;
        for (patternStart = column; matrix.get(patternStart, row) && patternStart > 0 && pixelDrift++ < 3; --patternStart) {
        }
        int counterPosition = 0;
        int patternLength = pattern.length;
        boolean isWhite = whiteFirst;
        for (x = patternStart; x < width; ++x) {
            if (matrix.get(x, row) != isWhite) {
                int n = counterPosition;
                counters[n] = counters[n] + 1;
                continue;
            }
            if (counterPosition == patternLength - 1) {
                if (Detector.patternMatchVariance(counters, pattern, 0.8f) < 0.42f) {
                    return new int[]{patternStart, x};
                }
                patternStart += counters[0] + counters[1];
                System.arraycopy(counters, 2, counters, 0, counterPosition - 1);
                counters[counterPosition - 1] = 0;
                counters[counterPosition] = 0;
                --counterPosition;
            } else {
                ++counterPosition;
            }
            counters[counterPosition] = 1;
            isWhite = !isWhite;
        }
        if (counterPosition == patternLength - 1 && Detector.patternMatchVariance(counters, pattern, 0.8f) < 0.42f) {
            return new int[]{patternStart, x - 1};
        }
        return null;
    }

    private static float patternMatchVariance(int[] counters, int[] pattern, float maxIndividualVariance) {
        int numCounters = counters.length;
        int total = 0;
        int patternLength = 0;
        for (int i = 0; i < numCounters; ++i) {
            total += counters[i];
            patternLength += pattern[i];
        }
        if (total < patternLength) {
            return Float.POSITIVE_INFINITY;
        }
        float unitBarWidth = (float)total / (float)patternLength;
        maxIndividualVariance *= unitBarWidth;
        float totalVariance = 0.0f;
        for (int x = 0; x < numCounters; ++x) {
            float variance;
            int counter = counters[x];
            float scaledPattern = (float)pattern[x] * unitBarWidth;
            float f = variance = (float)counter > scaledPattern ? (float)counter - scaledPattern : scaledPattern - (float)counter;
            if (f > maxIndividualVariance) {
                return Float.POSITIVE_INFINITY;
            }
            totalVariance += variance;
        }
        return totalVariance / (float)total;
    }
}

