/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.internal;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.PessimisticLockScope;
import jakarta.persistence.Timeout;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.SimpleNaturalIdLoadAccess;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.loader.internal.BaseNaturalIdLoadAccessImpl;
import org.hibernate.loader.internal.LoadAccessContext;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.internal.SimpleNaturalIdMapping;

public class SimpleNaturalIdLoadAccessImpl<T>
extends BaseNaturalIdLoadAccessImpl<T>
implements SimpleNaturalIdLoadAccess<T> {
    private final boolean hasSimpleNaturalId;

    public SimpleNaturalIdLoadAccessImpl(LoadAccessContext context, EntityMappingType entityDescriptor) {
        super(context, entityDescriptor);
        this.hasSimpleNaturalId = entityDescriptor.getNaturalIdMapping() instanceof SimpleNaturalIdMapping;
    }

    @Override
    public LockOptions getLockOptions() {
        return super.getLockOptions();
    }

    @Override
    public boolean isSynchronizationEnabled() {
        return super.isSynchronizationEnabled();
    }

    @Override
    public SimpleNaturalIdLoadAccess<T> with(LockMode lockMode, PessimisticLockScope lockScope) {
        return (SimpleNaturalIdLoadAccess)super.with(lockMode, lockScope);
    }

    @Override
    public SimpleNaturalIdLoadAccess<T> with(Timeout timeout) {
        return (SimpleNaturalIdLoadAccess)super.with(timeout);
    }

    @Override
    public final SimpleNaturalIdLoadAccessImpl<T> with(LockOptions lockOptions) {
        return (SimpleNaturalIdLoadAccessImpl)super.with(lockOptions);
    }

    @Override
    public SimpleNaturalIdLoadAccessImpl<T> setSynchronizationEnabled(boolean synchronizationEnabled) {
        super.synchronizationEnabled(synchronizationEnabled);
        return this;
    }

    @Override
    public T getReference(Object naturalIdValue) {
        this.verifySimplicity(naturalIdValue);
        return this.doGetReference(this.entityPersister().getNaturalIdMapping().normalizeInput(naturalIdValue));
    }

    @Override
    public T load(Object naturalIdValue) {
        this.verifySimplicity(naturalIdValue);
        return this.doLoad(this.entityPersister().getNaturalIdMapping().normalizeInput(naturalIdValue));
    }

    private void verifySimplicity(Object naturalIdValue) {
        assert (naturalIdValue != null);
        if (!(this.hasSimpleNaturalId || naturalIdValue.getClass().isArray() || naturalIdValue instanceof List || naturalIdValue instanceof Map)) {
            throw new HibernateException(String.format(Locale.ROOT, "Cannot interpret natural id value [%s] as compound natural id of entity '%s'", naturalIdValue, this.entityPersister().getEntityName()));
        }
    }

    @Override
    public Optional<T> loadOptional(Object naturalIdValue) {
        return Optional.ofNullable(this.load(naturalIdValue));
    }

    @Override
    public SimpleNaturalIdLoadAccess<T> with(EntityGraph<T> graph, GraphSemantic semantic) {
        super.with(graph, semantic);
        return this;
    }

    @Override
    public SimpleNaturalIdLoadAccess<T> withLoadGraph(EntityGraph<T> graph) {
        return SimpleNaturalIdLoadAccess.super.withLoadGraph(graph);
    }

    @Override
    public SimpleNaturalIdLoadAccess<T> enableFetchProfile(String profileName) {
        super.enableFetchProfile(profileName);
        return this;
    }

    @Override
    public SimpleNaturalIdLoadAccess<T> disableFetchProfile(String profileName) {
        super.enableFetchProfile(profileName);
        return this;
    }
}

