/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrCompositionLayerBaseHeader;
import org.lwjgl.openxr.XrCompositionLayerDepthTestVARJO;
import org.lwjgl.openxr.XrCompositionLayerProjectionView;
import org.lwjgl.openxr.XrCompositionLayerReprojectionInfoMSFT;
import org.lwjgl.openxr.XrCompositionLayerReprojectionPlaneOverrideMSFT;
import org.lwjgl.openxr.XrSpace;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrCompositionLayerProjection
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int LAYERFLAGS;
    public static final int SPACE;
    public static final int VIEWCOUNT;
    public static final int VIEWS;

    public XrCompositionLayerProjection(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrCompositionLayerProjection.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrCompositionLayerProjection.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrCompositionLayerProjection.nnext(this.address());
    }

    @NativeType(value="XrCompositionLayerFlags")
    public long layerFlags() {
        return XrCompositionLayerProjection.nlayerFlags(this.address());
    }

    @NativeType(value="XrSpace")
    public long space() {
        return XrCompositionLayerProjection.nspace(this.address());
    }

    @NativeType(value="uint32_t")
    public int viewCount() {
        return XrCompositionLayerProjection.nviewCount(this.address());
    }

    @NativeType(value="XrCompositionLayerProjectionView const *")
    public XrCompositionLayerProjectionView.Buffer views() {
        return XrCompositionLayerProjection.nviews(this.address());
    }

    public XrCompositionLayerProjection type(@NativeType(value="XrStructureType") int value) {
        XrCompositionLayerProjection.ntype(this.address(), value);
        return this;
    }

    public XrCompositionLayerProjection type$Default() {
        return this.type(35);
    }

    public XrCompositionLayerProjection next(@NativeType(value="void const *") long value) {
        XrCompositionLayerProjection.nnext(this.address(), value);
        return this;
    }

    public XrCompositionLayerProjection next(XrCompositionLayerDepthTestVARJO value) {
        return this.next(value.next(this.next()).address());
    }

    public XrCompositionLayerProjection next(XrCompositionLayerReprojectionInfoMSFT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrCompositionLayerProjection next(XrCompositionLayerReprojectionPlaneOverrideMSFT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrCompositionLayerProjection layerFlags(@NativeType(value="XrCompositionLayerFlags") long value) {
        XrCompositionLayerProjection.nlayerFlags(this.address(), value);
        return this;
    }

    public XrCompositionLayerProjection space(XrSpace value) {
        XrCompositionLayerProjection.nspace(this.address(), value);
        return this;
    }

    public XrCompositionLayerProjection views(@NativeType(value="XrCompositionLayerProjectionView const *") XrCompositionLayerProjectionView.Buffer value) {
        XrCompositionLayerProjection.nviews(this.address(), value);
        return this;
    }

    public XrCompositionLayerProjection set(int type, long next, long layerFlags, XrSpace space, XrCompositionLayerProjectionView.Buffer views) {
        this.type(type);
        this.next(next);
        this.layerFlags(layerFlags);
        this.space(space);
        this.views(views);
        return this;
    }

    public XrCompositionLayerProjection set(XrCompositionLayerProjection src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrCompositionLayerProjection malloc() {
        return (XrCompositionLayerProjection)XrCompositionLayerProjection.wrap(XrCompositionLayerProjection.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrCompositionLayerProjection calloc() {
        return (XrCompositionLayerProjection)XrCompositionLayerProjection.wrap(XrCompositionLayerProjection.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrCompositionLayerProjection create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrCompositionLayerProjection)XrCompositionLayerProjection.wrap(XrCompositionLayerProjection.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrCompositionLayerProjection create(long address) {
        return (XrCompositionLayerProjection)XrCompositionLayerProjection.wrap(XrCompositionLayerProjection.class, (long)address);
    }

    @Nullable
    public static XrCompositionLayerProjection createSafe(long address) {
        return address == 0L ? null : (XrCompositionLayerProjection)XrCompositionLayerProjection.wrap(XrCompositionLayerProjection.class, (long)address);
    }

    public static XrCompositionLayerProjection create(XrCompositionLayerBaseHeader value) {
        return (XrCompositionLayerProjection)XrCompositionLayerProjection.wrap(XrCompositionLayerProjection.class, (Struct)value);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrCompositionLayerProjection.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrCompositionLayerProjection.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrCompositionLayerProjection.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrCompositionLayerProjection.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrCompositionLayerProjection.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrCompositionLayerProjection.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrCompositionLayerProjection.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static Buffer create(XrCompositionLayerBaseHeader.Buffer value) {
        return (Buffer)XrCompositionLayerProjection.wrap(Buffer.class, (CustomBuffer)value);
    }

    public static XrCompositionLayerProjection malloc(MemoryStack stack) {
        return (XrCompositionLayerProjection)XrCompositionLayerProjection.wrap(XrCompositionLayerProjection.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrCompositionLayerProjection calloc(MemoryStack stack) {
        return (XrCompositionLayerProjection)XrCompositionLayerProjection.wrap(XrCompositionLayerProjection.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrCompositionLayerProjection.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrCompositionLayerProjection.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static long nlayerFlags(long struct) {
        return UNSAFE.getLong(null, struct + (long)LAYERFLAGS);
    }

    public static long nspace(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SPACE));
    }

    public static int nviewCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)VIEWCOUNT);
    }

    public static XrCompositionLayerProjectionView.Buffer nviews(long struct) {
        return XrCompositionLayerProjectionView.create(MemoryUtil.memGetAddress((long)(struct + (long)VIEWS)), XrCompositionLayerProjection.nviewCount(struct));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    public static void nlayerFlags(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)LAYERFLAGS, value);
    }

    public static void nspace(long struct, XrSpace value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SPACE), (long)value.address());
    }

    public static void nviewCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VIEWCOUNT, value);
    }

    public static void nviews(long struct, XrCompositionLayerProjectionView.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)VIEWS), (long)value.address());
        XrCompositionLayerProjection.nviewCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)SPACE)));
        int viewCount = XrCompositionLayerProjection.nviewCount(struct);
        long views = MemoryUtil.memGetAddress((long)(struct + (long)VIEWS));
        Checks.check((long)views);
        XrCompositionLayerProjection.validate((long)views, (int)viewCount, (int)XrCompositionLayerProjectionView.SIZEOF, XrCompositionLayerProjectionView::validate);
    }

    static {
        Struct.Layout layout = XrCompositionLayerProjection.__struct((Struct.Member[])new Struct.Member[]{XrCompositionLayerProjection.__member((int)4), XrCompositionLayerProjection.__member((int)POINTER_SIZE), XrCompositionLayerProjection.__member((int)8), XrCompositionLayerProjection.__member((int)POINTER_SIZE), XrCompositionLayerProjection.__member((int)4), XrCompositionLayerProjection.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        LAYERFLAGS = layout.offsetof(2);
        SPACE = layout.offsetof(3);
        VIEWCOUNT = layout.offsetof(4);
        VIEWS = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrCompositionLayerProjection, Buffer>
    implements NativeResource {
        private static final XrCompositionLayerProjection ELEMENT_FACTORY = XrCompositionLayerProjection.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrCompositionLayerProjection getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrCompositionLayerProjection.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrCompositionLayerProjection.nnext(this.address());
        }

        @NativeType(value="XrCompositionLayerFlags")
        public long layerFlags() {
            return XrCompositionLayerProjection.nlayerFlags(this.address());
        }

        @NativeType(value="XrSpace")
        public long space() {
            return XrCompositionLayerProjection.nspace(this.address());
        }

        @NativeType(value="uint32_t")
        public int viewCount() {
            return XrCompositionLayerProjection.nviewCount(this.address());
        }

        @NativeType(value="XrCompositionLayerProjectionView const *")
        public XrCompositionLayerProjectionView.Buffer views() {
            return XrCompositionLayerProjection.nviews(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrCompositionLayerProjection.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(35);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrCompositionLayerProjection.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrCompositionLayerDepthTestVARJO value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrCompositionLayerReprojectionInfoMSFT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrCompositionLayerReprojectionPlaneOverrideMSFT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer layerFlags(@NativeType(value="XrCompositionLayerFlags") long value) {
            XrCompositionLayerProjection.nlayerFlags(this.address(), value);
            return this;
        }

        public Buffer space(XrSpace value) {
            XrCompositionLayerProjection.nspace(this.address(), value);
            return this;
        }

        public Buffer views(@NativeType(value="XrCompositionLayerProjectionView const *") XrCompositionLayerProjectionView.Buffer value) {
            XrCompositionLayerProjection.nviews(this.address(), value);
            return this;
        }
    }
}

