/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkCuFunctionCreateInfoNVX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MODULE;
    public static final int PNAME;

    public VkCuFunctionCreateInfoNVX(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkCuFunctionCreateInfoNVX.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCuFunctionCreateInfoNVX.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkCuFunctionCreateInfoNVX.npNext(this.address());
    }

    @NativeType(value="VkCuModuleNVX")
    public long module() {
        return VkCuFunctionCreateInfoNVX.nmodule(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer pName() {
        return VkCuFunctionCreateInfoNVX.npName(this.address());
    }

    @NativeType(value="char const *")
    public String pNameString() {
        return VkCuFunctionCreateInfoNVX.npNameString(this.address());
    }

    public VkCuFunctionCreateInfoNVX sType(@NativeType(value="VkStructureType") int value) {
        VkCuFunctionCreateInfoNVX.nsType(this.address(), value);
        return this;
    }

    public VkCuFunctionCreateInfoNVX sType$Default() {
        return this.sType(1000029001);
    }

    public VkCuFunctionCreateInfoNVX pNext(@NativeType(value="void const *") long value) {
        VkCuFunctionCreateInfoNVX.npNext(this.address(), value);
        return this;
    }

    public VkCuFunctionCreateInfoNVX module(@NativeType(value="VkCuModuleNVX") long value) {
        VkCuFunctionCreateInfoNVX.nmodule(this.address(), value);
        return this;
    }

    public VkCuFunctionCreateInfoNVX pName(@NativeType(value="char const *") ByteBuffer value) {
        VkCuFunctionCreateInfoNVX.npName(this.address(), value);
        return this;
    }

    public VkCuFunctionCreateInfoNVX set(int sType, long pNext, long module, ByteBuffer pName) {
        this.sType(sType);
        this.pNext(pNext);
        this.module(module);
        this.pName(pName);
        return this;
    }

    public VkCuFunctionCreateInfoNVX set(VkCuFunctionCreateInfoNVX src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkCuFunctionCreateInfoNVX malloc() {
        return (VkCuFunctionCreateInfoNVX)VkCuFunctionCreateInfoNVX.wrap(VkCuFunctionCreateInfoNVX.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkCuFunctionCreateInfoNVX calloc() {
        return (VkCuFunctionCreateInfoNVX)VkCuFunctionCreateInfoNVX.wrap(VkCuFunctionCreateInfoNVX.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkCuFunctionCreateInfoNVX create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkCuFunctionCreateInfoNVX)VkCuFunctionCreateInfoNVX.wrap(VkCuFunctionCreateInfoNVX.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkCuFunctionCreateInfoNVX create(long address) {
        return (VkCuFunctionCreateInfoNVX)VkCuFunctionCreateInfoNVX.wrap(VkCuFunctionCreateInfoNVX.class, (long)address);
    }

    @Nullable
    public static VkCuFunctionCreateInfoNVX createSafe(long address) {
        return address == 0L ? null : (VkCuFunctionCreateInfoNVX)VkCuFunctionCreateInfoNVX.wrap(VkCuFunctionCreateInfoNVX.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkCuFunctionCreateInfoNVX.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkCuFunctionCreateInfoNVX.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkCuFunctionCreateInfoNVX.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCuFunctionCreateInfoNVX.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkCuFunctionCreateInfoNVX.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkCuFunctionCreateInfoNVX.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkCuFunctionCreateInfoNVX.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkCuFunctionCreateInfoNVX malloc(MemoryStack stack) {
        return (VkCuFunctionCreateInfoNVX)VkCuFunctionCreateInfoNVX.wrap(VkCuFunctionCreateInfoNVX.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkCuFunctionCreateInfoNVX calloc(MemoryStack stack) {
        return (VkCuFunctionCreateInfoNVX)VkCuFunctionCreateInfoNVX.wrap(VkCuFunctionCreateInfoNVX.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkCuFunctionCreateInfoNVX.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkCuFunctionCreateInfoNVX.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static long nmodule(long struct) {
        return UNSAFE.getLong(null, struct + (long)MODULE);
    }

    public static ByteBuffer npName(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)PNAME)));
    }

    public static String npNameString(long struct) {
        return MemoryUtil.memUTF8((long)MemoryUtil.memGetAddress((long)(struct + (long)PNAME)));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nmodule(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MODULE, value);
    }

    public static void npName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)PNAME), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PNAME)));
    }

    static {
        Struct.Layout layout = VkCuFunctionCreateInfoNVX.__struct((Struct.Member[])new Struct.Member[]{VkCuFunctionCreateInfoNVX.__member((int)4), VkCuFunctionCreateInfoNVX.__member((int)POINTER_SIZE), VkCuFunctionCreateInfoNVX.__member((int)8), VkCuFunctionCreateInfoNVX.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MODULE = layout.offsetof(2);
        PNAME = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkCuFunctionCreateInfoNVX, Buffer>
    implements NativeResource {
        private static final VkCuFunctionCreateInfoNVX ELEMENT_FACTORY = VkCuFunctionCreateInfoNVX.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkCuFunctionCreateInfoNVX getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCuFunctionCreateInfoNVX.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkCuFunctionCreateInfoNVX.npNext(this.address());
        }

        @NativeType(value="VkCuModuleNVX")
        public long module() {
            return VkCuFunctionCreateInfoNVX.nmodule(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer pName() {
            return VkCuFunctionCreateInfoNVX.npName(this.address());
        }

        @NativeType(value="char const *")
        public String pNameString() {
            return VkCuFunctionCreateInfoNVX.npNameString(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCuFunctionCreateInfoNVX.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000029001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCuFunctionCreateInfoNVX.npNext(this.address(), value);
            return this;
        }

        public Buffer module(@NativeType(value="VkCuModuleNVX") long value) {
            VkCuFunctionCreateInfoNVX.nmodule(this.address(), value);
            return this;
        }

        public Buffer pName(@NativeType(value="char const *") ByteBuffer value) {
            VkCuFunctionCreateInfoNVX.npName(this.address(), value);
            return this;
        }
    }
}

